<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Matemática Virtual, Ing.MSc. Fernando Carrillo & Ing.MSc. Cecilia Izurieta</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <script src="https://polyfill.io/v3/polyfill.min.js?features=es6"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    
</head>
<body>
    <?php include 'encabezado.php'; ?>
    <main>
        <?php include 'menui.php'; ?>
<div class="container my-5">
        <h1 class="mb-4 text-center">Ejercicios de Triángulos Rectángulos con Ángulos Notables</h1>

        <?php
        // Array con ejercicios: cada ejercicio es un array con enunciado y tipo
        $ejercicios = [
            [
                "titulo" => "Ejercicio 1",
                "enunciado" => "Dado un triángulo rectángulo \\( \\triangle ABC \\) con el cateto \\( a = 5 \\text{ cm} \\) y el ángulo \\( A = 30^\\circ \\), calcula todos sus elementos: \\( a, b, c, A, B, C \\)."
            ],
            [
                "titulo" => "Ejercicio 2",
                "enunciado" => "En un triángulo rectángulo \\( \\triangle ABC \\), la hipotenusa \\( c = 14 \\text{ cm} \\) y el ángulo \\( B = 45^\\circ \\). Calcula todos los lados y los ángulos del triángulo."
            ],
            [
                "titulo" => "Ejercicio 3",
                "enunciado" => "El triángulo rectángulo \\( \\triangle ABC \\) tiene un cateto \\( b = 9 \\text{ cm} \\) y el ángulo \\( B = 60^\\circ \\). Determina todos sus elementos."
            ],
            [
                "titulo" => "Ejercicio 4",
                "enunciado" => "En un triángulo rectángulo, el ángulo \\( A = 45^\\circ \\) y el cateto \\( b = 12 \\text{ cm} \\). Calcula todos los elementos del triángulo."
            ],
            [
                "titulo" => "Ejercicio 5",
                "enunciado" => "En \\( \\triangle ABC \\), la hipotenusa mide \\( c = 20 \\text{ cm} \\) y el ángulo \\( A = 30^\\circ \\). Encuentra todos los lados y ángulos."
            ],
            [
                "titulo" => "Ejercicio 6",
                "enunciado" => "Dado un triángulo rectángulo con catetos iguales \\( a = b = 7 \\text{ cm} \\), determina todos los elementos del triángulo."
            ],
            [
                "titulo" => "Ejercicio 7",
                "enunciado" => "En \\( \\triangle ABC \\), el cateto \\( a = 10 \\text{ cm} \\) y el ángulo \\( B = 60^\\circ \\). Calcula todos los elementos del triángulo."
            ],
            [
                "titulo" => "Ejercicio 8",
                "enunciado" => "Se tiene un triángulo rectángulo con hipotenusa \\( c = 8 \\text{ cm} \\) y cateto \\( a = 4 \\text{ cm} \\). Calcula todos sus elementos."
            ],
            [
                "titulo" => "Ejercicio 9",
                "enunciado" => "El triángulo rectángulo \\( \\triangle ABC \\) tiene el cateto \\( b = 5 \\text{ cm} \\) y el ángulo \\( A = 30^\\circ \\). Calcula todos los elementos."
            ],
            [
                "titulo" => "Ejercicio 10",
                "enunciado" => "En un triángulo rectángulo, la hipotenusa mide \\( c = 18 \\text{ cm} \\) y el ángulo \\( B = 45^\\circ \\). Calcula todos los lados y ángulos."
            ],
        ];

        foreach ($ejercicios as $index => $ejercicio) {
            echo '<div class="card mb-3">';
            echo '<div class="card-header bg-primary text-white">';
            echo '<h5>' . $ejercicio["titulo"] . '</h5>';
            echo '</div>';
            echo '<div class="card-body">';
            echo '<p class="card-text" style="font-size:1.1rem;">' . $ejercicio["enunciado"] . '</p>';
            echo '</div>';
            echo '</div>';
        }
        ?>
    </div>

    <!-- Bootstrap JS (opcional, para componentes interactivos) -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>Ejercicios de Trigonometría Aplicada</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" />
    <!-- MathJax para LaTeX -->
    <script src="https://polyfill.io/v3/polyfill.min.js?features=es6"></script>
    <script id="MathJax-script" async
      src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
</head>
<body>
    <div class="container my-5">
        <h1 class="mb-4 text-center">Ejercicios de Trigonometría Aplicada</h1>

        <?php
        $ejercicios = [
            "Calcula el área de un triángulo rectángulo cuyos catetos miden \\(6\\,m\\) y \\(8\\,m\\).",
            "Un poste vertical de \\(10\\,m\\) proyecta una sombra de \\(7\\,m\\). ¿Cuál es el ángulo de elevación del sol? (Usa trigonometría).",
            "Calcula el perímetro de un triángulo rectángulo cuyos catetos miden \\(9\\,cm\\) y \\(12\\,cm\\).",
            "Una escalera de \\(15\\,m\\) está apoyada contra una pared formando un ángulo de \\(60^\\circ\\) con el suelo. ¿A qué altura llega la escalera en la pared?",
            "Calcula el área de un triángulo rectángulo si la hipotenusa mide \\(13\\,m\\) y uno de los ángulos agudos es \\(30^\\circ\\).",
            "Un edificio proyecta una sombra de \\(24\\,m\\) cuando el ángulo de elevación del sol es de \\(45^\\circ\\). ¿Cuál es la altura del edificio?",
            "Calcula el perímetro de un triángulo rectángulo con hipotenusa \\(20\\,cm\\) y un cateto de \\(12\\,cm\\).",
            "Un avión vuela a \\(500\\,m\\) de altura y observa un objeto en tierra con un ángulo de depresión de \\(30^\\circ\\). ¿A qué distancia horizontal se encuentra el objeto?",
            "Calcula el área de un triángulo rectángulo cuyos catetos son \\(5\\,cm\\) y \\(12\\,cm\\).",
            "Una torre proyecta una sombra de \\(15\\,m\\) y el ángulo de elevación del sol es \\(60^\\circ\\). Calcula la altura de la torre.",
            "Calcula la longitud de la sombra de un edificio de \\(25\\,m\\) cuando el sol está a un ángulo de \\(30^\\circ\\) sobre el horizonte.",
            "Una rampa forma un ángulo de \\(20^\\circ\\) con el suelo y tiene una longitud de \\(10\\,m\\). ¿Cuál es la altura que alcanza la rampa?",
            "Calcula el perímetro de un triángulo rectángulo con lados \\(7\\,cm\\) y \\(24\\,cm\\).",
            "Una persona mide su sombra y mide \\(2\\,m\\) cuando el ángulo de elevación del sol es \\(60^\\circ\\). ¿Cuál es su altura?",
            "Calcula el área de un triángulo rectángulo con catetos de \\(9\\,m\\) y \\(40\\,m\\).",
            "Una antena de \\(30\\,m\\) proyecta una sombra de \\(17.3\\,m\\). Calcula el ángulo de elevación del sol.",
            "Calcula la altura de una torre si su sombra mide \\(40\\,m\\) y el ángulo de elevación del sol es \\(45^\\circ\\).",
            "Un triángulo rectángulo tiene un cateto de \\(8\\,cm\\) y la hipotenusa mide \\(17\\,cm\\). Calcula el perímetro y el área.",
            "Un poste de luz proyecta una sombra que mide \\(10\\,m\\) cuando el ángulo de elevación del sol es \\(37^\\circ\\). ¿Cuál es la altura del poste?",
            "Calcula el área y perímetro de un triángulo rectángulo si la hipotenusa mide \\(25\\,m\\) y uno de sus catetos mide \\(7\\,m\\).",
        ];

        foreach ($ejercicios as $index => $ejercicio) {
            echo '<div class="card mb-3">';
            echo '<div class="card-header bg-info text-white">';
            echo '<h5>Ejercicio ' . ($index + 1) . '</h5>';
            echo '</div>';
            echo '<div class="card-body">';
            echo '<p style="font-size:1.1rem;">' . $ejercicio . '</p>';
            echo '</div>';
            echo '</div>';
        }
        ?>
    </div>

<script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.3/dist/umd/popper.min.js"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
<script>
    MathJax.typeset();
</script>
</main>
 <?php include 'subir.php'; ?>
</body>
</html>
