<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Matemática Virtual, Ing.MSc. Fernando Carrillo & Ing.MSc. Cecilia Izurieta</title>
  <link href="../bootstrap/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
  <?php include 'encabezado.php'; ?>
  <main>
    <?php include 'menui.php'; ?>
    <div class="container mt-5 overflow-auto">
    <h1 class="mb-4">Ejercicios de Teorema de Pitágoras</h1>
    <div class="row">
      <?php 
        for ($i = 1; $i <= $n; $i++) {
          $ejercicio = rand(1, 20);
          $cateto1 = rand(1, 20);
          $cateto2 = rand(1, 20);
          $hipotenusa = rand(1, 30);
          $altura = rand(1, 15);
          $base = rand(1, 20);
          $lado1 = rand(1, 30);
          $lado2 = rand(1, 40);
          $altura_globo = rand(100, 300);
          $desplazamiento_horizontal = rand(100, 500);
          $angulo_poste = rand(30, 80);
          $distancia_base = rand(5, 20);
          $altura_poste = $distancia_base * tan(deg2rad($angulo_poste));
          $diagonal_piscina = sqrt(pow(6, 2) + pow(10, 2) + pow(2, 2));
          $distancia_punto = sqrt(pow(5, 2) + pow($altura_poste, 2));
      ?>
      
        <div class="card mb-4">
          
            <h5 class="card-title">Ejercicio <?php echo $i; ?></h5>
            <?php 
              switch($ejercicio) {
                case 1:
                  echo "<p class='card-text'>Un parque tiene forma rectangular con una longitud de $lado1 metros y una anchura de  $lado2;  metros. ¿Cuánto mide la diagonal del parque?</p>";
                  ;
                  break;
                case 2:
                  echo "<p class='card-text'>Un poste de luz está ubicado a  $altura;  metros de un edificio. Si el poste y el edificio forman un ángulo recto, ¿cuánto mide la altura del edificio?</p>";
                  break;
                case 3:
                  echo "<p class='card-text'>Un triángulo rectángulo tiene un cateto de longitud  $cateto1;  cm y la hipotenusa mide  $hipotenusa;  cm. ¿Cuánto mide el otro cateto?</p>";
                  break;
                case 4:
                  echo "<p class='card-text'>Un avión despega desde un aeropuerto y vuela  $base;  kilómetros hacia el este y luego  $altura;  kilómetros hacia el norte. ¿Cuál es la distancia directa entre el aeropuerto y la ubicación actual del avión?</p>";
                  break;
                case 5:
                  echo "<p class='card-text'>Un terreno tiene forma rectangular con lados de longitud  $cateto1;  metros y  $cateto2;  metros. ¿Cuál es la longitud de la cerca diagonal que se necesita para rodear el terreno?</p>";
                  break;
                   case 6:
                  echo "<p class='card-text'>Un globo aerostático se eleva verticalmente desde el suelo. Después de ascender  $altura_globo;  metros, se displaza horizontalmente  $desplazamiento_horizontal;  metros. ¿Cuál es la distancia entre el punto de despegue y la posición actual del globo?</p>";
                    break;
                
                case 7:
                echo "<p class='card-text'>En un triángulo rectángulo, uno de los catetos mide  $cateto1;  cm y la hipotenusa mide  $hipotenusa;  cm. ¿Cuánto mide el otro cateto?</p>";
                break;
                case 8:
                echo "<p class='card-text'>Una escalera de  $lado1;  metros de longitud está apoyada contra una pared. Si la base de la escalera está a  $base;  metros de la pared, ¿cuántos metros está la parte superior de la escalera por encima del suelo?</p>";
                break;
                case 9:
                echo "<p class='card-text'>Un poste inclinado forma un ángulo de  $angulo_poste;  grados con el suelo. Si la distancia desde la base del poste hasta el edificio más cercano es de  $distancia_base;  metros, ¿cuántos metros mide el poste?</p>";
                break;
                case 10:
                echo "<p class='card-text'>Un cable está tendido desde la parte superior de una torre de radio de  $altura;  metros de altura hasta un punto en el suelo a  $base;  metros de la base de la torre. ¿Cuántos metros mide el cable?</p>";
                break;
                case 11:
                echo "<p class='card-text'>Un triángulo rectángulo tiene un cateto de longitud  $cateto1;  cm y otro cateto de longitud  $cateto2;  cm. ¿Cuál es la longitud de la hipotenusa?</p>";
                break;
                case 12:
                echo "<p class='card-text'>Un agricultor tiene un campo cuadrado con lados de longitud  $lado1;  metros. ¿Cuánto mide la diagonal del campo?</p>";
                break;
                case 13:
                echo "<p class='card-text'>Un nadador sale de una orilla y nada  $base;  metros hacia el norte y luego  $altura;  metros hacia el este. ¿Cuál es la distancia directa entre el punto de partida y la posición actual del nadador?</p>";
                break;
                case 14:
                echo "<p class='card-text'>Un poste de luz está ubicado a  $base;  metros de un edificio. Si la altura del edificio es de  $altura;  metros, ¿cuánto mide la distancia entre la parte superior del poste y la parte superior del edificio?</p>";
                break;
                case 15:
                echo "<p class='card-text'>Un triángulo rectángulo tiene un cateto de longitud  $cateto1;  cm y la hipotenusa mide  $hipotenusa;  cm. ¿Cuánto mide el otro cateto?</p>";
                
                break;
                case 16:
                echo "<p class='card-text'>Una escalera de  $lado1;  metros de longitud está apoyada contra una pared. Si la parte superior de la escalera está a  $altura;  metros del suelo, ¿cuánto mide la distancia desde la base de la escalera hasta la pared?</p>";
                
                break;
                case 17:
                echo "<p class='card-text'>Un globo aerostático se eleva verticalmente desde el suelo y alcanza una altura de  $altura_globo;  metros. Si se desplaza horizontalmente  $desplazamiento_horizontal;  metros, ¿cuál es la distancia entre el punto de despegue y la posición actual del globo?</p>";
                
                break;
                case 18:
                echo "<p class='card-text'>Un triángulo rectángulo tiene un cateto de longitud  $cateto1;  cm y la hipotenusa mide  $hipotenusa;  cm. ¿Cuánto mide el otro cateto?</p>";
                
                break;
                case 19:
                echo "<p class='card-text'>Una piscina rectangular tiene dimensiones de  $lado1;  metros de ancho,  $lado2;  metros de largo y  $altura;  metros de profundidad. ¿Cuántos metros mide la diagonal desde una esquina en el fondo de la piscina hasta la esquina opuesta en la superficie?</p>";
                
                break;
                
case 20:
echo "<p class='card-text'>Un cable está tendido desde la parte superior de un poste de luz de  $altura;  metros de altura hasta un punto en el suelo a  $base;  metros de la base del poste. ¿Cuántos metros mide el cable?</p>";

// Los casos restantes de ejercicios
}
?>

</div>
<?php } ?>
</main>
<script>
        // Capturar el evento de clic en el botón de descarga
        document.getElementById('btnDescargarPDF').addEventListener('click', function() {
            // Seleccionar el contenedor de ejercicios
            var element = document.querySelector('.list-group');

            // Opciones para la generación del PDF
            var options = {
                margin:       0.5,
                filename:     'ejercicios.pdf',
                image:        { type: 'jpeg', quality: 0.98 },
                html2canvas:  { scale: 3 },
                jsPDF:        { unit: 'in', format: 'A4', orientation: 'portrait' }
            };

            // Generar el PDF
            html2pdf().from(element).set(options).save();
        });
    </script>

    <!-- Agregar referencia a la biblioteca html2pdf -->
    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.3/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    </main>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/html2pdf.js/0.9.2/html2pdf.bundle.min.js"></script>
    </main>
    <?php include 'subir.php'; ?>
</body>
</html>