<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Matemática Virtual, Ing.MSc. Fernando Carrillo & Ing.MSc. Cecilia Izurieta</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://polyfill.io/v3/polyfill.min.js?features=es6"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        body {
            padding-top: 4.5rem;
        }
        .header {
            background-color: #f8f9fa;
            padding: 2rem;
            border-bottom: 2px solid #e9ecef;
        }
        .navbar-nav {
            margin-left: auto;
        }
        .nav-link {
            color: #007bff !important;
        }
        .nav-link.active {
            font-weight: bold;
            color: #000 !important;
        }
        .card-header {
            background-color: #007bff;
            color: #fff;
        }
        .list-group-item {
            border: none;
            padding-left: 0;
        }
    </style>
</head>
<body>
    <?php include 'encabezado.php'; ?>
    <nav class="navbar navbar-expand-lg navbar-light bg-light fixed-top">
        <div class="container-fluid">
            <a class="navbar-brand" href="#">Matemáticas Divertidas</a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto">
                    <li class="nav-item">
                        <a class="nav-link active" aria-current="page" href="#conceptos-basicos">Conceptos Básicos</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#propiedades-operaciones">Propiedades</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#aplicaciones">Aplicaciones</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#ejemplos">Ejemplos</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#operaciones-combinadas">Operaciones Combinadas</a>
                    </li>
                </ul>
            </div>
        </div>
    </nav>

    <div class="container">
        <header class="header text-center my-4">
            <h1>Operaciones con Números Enteros</h1>
            <p class="lead">Aprende las operaciones fundamentales con números enteros y sus aplicaciones.</p>
        </header>
        
        <main>
             <div class="card-body">
            <p>Las operaciones combinadas involucran diferentes operaciones aritméticas dentro de paréntesis, corchetes o llaves. Es importante recordar la regla de precedencia de operaciones: primero se resuelven los paréntesis, luego los corchetes y finalmente las llaves. Dentro de cada nivel de paréntesis, se sigue la misma regla de precedencia que en las operaciones aritméticas básicas (de izquierda a derecha).</p>
            <h3>Ejemplo:</h3>
            <p>Resuelve la siguiente expresión:</p>
            <p>\[ 3 \times (5 - 2) + 4 \]</p>
            <p>Primero, se resuelve lo que está dentro del paréntesis:</p>
            <p>\[ 3 \times (5 - 2) + 4 = 3 \times 3 + 4 \]</p>
            <p>Luego, se realiza la multiplicación y la adición:</p>
            <p>\[ 3 \times 3 + 4 = 9 + 4 = 13 \]</p>
            <p>Por lo tanto, el resultado de la expresión es \( 13 \).</p>
            <h3>Aplicaciones de Operaciones Combinadas:</h3>
            <p>Las operaciones combinadas son fundamentales en diversas áreas:</p>
            <ul class="list-group">
                <li class="list-group-item"><strong>Matemáticas:</strong> Se utilizan para resolver problemas complejos que implican múltiples operaciones aritméticas.</li>
                <li class="list-group-item"><strong>Física:</strong> En problemas de física, las ecuaciones pueden requerir operaciones combinadas para calcular cantidades como velocidad, aceleración o fuerza.</li>
                <li class="list-group-item"><strong>Ingeniería:</strong> Los ingenieros utilizan operaciones combinadas para resolver problemas de diseño y análisis en diversas disciplinas como la mecánica, la electrónica y la ingeniería civil.</li>
                <li class="list-group-item"><strong>Economía:</strong> En la economía y las finanzas, las operaciones combinadas se utilizan para analizar datos financieros, calcular tasas de interés y proyecciones económicas.</li>
                <li class="list-group-item"><strong>Computación:</strong> En programación, las operaciones combinadas son esenciales para escribir algoritmos eficientes y resolver problemas computacionales complejos.</li>
                <li class="list-group-item"><strong>Ciencias Sociales:</strong> En áreas como la estadística y la investigación social, las operaciones combinadas se utilizan para analizar datos y realizar inferencias.</li>
            </ul>
        </div>
        </main>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.10.2/dist/umd/popper.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.min.js"></script>
    <?php include 'subir.php'; ?>
</body>
</html>
