<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ejercicios de Razonamiento Matemático</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://polyfill.io/v3/polyfill.min.js?features=es6"></script>
    <script type="text/javascript" id="MathJax-script" async
            src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
</head>
<body>
    <?php include 'encabezado.php'; ?>
<div class="container mt-5">
    <h1 class="text-center mb-4">Ejercicios de Razonamiento Matemático</h1>

    <!-- Ejercicio 1 -->
    <div class="card mb-3">
        <div class="card-body">
            <h5 class="card-title">Problema de Edad</h5>
            <p class="card-text">
                La suma de las edades de Ana y su madre es de 50 años. La edad de la madre es el triple de la edad de Ana. ¿Qué edad tiene cada una?
            </p>
            <p class="card-text">
                <strong>Solución:</strong> <br>
                Sea \( A \) la edad de Ana y \( M \) la edad de su madre.
                Tenemos dos ecuaciones:
                \[
                A + M = 50 \\
                M = 3A
                \]
                Sustituyendo \( M \) en la primera ecuación:
                \[
                A + 3A = 50 \\
                4A = 50 \\
                A = 12.5
                \]
                Entonces, \( M = 3 \times 12.5 = 37.5 \). <br>
                Ana tiene 12.5 años y su madre 37.5 años.
            </p>
        </div>
    </div>

    <!-- Ejercicio 2 -->
    <div class="card mb-3">
        <div class="card-body">
            <h5 class="card-title">Problema de Dinero</h5>
            <p class="card-text">
                Si Pedro tiene el doble de dinero que Juan y entre los dos tienen 60 dólares, ¿cuánto dinero tiene cada uno?
            </p>
            <p class="card-text">
                <strong>Solución:</strong> <br>
                Sea \( J \) la cantidad de dinero que tiene Juan y \( P \) la cantidad de dinero que tiene Pedro.
                Tenemos dos ecuaciones:
                \[
                P = 2J \\
                J + P = 60
                \]
                Sustituyendo \( P \) en la segunda ecuación:
                \[
                J + 2J = 60 \\
                3J = 60 \\
                J = 20
                \]
                Entonces, \( P = 2 \times 20 = 40 \). <br>
                Juan tiene 20 dólares y Pedro 40 dólares.
            </p>
        </div>
    </div>

    <!-- Ejercicio 3 -->
    <div class="card mb-3">
        <div class="card-body">
            <h5 class="card-title">Problema de Velocidades</h5>
            <p class="card-text">
                Un coche viaja 60 km/h durante 2 horas y luego a 80 km/h durante 3 horas. ¿Cuál es la velocidad media del viaje?
            </p>
            <p class="card-text">
                <strong>Solución:</strong> <br>
                Primero, calculamos la distancia recorrida en cada tramo:
                \[
                \text{Distancia 1} = 60 \, \text{km/h} \times 2 \, \text{h} = 120 \, \text{km} \\
                \text{Distancia 2} = 80 \, \text{km/h} \times 3 \, \text{h} = 240 \, \text{km}
                \]
                La distancia total es:
                \[
                120 \, \text{km} + 240 \, \text{km} = 360 \, \text{km}
                \]
                El tiempo total es:
                \[
                2 \, \text{h} + 3 \, \text{h} = 5 \, \text{h}
                \]
                La velocidad media es:
                \[
                \text{Velocidad media} = \frac{\text{Distancia total}}{\text{Tiempo total}} = \frac{360 \, \text{km}}{5 \, \text{h}} = 72 \, \text{km/h}
                \]
            </p>
        </div>
    </div>

    <!-- Ejercicio 4 -->
    <div class="card mb-3">
        <div class="card-body">
            <h5 class="card-title">Problema de Fracciones</h5>
            <p class="card-text">
                ¿Cuál es el resultado de \( \frac{3}{4} + \frac{5}{6} \)?
            </p>
            <p class="card-text">
                <strong>Solución:</strong> <br>
                Para sumar fracciones, primero debemos encontrar un denominador común. El mínimo común múltiplo de 4 y 6 es 12.
                Convertimos cada fracción:
                \[
                \frac{3}{4} = \frac{3 \times 3}{4 \times 3} = \frac{9}{12} \\
                \frac{5}{6} = \frac{5 \times 2}{6 \times 2} = \frac{10}{12}
                \]
                Sumamos las fracciones:
                \[
                \frac{9}{12} + \frac{10}{12} = \frac{19}{12}
                \]
                El resultado es \( \frac{19}{12} \) o \( 1 \frac{7}{12} \).
            </p>
        </div>
    </div>

    <!-- Ejercicio 5 -->
    <div class="card mb-3">
        <div class="card-body">
            <h5 class="card-title">Problema de Series</h5>
            <p class="card-text">
                Encuentra el siguiente número en la serie: 2, 6, 12, 20, 30, ...
            </p>
            <p class="card-text">
                <strong>Solución:</strong> <br>
                Observamos la serie:
                <ul>
                    <li>2</li>
                    <li>6</li>
                    <li>12</li>
                    <li>20</li>
                    <li>30</li>
                </ul>
                La diferencia entre términos consecutivos es:
                \[
                6 - 2 = 4 \\
                12 - 6 = 6 \\
                20 - 12 = 8 \\
                30 - 20 = 10
                \]
                Las diferencias (4, 6, 8, 10) aumentan en 2 cada vez. Entonces, la siguiente diferencia será 12.
                Por lo tanto, el siguiente número en la serie es:
                \[
                30 + 12 = 42
                \]
                El siguiente número es 42.
            </p>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.6/dist/umd/popper.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.min.js"></script>
<?php include 'pie.php'; ?>
</body>
</html>
