<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Matemática Virtual, Ing.MSc. Fernando Carrillo & Ing.MSc. Cecilia Izurieta</title>
    <!-- Bootstrap CSS -->
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
    <?php include 'encabezado.php'; ?>
    <div class="container mt-5">
        <h3 class="mb-4">Ejercicios de Operaciones Combinadas</h3>
        <div class="mt-4">
            <?php
                function generateExpression() {
                    $operators = ['+', '-', '*', '/', '^', '√'];
                    $expression = "";
                    $numTerms = rand(3, 5); // Number of terms in the expression

                    // Start with a number or a sub-expression
                    $expression .= generateSubExpression($operators);

                    for ($i = 1; $i < $numTerms; $i++) {
                        $operator = $operators[array_rand($operators)];
                        $expression .= " $operator " . generateSubExpression($operators);
                    }

                    // Evaluate the expression safely
                    $result = evaluateExpression($expression);

                    return [$expression, $result];
                }

                function generateSubExpression($operators) {
                    $types = ['number', 'paren', 'bracket', 'brace'];
                    $type = $types[array_rand($types)];

                    switch ($type) {
                        case 'number':
                            return rand(-10, 10);
                        case 'paren':
                            return '(' . generateExpressionPart($operators) . ')';
                        case 'bracket':
                            return '[' . generateExpressionPart($operators) . ']';
                        case 'brace':
                            return '{' . generateExpressionPart($operators) . '}';
                    }
                }

                function generateExpressionPart($operators) {
                    $num1 = rand(-10, 10);
                    $num2 = rand(1, 10); // Avoid zero for division
                    $operator = $operators[array_rand($operators)];

                    switch ($operator) {
                        case '^':
                            return "$num1 ^ $num2";
                        case '√':
                            return "√$num2";
                        default:
                            return "$num1 $operator $num2";
                    }
                }

                function evaluateExpression($expression) {
                    $expression = str_replace(['[', ']', '{', '}'], ['(', ')', '(', ')'], $expression); // Convert all brackets to parentheses
                    $expression = str_replace('^', '**', $expression); // Convert ^ to ** for PHP
                    $expression = preg_replace('/√(\d+)/', 'sqrt($1)', $expression); // Convert √ to sqrt function

                    $result = 0;
                    try {
                        eval('$result = ' . $expression . ';');
                    } catch (Throwable $e) {
                        return "Error";
                    }

                    return $result;
                }

                for ($i = 1; $i <= $n; $i++) {
                    list($expression, $result) = generateExpression();
                    echo "<div class='card mb-3'>";
                    echo "<div class='card-body'>";
                    echo "<h5 class='card-title'>Ejercicio $i</h5>";
                    echo "<p class='card-text'>Expresión: \\( $expression \\)</p>";
                    echo "<p class='card-text'>Resultado: \\( $result \\)</p>";
                    echo "</div>";
                    echo "</div>";
                }
            ?>
        </div>
    </div>
    
    <!-- MathJax -->
    <script src="https://polyfill.io/v3/polyfill.min.js?features=es6"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
     <?php include 'subir.php'; ?>
</body>
</html>
