<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Matemática Virtual - Inecuaciones Avanzadas MCM</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <script src="https://polyfill.io/v3/polyfill.min.js?features=es6"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        body { background-color: #f8f9fa; }
        .card { margin-bottom: 20px; border-left: 5px solid #e67e22; }
        .section-title { margin-top: 30px; color: #2c3e50; border-bottom: 2px solid #e67e22; padding-bottom: 10px; }
        .card-title { color: #d35400; font-weight: bold; }
    </style>
</head>
<body>
  <?php  include 'encabezado.php'; ?>
    
        <?php  include 'menui.php'; ?>
    <main class="container mt-4">
       

        <?php
        $n = 3; 

        // 1. Generación de Inecuaciones Cuadráticas
        function generarCuadratica() {
            $a = rand(1, 2); 
            $x1 = rand(-4, 4);
            $x2 = rand(-4, 4);
            $b = -$a * ($x1 + $x2);
            $c = $a * ($x1 * $x2);
            $op = ['>', '≥', '<', '≤'][rand(0, 3)];
            return $a . "x^2 " . ($b >= 0 ? "+ " : "- ") . abs($b) . "x " . ($c >= 0 ? "+ " : "- ") . abs($c) . " " . $op . " 0";
        }

        // 2. Generación de Valor Absoluto
        function generarValorAbsoluto() {
            $a = rand(2, 6);
            $b = rand(-10, 10);
            $c = rand(2, 20);
            $op = ['<', '≤', '>', '≥'][rand(0, 3)];
            return "| " . $a . "x " . ($b >= 0 ? "+ " : "- ") . abs($b) . " | " . $op . " " . $c;
        }

        function mostrarBloque($titulo, $funcion, $cantidad) {
            echo "<h4 class='section-title'>$titulo</h4><div class='row'>";
            for ($i = 0; $i < $cantidad; $i++) {
                $ejercicio = $funcion();
                echo "<div class='col-md-4'><div class='card shadow-sm'><div class='card-body'>";
                echo "<h6 class='card-title'>Reto " . ($i + 1) . "</h6>";
                echo "<p class='card-text text-center' style='font-size: 1.3rem;'>\(" . $ejercicio . "\)</p>";
                echo "</div></div></div>";
            }
            echo "</div>";
        }

        mostrarBloque("I. Inecuaciones de Segundo Grado", "generarCuadratica", $n);
        mostrarBloque("II. Inecuaciones con Valor Absoluto", "generarValorAbsoluto", $n);
        ?>
    </main>
<?php include 'subir.php'; ?>
    <script>
        MathJax.typeset();
    </script>
</body>
</html>