<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Matemática Virtual, Ing.MSc. Fernando Carrillo & Ing.MSc. Cecilia Izurieta</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <script src="https://polyfill.io/v3/polyfill.min.js?features=es6"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
       
    </style>
</head>
<body>
    <?php include 'encabezado.php'; ?>
    <main>
        <?php include 'menui.php'; ?>
        <div class="container">
            <h3 >Inecuaciones con dos incognitas </h3>
             <h10 >Graficar la solución de las siguinetes Inecuaciones</h10>
            <div class="row">
                <?php
                $n=round($n/2)+2;

                function generarTermino($variable) {
                    $coef = rand(-10, 10);
                    if ($coef == 0) {
                        $coef = 1; // Evitar que el coeficiente sea 0
                    }
                    return ($coef == 1 && $variable != '' ? '' : $coef) . $variable;
                }

                function generarLado($variables1) {
                    $numTerminos = 1;  // Generar de 1 a 5 términos
                    $lado = generarTermino($variables1); // Asegurar que el primer término tenga variable
                    for ($i = 1; $i < $numTerminos; $i++) {
                        $signo = rand(0, 1) == 1 ? ' + ' : ' - ';
                        $lado .= $signo . abs(generarTermino(rand(0, 1) == 1 ? $variables1 : ''));
                    }
                    return $lado;
                }


                function generarTermino1($variable) {
                    $coef = rand(2, 10);
                    if ($coef == 0) {
                        $coef = 1; // Evitar que el coeficiente sea 0
                    }
                    return ($coef == 1 && $variable != '' ? '' : $coef) . $variable;
                }

                function generarLado1($variables1) {
                    $numTerminos = 1;  // Generar de 1 a 5 términos
                    $lado = generarTermino1($variables1); // Asegurar que el primer término tenga variable
                    
                    return $lado;
                }



                function generarInecuacion() {
                    $val = rand(-5, 5);
                    $variables = "x";
                    $variables1 = "y";
                    $left = generarLado($variables);
                    $right = generarLado1($variables1);
                    $operator1 = ['>', '≥', '<', '≤'];
                    $var1 = $operator1[array_rand($operator1)];
                    $operator = ['+', '-'];
                    $var2 = $operator[array_rand($operator)];
                    return $left . ' ' . $var2 . ' ' . $right. ' ' . $var1 . ' ' . $val;
                }

                for ($i = 0; $i < $n; $i++) {
                    $inecuacion = generarInecuacion();
                    echo "<div class=' mb-6 '>";
                    echo "<div class='card'>";
                    echo "<div class='card-body'>";
                    echo "<h5 class='card-title'>Ejercicio " . ($i + 1) . "</h5>";
                    //echo "<p class='card-text '>$$" . $inecuacion . "$$</p>";
                    echo "<p class='card-text '>\(" . $inecuacion . "\)</p>";
                    echo "</div>";
                    echo "</div>";

                    echo "</div>";
                    echo "<br>";
                }
                ?>





            </div>
        </div>



<div class="container">
            <h3 >Sistema de inecuaciones con dos incognitas</h3>
            <h10 >Graficar la solución de los siguinetes Sistemas de Inecuaciones</h10>
            
            <div class="row">
                <?php
               
$n=4;
                function generarTerminof($variable) {
                    $coef = rand(-10, 10);
                    if ($coef == 0) {
                        $coef = 1; // Evitar que el coeficiente sea 0
                    }
                    return ($coef == 1 && $variable != '' ? '' : $coef) . $variable;
                }

                function generarLadof($variables1) {
                    $numTerminos = 1;  // Generar de 1 a 5 términos
                    $lado = generarTerminof($variables1); // Asegurar que el primer término tenga variable
                    for ($i = 1; $i < $numTerminos; $i++) {
                        $signo = rand(0, 1) == 1 ? ' + ' : ' - ';
                        $lado .= $signo . abs(generarTerminof(rand(0, 1) == 1 ? $variables1 : ''));
                    }
                    return $lado;
                }


                function generarTerminof1($variable) {
                    $coef = rand(2, 10);
                    if ($coef == 0) {
                        $coef = 1; // Evitar que el coeficiente sea 0
                    }
                    return ($coef == 1 && $variable != '' ? '' : $coef) . $variable;
                }

                function generarLadof1($variables1) {
                    $numTerminos = 1;  // Generar de 1 a 5 términos
                    $lado = generarTerminof1($variables1); // Asegurar que el primer término tenga variable
                    
                    return $lado;
                }



                function generarInecuacionf() {
                    $val = rand(-5, 5);
                    $variables = "x";
                    $variables1 = "y";
                    $left = generarLadof($variables);
                    $right = generarLadof1($variables1);
                    $operator1 = ['>', '≥', '<', '≤'];
                    $var1 = $operator1[array_rand($operator1)];
                    $operator = ['+', '-'];
                    $var2 = $operator[array_rand($operator)];
                    return $left . ' ' . $var2 . ' ' . $right. ' ' . $var1 . ' ' . $val;
                }

                for ($i = 0; $i < 4; $i++) {
                    $inecuacion = generarInecuacionf();
                    $inecuacion2 = generarInecuacionf();
                    echo "<div class=' mb-6 '>";
                    echo "<div class='card'>";
                    echo "<div class='card-body'>";
                    echo "<h5 class='card-title'>Ejercicio " . ($i + 1) . "</h5>";
                    echo '\(';
                    echo '\\begin{cases}';
                    echo $inecuacion . ' \\\\ ';
                    echo $inecuacion2;
                    echo '\\end{cases}';
                    echo '\)';
                    echo "</div>";
                    echo "</div>";

                    echo "</div>";
                    echo "<br>";
                }
                ?>


            </div>
        </div>

    </main>
    <?php include 'subir.php'; ?>
    <script>
        MathJax.typeset();
    </script>
</body>
</html>
