<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Matemática Virtual, Ing.MSc. Fernando Carrillo & Ing.MSc. Cecilia Izurieta</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <script src="https://polyfill.io/v3/polyfill.min.js?features=es6"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
       
    </style>
</head>
<body>
    <?php include 'encabezado.php'; ?>
    <main>
        <?php include 'menui.php'; ?>
        <div class="container">
            <h1 >Inecuaciones Lineales</h1>
            
            <div class="row">
                <?php
                function generarTermino($variable) {
                    $coef = rand(-10, 10);
                    if ($coef == 0) {
                        $coef = 1; // Evitar que el coeficiente sea 0
                    }
                    return ($coef == 1 && $variable != '' ? '' : $coef) . $variable;
                }

                function generarLado($variables1) {
                    $numTerminos = rand(1, 5);  // Generar de 1 a 5 términos
                    $lado = generarTermino($variables1); // Asegurar que el primer término tenga variable
                    for ($i = 1; $i < $numTerminos; $i++) {
                        $signo = rand(0, 1) == 1 ? ' + ' : ' - ';
                        $lado .= $signo . abs(generarTermino(rand(0, 1) == 1 ? $variables1 : ''));
                    }
                    return $lado;
                }

                function generarInecuacion() {
                    $variables = ['x', 'y', 'z'];
                    $variables1 = $variables[array_rand($variables)];
                    $left = generarLado($variables1);
                    $right = generarLado($variables1);
                    $right1 = generarLado($variables1);
                    $operator = ['>', '≥', '<', '≤'][rand(0, 3)];
                    $operator1 = ['>', '≥', '<', '≤'][rand(0, 3)];
                    return $left . ' ' . $operator . ' ' . $right. ' ' . $operator1 . ' ' . $right1;
                }

                for ($i = 0; $i < 20; $i++) {
                    $inecuacion = generarInecuacion();
                    echo "<div class=' mb-6 '>";
                    echo "<div class='card'>";
                    echo "<div class='card-body'>";
                    echo "<h5 class='card-title'>Ejercicio " . ($i + 1) . "</h5>";
                    //echo "<p class='card-text '>$$" . $inecuacion . "$$</p>";
                    echo "<p class='card-text '>\(" . $inecuacion . "\)</p>";
                    echo "</div>";
                    echo "</div>";

                    echo "</div>";
                    echo "<br>";
                }
                ?>
            </div>
        </div>
    </main>
    <?php include 'subir.php'; ?>
    <script>
        MathJax.typeset();
    </script>
</body>
</html>
