<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Graficar Función Lineal con GeoGebra</title>
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://cdn.geogebra.org/apps/deployggb.js"></script>
    <style>
        #geogebra-container {
            width: 600px;
            height: 600px;
            margin: auto;
            margin-top: 50px;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1 class="text-center mt-5">Graficar Función Lineal con GeoGebra</h1>
        <div id="geogebra-container"></div>
    </div>

    <script>
        // Inicializar GeoGebra
        var parameters = {
            "appName": "graphing",
            "id": "geogebra",
            "width": 600,
            "height": 600,
            "showToolBar": false,
            "showAlgebraInput": false,  // Ocultar la barra de ingreso de funciones
            "showMenuBar": false,
            "appletOnLoad": function(api) {
                var m = 'f(x) = abs(x + 3)'; 
                api.evalCommand(m);
                
                var m1 = 'f(x) = -x + 3'; 
                // Definir la función, asegúrate de utilizar 'abs' para valor absoluto si es necesario
                api.evalCommand(m1); // Insertar la función en GeoGebra
                api.setPerspective('G'); // Establecer la perspectiva gráfica
            }
        };
        var applet = new GGBApplet(parameters, true);
        window.addEventListener("load", function() {
            applet.inject('geogebra-container');
        });
    </script>
</body>
</html>
