<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Matemática Virtual, Ing.MSc. Fernando Carrillo & Ing.MSc. Cecilia Izurieta </title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <script src="https://polyfill.io/v3/polyfill.min.js?features=es6"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    
</head>
<body>
    <?php include 'encabezado.php'; ?>
    <main>
        <?php include 'menui.php'; ?>
<div class="container">
    <h3 class="mb-4">Factor común</h3>
    <h6 class="mb-4">Factorar en cada uno de los siguientes Ejercicios</h6>
    <?php
    function generarMonomio() {
        $coeficiente = rand(1, 10);
        $numVariables = rand(1, 3);
        $variables = generarVariables($numVariables);
        return array($coeficiente, $variables);
    }

    function generarPolinomio($numTerminos) {
        $terminos = array();
        for ($i = 0; $i < $numTerminos; $i++) {
            $coeficiente = rand(1, 10);
            $numVariables = rand(1, 3);
            $variables = generarVariables($numVariables);
            array_push($terminos, array($coeficiente, $variables));
        }
        return $terminos;
    }

    function generarVariables($numVariables) {
        $vars = array('x', 'y', 'z');
        $variables = array();
        for ($i = 0; $i < $numVariables; $i++) {
            $variable = $vars[$i];
            $exponente = rand(1, 4);
            array_push($variables, array($variable, $exponente));
        }
        return $variables;
    }

    function multiplicarMonomioPorPolinomio($monomio, $polinomio) {
        $resultado = array();
        foreach ($polinomio as $termino) {
            $nuevoCoef = $monomio[0] * $termino[0];
            $nuevasVariables = combinarVariables($monomio[1], $termino[1]);
            array_push($resultado, array($nuevoCoef, $nuevasVariables));
        }
        return $resultado;
    }

    function combinarVariables($vars1, $vars2) {
        $variables = array_merge($vars1, $vars2);
        $combinadas = array();
        foreach ($variables as $var) {
            $found = false;
            foreach ($combinadas as &$combi) {
                if ($combi[0] == $var[0]) {
                    $combi[1] += $var[1];
                    $found = true;
                    break;
                }
            }
            if (!$found) {
                array_push($combinadas, $var);
            }
        }
        return $combinadas;
    }

    function mostrarTermino($termino) {
        $coef = $termino[0];
        $variables = $termino[1];
        $str = $coef != 1 ? "{$coef}" : "";
        foreach ($variables as $var) {
            $str .= "{$var[0]}";
            if ($var[1] != 1) {
                $str .= "^{$var[1]}";
            }
        }
        return $str;
    }

    function mostrarPolinomio($polinomio) {
        $str = "";
        foreach ($polinomio as $index => $termino) {
            $str .= ($index > 0 ? " + " : "") . mostrarTermino($termino);
        }
        return $str;
    }

    for ($i = 0; $i < $n; $i++) {
        $monomio = generarMonomio();
        $numTerminos = rand(2, 7);
        $polinomio = generarPolinomio($numTerminos);
        $resultado = multiplicarMonomioPorPolinomio($monomio, $polinomio);
        
        echo "<div class='card mb-3'>";
        echo "<div class='card-body'>";
        echo "<h5 class='card-title'>Ejercicio " . ($i + 1) . "</h5>";
        echo "<p class='card-text'><strong></strong> \\(" . mostrarPolinomio($resultado) . "\\)</p>";
        echo "</div>";
        echo "</div>";
    }
    ?>
</div>
<script src="bootstrap/js/bootstrap.bundle.min.js"></script>
<script>
    MathJax.typeset();
</script>
 <?php include 'subir.php'; ?>
</body>
</html>
