<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Matemática Virtual, Ing.MSc. Fernando Carrillo & Ing.MSc. Cecilia Izurieta</title>
    <!-- Bootstrap CSS -->
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
    <!-- MathJax -->
    <script src="https://polyfill.io/v3/polyfill.min.js?features=es6"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        /* Estilos adicionales para mejorar la presentación */
        .exercise-section {
            margin-bottom: 40px;
            padding: 20px;
            background-color: #f8f9fa;
            border-radius: 10px;
            border-left: 5px solid #007bff;
        }
        
        .exercise-card {
            transition: transform 0.2s;
            margin-bottom: 15px;
        }
        
        .exercise-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
        }
        
        .type-badge {
            font-size: 0.75rem;
            padding: 3px 8px;
            border-radius: 12px;
        }
        
        .basic-type { background-color: #d4edda; color: #155724; }
        .linear-type { background-color: #d1ecf1; color: #0c5460; }
        .multi-step-type { background-color: #fff3cd; color: #856404; }
        .two-abs-type { background-color: #f8d7da; color: #721c24; }
        .special-type { background-color: #e2e3e5; color: #383d41; }
    </style>
</head>
<body>
    <?php include 'encabezado.php'; ?>
    <main>
        <?php include 'menui.php'; ?>
    
    <!-- SECCIÓN: Ecuaciones con Valor Absoluto - TODOS LOS EJERCICIOS -->
    <div class="container mt-5">
        <div class="card border-primary mb-4">
            <div class="card-header bg-primary text-white">
                <h3 class="mb-0">📚 Ecuaciones con Valor Absoluto - Todos los Ejercicios</h3>
                <p class="mb-0 mt-2">Sección completa de ejercicios de valor absoluto</p>
            </div>
            <div class="card-body">
                
                <!-- Instrucciones -->
                <div class="alert alert-info mb-4">
                    <h5><strong>📝 Instrucciones para resolver:</strong></h5>
                    <ol class="mb-0">
                        <li><strong>Aísla</strong> la expresión con valor absoluto en un lado de la ecuación.</li>
                        <li><strong>Aplica la definición:</strong> Si \(|A| = k\) (con \(k \geq 0\)), entonces \(A = k\) <strong>o</strong> \(A = -k\).</li>
                        <li><strong>Resuelve</strong> cada una de las ecuaciones resultantes por separado.</li>
                        <li><strong>Verifica</strong> tus soluciones sustituyéndolas en la ecuación original.</li>
                    </ol>
                    <p class="mt-2 mb-0"><strong>Nota:</strong> Si obtienes \(|expresión| = \) número negativo, la ecuación <strong>no tiene solución</strong>.</p>
                </div>
                
                <!-- EJERCICIOS DE LA IMAGEN -->
                <div class="exercise-section">
                    
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <div class="card exercise-card">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between mb-2">
                                        <span class="type-badge basic-type">Básico</span>
                                        <small class="text-muted">(a)</small>
                                    </div>
                                    <p class="card-text text-center">\[ |x + 3| = 3 \]</p>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-6 mb-3">
                            <div class="card exercise-card">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between mb-2">
                                        <span class="type-badge linear-type">Lineal</span>
                                        <small class="text-muted">(b)</small>
                                    </div>
                                    <p class="card-text text-center">\[ |1 - x| = 5 \]</p>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-6 mb-3">
                            <div class="card exercise-card">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between mb-2">
                                        <span class="type-badge special-type">Especial</span>
                                        <small class="text-muted">(c)</small>
                                    </div>
                                    <p class="card-text text-center">\[ \left| \frac{x + 1}{x - 1} \right| = 2 \]</p>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-6 mb-3">
                            <div class="card exercise-card">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between mb-2">
                                        <span class="type-badge linear-type">Cuadrático</span>
                                        <small class="text-muted">(d)</small>
                                    </div>
                                    <p class="card-text text-center">\[ |x^2 - 3| = 1 \]</p>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-12 mb-3">
                            <div class="card exercise-card">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between mb-2">
                                        <span class="type-badge linear-type">Cuadrático</span>
                                        <small class="text-muted">(e)</small>
                                    </div>
                                    <p class="card-text text-center">\[ |x^2 - x - 1| = 1 \]</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- EJERCICIOS BÁSICOS -->
                <div class="exercise-section">
                    <h4 class="mb-3" style="color: #28a745;">Ejercicios Básicos</h4>
                    <div class="row">
                        <?php
                        $basic_exercises = [
                            ['num' => '1', 'eq' => '|x| = 8'],
                            ['num' => '2', 'eq' => '|b| = 1'],
                            ['num' => '19', 'eq' => '|n| = 7'],
                            ['num' => '20', 'eq' => '|x| = 2']
                        ];
                        
                        foreach ($basic_exercises as $exercise) {
                            echo '<div class="col-md-3 mb-3">';
                            echo '<div class="card exercise-card">';
                            echo '<div class="card-body">';
                            echo '<div class="d-flex justify-content-between mb-2">';
                            echo '<span class="type-badge basic-type">Básico</span>';
                            echo '<small class="text-muted">Ej. ' . $exercise['num'] . '</small>';
                            echo '</div>';
                            echo '<p class="card-text text-center">\[ ' . $exercise['eq'] . ' \]</p>';
                            echo '</div>';
                            echo '</div>';
                            echo '</div>';
                        }
                        ?>
                    </div>
                </div>
                
                <!-- CON EXPRESIÓN LINEAL DENTRO -->
                <div class="exercise-section">
                    <h4 class="mb-3" style="color: #17a2b8;">Con Expresión Lineal Dentro</h4>
                    <div class="row">
                        <?php
                        $linear_exercises = [
                            ['num' => '3', 'eq' => '|5 + 8a| = 53'],
                            ['num' => '4', 'eq' => '|3k + 8| = 2'],
                            ['num' => '7', 'eq' => '|6 - 2x| = 24'],
                            ['num' => '21', 'eq' => '|9n + 8| = 46'],
                            ['num' => '22', 'eq' => '|3 - x| = 6'],
                            ['num' => '23', 'eq' => '|5n + 7| = 23'],
                            ['num' => '5', 'eq' => '|9 + 7x| = 30'],
                            ['num' => '6', 'eq' => '|8 + 6m| = 50']
                        ];
                        
                        foreach ($linear_exercises as $exercise) {
                            echo '<div class="col-md-3 mb-3">';
                            echo '<div class="card exercise-card">';
                            echo '<div class="card-body">';
                            echo '<div class="d-flex justify-content-between mb-2">';
                            echo '<span class="type-badge linear-type">Lineal</span>';
                            echo '<small class="text-muted">Ej. ' . $exercise['num'] . '</small>';
                            echo '</div>';
                            echo '<p class="card-text text-center">\[ ' . $exercise['eq'] . ' \]</p>';
                            echo '</div>';
                            echo '</div>';
                            echo '</div>';
                        }
                        ?>
                    </div>
                </div>
                
                <!-- ECUACIONES DE MÚLTIPLES PASOS -->
                <div class="exercise-section">
                    <h4 class="mb-3" style="color: #ffc107;">Ecuaciones de Múltiples Pasos</h4>
                    <div class="row">
                        <?php
                        $multi_step_exercises = [
                            ['num' => '11', 'eq' => '8|x + 7| - 3 = 5'],
                            ['num' => '12', 'eq' => '5|3 + 7m| + 1 = 51'],
                            ['num' => '13', 'eq' => '3 + 5|8 - 2x| = 63'],
                            ['num' => '28', 'eq' => '8|5p + 8| - 5 = 11'],
                            ['num' => '30', 'eq' => '4|r + 7| + 3 = 59'],
                            ['num' => '31', 'eq' => '5 + 8|-10n - 2| = 101'],
                            ['num' => '8', 'eq' => '-7|-3 - 3r| = -21'],
                            ['num' => '9', 'eq' => '7|-7x - 3| = 21'],
                            ['num' => '10', 'eq' => '\frac{| -4b - 10|}{8} = 3']
                        ];
                        
                        foreach ($multi_step_exercises as $exercise) {
                            echo '<div class="col-md-4 mb-3">';
                            echo '<div class="card exercise-card">';
                            echo '<div class="card-body">';
                            echo '<div class="d-flex justify-content-between mb-2">';
                            echo '<span class="type-badge multi-step-type">Múltiples pasos</span>';
                            echo '<small class="text-muted">Ej. ' . $exercise['num'] . '</small>';
                            echo '</div>';
                            echo '<p class="card-text text-center">\[ ' . $exercise['eq'] . ' \]</p>';
                            echo '</div>';
                            echo '</div>';
                            echo '</div>';
                        }
                        ?>
                    </div>
                </div>
                
                <!-- CON DOS VALORES ABSOLUTOS -->
                <div class="exercise-section">
                    <h4 class="mb-3" style="color: #dc3545;">Con Dos Valores Absolutos</h4>
                    <div class="row">
                        <?php
                        $two_abs_exercises = [
                            ['num' => '16', 'eq' => '|5x + 3| = |2x - 1|'],
                            ['num' => '17', 'eq' => '|3x - 4| = |2x + 3|'],
                            ['num' => '18', 'eq' => '|4x - 25| = |6x + 32|'],
                            ['num' => '34', 'eq' => '|2 + 3x| = |4 - 2x|'],
                            ['num' => '35', 'eq' => '\left| \frac{2x - 5}{3} \right| = \left| \frac{3x + 4}{2} \right|']
                        ];
                        
                        foreach ($two_abs_exercises as $exercise) {
                            echo '<div class="col-md-4 mb-3">';
                            echo '<div class="card exercise-card">';
                            echo '<div class="card-body">';
                            echo '<div class="d-flex justify-content-between mb-2">';
                            echo '<span class="type-badge two-abs-type">Dos absolutos</span>';
                            echo '<small class="text-muted">Ej. ' . $exercise['num'] . '</small>';
                            echo '</div>';
                            echo '<p class="card-text text-center">\[ ' . $exercise['eq'] . ' \]</p>';
                            echo '</div>';
                            echo '</div>';
                            echo '</div>';
                        }
                        ?>
                    </div>
                </div>
                
                <!-- EJERCICIOS ESPECIALES -->
                <div class="exercise-section">
                    <h4 class="mb-3" style="color: #6c757d;">Ejercicios Especiales</h4>
                    <div class="row">
                        <?php
                        $special_exercises = [
                            ['num' => '24', 'eq' => '|9p + 6| = 3'],
                            ['num' => '25', 'eq' => '|3n - 2| = 7'],
                            ['num' => '26', 'eq' => '|2 + 2b| + 1 = 3'],
                            ['num' => '27', 'eq' => '\frac{| -4 - 3n|}{4} = 2'],
                            ['num' => '29', 'eq' => '3 - |6n + 7| = -40'],
                            ['num' => '32', 'eq' => '7|10v - 2| - 9 = 5'],
                            ['num' => '33', 'eq' => '8|3 - 3n| - 5 = 91'],
                            ['num' => '36', 'eq' => '\frac{|-n + 6|}{6} = 0']
                        ];
                        
                        foreach ($special_exercises as $exercise) {
                            echo '<div class="col-md-3 mb-3">';
                            echo '<div class="card exercise-card">';
                            echo '<div class="card-body">';
                            echo '<div class="d-flex justify-content-between mb-2">';
                            echo '<span class="type-badge special-type">Especial</span>';
                            echo '<small class="text-muted">Ej. ' . $exercise['num'] . '</small>';
                            echo '</div>';
                            echo '<p class="card-text text-center">\[ ' . $exercise['eq'] . ' \]</p>';
                            echo '</div>';
                            echo '</div>';
                            echo '</div>';
                        }
                        ?>
                    </div>
                </div>
                
                <!-- Resumen de ejercicios -->
                <div class="alert alert-secondary mt-4">
                    <h5><strong>📊 Resumen de Ejercicios:</strong></h5>
                    <div class="row">
                        <div class="col-md-3">
                            <p><span class="badge badge-success">5</span> Ejercicios de la imagen</p>
                        </div>
                        <div class="col-md-3">
                            <p><span class="badge badge-success">4</span> Ejercicios básicos</p>
                        </div>
                        <div class="col-md-3">
                            <p><span class="badge badge-success">8</span> Con expresión lineal</p>
                        </div>
                        <div class="col-md-3">
                            <p><span class="badge badge-success">9</span> Múltiples pasos</p>
                        </div>
                        <div class="col-md-3">
                            <p><span class="badge badge-success">5</span> Dos valores absolutos</p>
                        </div>
                        <div class="col-md-3">
                            <p><span class="badge badge-success">8</span> Ejercicios especiales</p>
                        </div>
                        <div class="col-md-6">
                            <p><strong>Total: <span class="badge badge-primary">39</span> ejercicios de valor absoluto</strong></p>
                        </div>
                    </div>
                </div>
                
            </div>
        </div>
    </div>

    <!-- Sección original de ecuaciones de segundo grado -->
    <div class="container mt-5">
        
        <div class="mt-4">
            <?php
            // ... tu código PHP existente para generar ejercicios de segundo grado ...
            // (Manteniendo tu código original aquí)
            ?>
        </div>
    </div>
    
    <!-- Resto del código PHP existente... -->
    <div class="container mt-5">
        <!-- ... resto de tu código PHP para otros ejercicios ... -->
    </div>
    
    </main>
    <?php //include 'subir.php'; ?>
    
    <!-- Scripts adicionales -->
    <script>
        // Configuración de MathJax
        MathJax = {
            tex: {
                inlineMath: [['$', '$'], ['\\(', '\\)']],
                displayMath: [['$$', '$$'], ['\\[', '\\]']],
                processEscapes: true,
                processEnvironments: true
            }
        };
        
        // Efecto de hover mejorado
        document.addEventListener('DOMContentLoaded', function() {
            const cards = document.querySelectorAll('.exercise-card');
            cards.forEach(card => {
                card.addEventListener('mouseenter', function() {
                    this.style.transform = 'translateY(-5px)';
                    this.style.boxShadow = '0 10px 20px rgba(0,0,0,0.1)';
                });
                
                card.addEventListener('mouseleave', function() {
                    this.style.transform = 'translateY(0)';
                    this.style.boxShadow = '0 2px 5px rgba(0,0,0,0.05)';
                });
            });
        });
    </script>
</body>
</html>