<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Matemática Virtual, Ing.MSc. Fernando Carrillo & Ing.MSc. Cecilia Izurieta</title>
    <!-- Bootstrap CSS -->
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
    <!-- MathJax -->
    <script src="https://polyfill.io/v3/polyfill.min.js?features=es6"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
</head>
<body>
    <!-- Encabezado -->
    <?php include 'encabezado.php'; ?>
    
    <main>
        <!-- Menú -->
        <?php include 'menui.php'; ?>
        
        <div class="container mt-5">
            <h3 class="mb-4">Ecuación de segundo grado</h3>
            <h6 class="mb-4">Resolver las siguientes ecuaciones de segundo grado</h6>
            <h6 class="mb-4">Solo por Factorización</h6>
            
            <!-- Lista de los 10 ejercicios -->
            <div class="mt-4">
                <?php
                // Definir los 10 ejercicios
                $ejercicios = array(
                    "1. \( 4x^2 - 9 = 0 \)",
                    "2. \( x^2 - 25 = 0 \)",
                    "3. \( x^2 - x = 0 \)",
                    "4. \( 3x^2 + 8x = 0 \)",
                    "5. \( x^2 - 5x + 6 = 0 \)",
                    "6. \( x^2 + 4x + 3 = 0 \)",
                    "7. \( -x^2 + x + 12 = 0 \)",
                    "8. \( 2x^2 + x - 1 = 0 \)",
                    "9. \( 9x^2 + 27x + 14 = 0 \)",
                    "10. \( x^2 + 7ax + 12a^2 = 0 \)"
                );
                
                // Mostrar cada ejercicio en una tarjeta
                foreach ($ejercicios as $ejercicio) {
                    echo "<div class='card mb-3'>";
                    echo "<div class='card-body'>";
                    echo "<p class='card-text' style='font-size: 1.2rem;'>$ejercicio</p>";
                    echo "</div>";
                    echo "</div>";
                }
                ?>
            </div>
        </div>
    </main>
    
    <!-- Pie de página -->
    <?php include 'subir.php'; ?>
    
    <!-- Bootstrap JS -->
    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.3/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
</body>
</html>