<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Matemática Virtual - Ecuaciones con Fracciones</title>
    <!-- Bootstrap CSS -->
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
    <style>
        .math-equation {
            font-size: 1.2rem;
            padding: 15px;
            background-color: #f8f9fa;
            border-radius: 5px;
            margin: 10px 0;
        }
        .card-title {
            color: #2c3e50;
        }
    </style>
</head>
<body>
    <?php 
    // Incluir archivos si existen, sino continuar
    if (file_exists('encabezado.php')) {
        include 'encabezado.php'; 
    }
    ?>
    
    <main>
        <?php 
        if (file_exists('menui.php')) {
            include 'menui.php'; 
        }
        ?>
        
        <div class="container mt-5">
            <h3 class="mb-4 text-center">Ejercicios de Ecuaciones con Fracciones</h3>
            <p class="text-muted text-center mb-4">Resuelve las siguientes ecuaciones lineales con fracciones</p>
            
            <div class="mt-4">
                <?php
                // Definir el número de ejercicios
                $n = 5; // Reducido para prueba
                
                // Función para generar fracciones simples
                function generarFraccionSimple($conVariable = false) {
                    $variables = ['x'];
                    $numerador = rand(1, 9);
                    $denominador = rand(2, 9);
                    
                    // Simplificar fracción
                    $mcd = mcd($numerador, $denominador);
                    $numerador = intval($numerador / $mcd);
                    $denominador = intval($denominador / $mcd);
                    
                    $variable = $conVariable ? $variables[array_rand($variables)] : '';
                    
                    if ($denominador == 1) {
                        return $numerador . $variable;
                    } else {
                        return "\\frac{{$numerador}{$variable}}{{$denominador}}";
                    }
                }
                
                // Función para generar término
                function generarTermino($tipo = 0) {
                    $variables = ['x'];
                    $operadores = ['+', '-'];
                    
                    switch($tipo) {
                        case 0: // Entero
                            $numero = rand(1, 12);
                            $conVariable = rand(0, 1);
                            if ($conVariable) {
                                return $numero . $variables[array_rand($variables)];
                            }
                            return $numero;
                            
                        case 1: // Fracción simple
                            return generarFraccionSimple(rand(0, 1));
                            
                        case 2: // Fracción con binomio en numerador
                            $a = rand(1, 4);
                            $b = rand(1, 4);
                            $op = $operadores[array_rand($operadores)];
                            $den = rand(2, 6);
                            $variable = $variables[array_rand($variables)];
                            
                            $posicionVariable = rand(0, 1);
                            if ($posicionVariable == 0) {
                                return "\\frac{{$a}{$variable}{$op}{$b}}{{$den}}";
                            } else {
                                return "\\frac{{$a}{$op}{$b}{$variable}}{{$den}}";
                            }
                            
                        default:
                            return rand(1, 10);
                    }
                }
                
                // Función máximo común divisor
                function mcd($a, $b) {
                    while ($b != 0) {
                        $temp = $b;
                        $b = $a % $b;
                        $a = $temp;
                    }
                    return $a;
                }
                
                // Función para generar ecuación
                function generarEcuacion() {
                    $operadores = ['+', '-'];
                    
                    // Decidir estructura de la ecuación
                    $estructura = rand(0, 2);
                    
                    $ladoIzquierdo = '';
                    $ladoDerecho = '';
                    
                    // Lado izquierdo
                    $terminosIzq = rand(2, 3);
                    for ($i = 0; $i < $terminosIzq; $i++) {
                        $operador = ($i == 0) ? '' : $operadores[array_rand($operadores)];
                        $termino = generarTermino(rand(0, 2));
                        $ladoIzquierdo .= ($i > 0 ? " $operador " : "") . $termino;
                    }
                    
                    // Lado derecho
                    $terminosDer = rand(1, 3);
                    for ($i = 0; $i < $terminosDer; $i++) {
                        $operador = ($i == 0) ? '' : $operadores[array_rand($operadores)];
                        $termino = generarTermino(rand(0, 2));
                        $ladoDerecho .= ($i > 0 ? " $operador " : "") . $termino;
                    }
                    
                    return trim($ladoIzquierdo) . " = " . trim($ladoDerecho);
                }
                
                // Generar y mostrar ejercicios
                for ($i = 1; $i <= $n; $i++) {
                    $ecuacion = generarEcuacion();
                    
                    echo "<div class='card mb-4 shadow-sm'>";
                    echo "<div class='card-header bg-primary text-white'>";
                    echo "<h5 class='mb-0'>Ejercicio $i</h5>";
                    echo "</div>";
                    echo "<div class='card-body'>";
                    echo "<p class='card-text'>Resuelve para x:</p>";
                    echo "<div class='math-equation text-center'>";
                    echo "\\( $ecuacion \\)";
                    echo "</div>";
                    
                    echo "<div class='row mt-3'>";
                    echo "<div class='col-md-6'>";
                    echo "<div class='form-group'>";
                    //echo "<label for='respuesta$i'>Respuesta:</label>";
                    //echo "<input type='text' class='form-control' id='respuesta$i' placeholder='x = ...'>";
                    echo "</div>";
                    echo "</div>";
                    echo "<div class='col-md-6'>";
                    echo "<div class='form-group'>";
                    //echo "<label for='pasos$i'>Pasos de solución (opcional):</label>";
                    //echo "<textarea class='form-control' id='pasos$i' rows='2'></textarea>";
                    echo "</div>";
                    echo "</div>";
                    echo "</div>";
                    
                    echo "<div class='text-right mt-2'>";
                    //echo "<button class='btn btn-sm btn-outline-primary mr-2' onclick='verificar($i)'>Verificar</button>";
                    //echo "<button class='btn btn-sm btn-outline-secondary' onclick='mostrarSolucion($i)'>Ver Solución</button>";
                    echo "</div>";
                    
                    echo "</div>"; // card-body
                    echo "</div>"; // card
                }
                ?>
            </div>
            
            <div class="text-center mt-4 mb-5">
                <button class="btn btn-success btn-lg" onclick="generarMasEjercicios()">
                    <i class="fas fa-redo-alt"></i> Generar Más Ejercicios
                </button>
            </div>
        </div>
    </main>
    
    <?php 
    if (file_exists('subir.php')) {
        include 'subir.php'; 
    }
    ?>
    
    <!-- Bootstrap JS y dependencias -->
    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.3/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    
    <!-- Font Awesome -->
    <script src="https://kit.fontawesome.com/a076d05399.js" crossorigin="anonymous"></script>
    
    <!-- MathJax -->
    <script src="https://polyfill.io/v3/polyfill.min.js?features=es6"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    
    <script>
        // Configurar MathJax
        window.MathJax = {
            tex: {
                inlineMath: [['\\(', '\\)']],
                displayMath: [['\\[', '\\]']],
                processEscapes: true
            }
        };
        
        // Funciones JavaScript
        function verificar(numero) {
            const respuesta = document.getElementById('respuesta' + numero).value;
            if (respuesta.trim() === '') {
                alert('Por favor, ingresa tu respuesta primero.');
                return;
            }
            alert('Respuesta enviada para el ejercicio ' + numero + ':\n' + respuesta);
            // Aquí podrías agregar lógica para verificar la respuesta
        }
        
        function mostrarSolucion(numero) {
            alert('Solución para el ejercicio ' + numero + ':\n(Esta funcionalidad puede conectarse a un sistema de corrección automática)');
        }
        
        function generarMasEjercicios() {
            location.reload(); // Recarga la página para generar nuevos ejercicios
        }
        
        // Forzar renderizado de MathJax después de cargar
        document.addEventListener('DOMContentLoaded', function() {
            if (window.MathJax) {
                setTimeout(() => {
                    MathJax.typesetPromise();
                }, 1000);
            }
        });
    </script>
</body>
</html>