<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Matemática Virtual, Ing.MSc. Fernando Carrillo & Ing.MSc. Cecilia Izurieta</title>
    <!-- Bootstrap CSS -->
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
    <?php include 'encabezado.php'; ?>
<main>
    <?php include 'menui.php'; ?>
    <div class="container mt-5">
        <h3 class="mb-4">Ejercicios de Ecuaciones con Fracciones</h3>
        <div class="mt-4">
            <?php
                // Definir el número de ejercicios (puedes cambiar este valor)
                $n = 10; // Número de ejercicios a generar
                
                function generateFractionExpression() {
                    $operators = ['+', '-', '\\times'];
                    $operators_simple = ['+', '-'];
                    $variables = ['x']; // Variables para las ecuaciones
                    
                    // Decidir si la ecuación tendrá fracciones en ambos lados o solo en uno
                    $withFractions = rand(1, 3); // 1-2: con fracciones, 3: sin fracciones
                    
                    $expression = "";
                    $expression1 = "";
                    
                    // Número de términos en cada lado de la ecuación
                    $numTermsLeft = rand(2, 4);
                    $numTermsRight = rand(2, 4);
                    
                    // Lado izquierdo de la ecuación
                    for ($i = 0; $i < $numTermsLeft; $i++) {
                        $operator = ($i == 0) ? '' : $operators_simple[array_rand($operators_simple)];
                        
                        // Decidir si este término será una fracción
                        $isFraction = ($withFractions <= 2) ? rand( 0, 1) : 0;
                        
                        // Decidir si este término tendrá variable
                        $hasVariable = rand(0, 1);
                        
                        if ($isFraction) {
                            // Generar fracción
                            $numerator = rand(1, 10);
                            $denominator = rand(2, 10);
                            
                            // Simplificar fracción si es posible
                            $gcd = gcd($numerator, $denominator);
                            $numerator = $numerator / $gcd;
                            $denominator = $denominator / $gcd;
                            
                            if ($hasVariable) {
                                $variable = $variables[array_rand($variables)];
                                $expression .= ($i > 0 ? " $operator " : "") . "\\frac{$numerator}{$denominator}$variable";
                            } else {
                                $expression .= ($i > 0 ? " $operator " : "") . "\\frac{$numerator}{$denominator}";
                            }
                        } else {
                            // Generar número entero
                            $number = rand(1, 10);
                            
                            if ($hasVariable) {
                                $variable = $variables[array_rand($variables)];
                                $expression .= ($i > 0 ? " $operator " : "") . "{$number}$variable";
                            } else {
                                $expression .= ($i > 0 ? " $operator " : "") . "{$number}";
                            }
                        }
                    }
                    
                    // Lado derecho de la ecuación
                    for ($i = 0; $i < $numTermsRight; $i++) {
                        $operator = ($i == 0) ? '' : $operators_simple[array_rand($operators_simple)];
                        
                        // Decidir si este término será una fracción
                        $isFraction = ($withFractions <= 2) ? rand(0, 1) : 0;
                        
                        // Decidir si este término tendrá variable
                        $hasVariable = rand(0, 1);
                        
                        if ($isFraction) {
                            // Generar fracción
                            $numerator = rand(1, 10);
                            $denominator = rand(2, 10);
                            
                            // Simplificar fracción si es posible
                            $gcd = gcd($numerator, $denominator);
                            $numerator = $numerator / $gcd;
                            $denominator = $denominator / $gcd;
                            
                            if ($hasVariable) {
                                $variable = $variables[array_rand($variables)];
                                $expression1 .= ($i > 0 ? " $operator " : "") . "\\frac{$numerator}{$denominator}$variable";
                            } else {
                                $expression1 .= ($i > 0 ? " $operator " : "") . "\\frac{$numerator}{$denominator}";
                            }
                        } else {
                            // Generar número entero
                            $number = rand(1, 10);
                            
                            if ($hasVariable) {
                                $variable = $variables[array_rand($variables)];
                                $expression1 .= ($i > 0 ? " $operator " : "") . "{$number}$variable";
                            } else {
                                $expression1 .= ($i > 0 ? " $operator " : "") . "{$number}";
                            }
                        }
                    }
                    
                    // Asegurar que al menos un lado tenga fracciones
                    if (strpos($expression, '\\frac') === false && strpos($expression1, '\\frac') === false) {
                        // Agregar una fracción aleatoria en algún lado
                        $side = rand(0, 1);
                        $variable = $variables[array_rand($variables)];
                        $numerator = rand(1, 5);
                        $denominator = rand(2, 6);
                        
                        $fraction = "\\frac{$numerator}{$denominator}" . (rand(0, 1) ? $variable : "");
                        
                        if ($side == 0) {
                            $operator = $operators_simple[array_rand($operators_simple)];
                            $expression .= " $operator $fraction";
                        } else {
                            $operator = $operators_simple[array_rand($operators_simple)];
                            $expression1 .= " $operator $fraction";
                        }
                    }
                    
                    return "$expression = $expression1";
                }
                
                // Función para calcular el máximo común divisor (MCD)
                function gcd($a, $b) {
                    while ($b != 0) {
                        $temp = $b;
                        $b = $a % $b;
                        $a = $temp;
                    }
                    return $a;
                }
                
                // Generar los ejercicios
                for ($i = 1; $i <= $n; $i++) {
                    $equation = generateFractionExpression();
                    echo "<div class='card mb-3'>";
                    echo "<div class='card-body'>";
                    echo "<h5 class='card-title'>Ejercicio $i</h5>";
                    echo "<p class='card-text'>Resuelve la siguiente ecuación:</p>";
                    echo "<p class='card-text text-center h4'>\\( $equation \\)</p>";
                    echo "<div class='mt-3'>";
                    //echo "<label for='solucion$i' class='form-label'>Tu solución:</label>";
                    //echo "<input type='text' class='form-control' id='solucion$i' placeholder='Escribe tu respuesta aquí'>";
                    echo "</div>";
                    echo "</div>";
                    echo "</div>";
                }
            ?>
        </div>
    </div>
    
    <!-- MathJax -->
    <script src="https://polyfill.io/v3/polyfill.min.js?features=es6"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    
    <script>
        // Configurar MathJax para renderizar correctamente las fracciones
        window.MathJax = {
            tex: {
                inlineMath: [['\\(', '\\)']],
                displayMath: [['\\[', '\\]']],
                processEscapes: true,
                processEnvironments: true
            },
            options: {
                skipHtmlTags: ['script', 'noscript', 'style', 'textarea', 'pre']
            }
        };
    </script>
</main>
<?php include 'subir.php'; ?>
</body>
</html>