<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Matemática Virtual, Ing.MSc. Fernando Carrillo & Ing.MSc. Cecilia Izurieta</title>
    <!-- Bootstrap CSS -->
    <link href="../bootstrap/css/bootstrap.min.css" rel="stylesheet">
    <!-- MathJax for LaTeX -->
    <script src="https://polyfill.io/v3/polyfill.min.js?features=es6"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
</head>
<body>
<?php include 'encabezado.php'; ?> 
    <main>
    <?php include 'menui.php'; ?>
    <div class="container mt-5 overflow-auto">
    
        <h1 class="text-center">Generador de Ejercicios de Volumen</h1>

        <?php
        function randomValue($min, $max) {
            return rand($min, $max);
        }

        $ejercicios = [
            "Esferas" => [
                "Una esfera tiene un radio de " . randomValue(1, 10) . " cm. Si el radio se duplicara, ¿cómo cambiaría el volumen de la esfera?",
                "Un tanque de agua esférico tiene un diámetro de " . randomValue(5, 20) . " m. ¿Cuál es la cantidad máxima de agua que puede contener?",
                "Encuentra el volumen de una esfera cuyo radio es el triple del radio de una esfera de volumen " . randomValue(50, 200) . " cm³.",
                "Si el volumen de una esfera es \\( \\frac{4}{3} \\pi \\) cm³, ¿cuál es su radio?",
                "¿Qué sucede con el volumen de una esfera si su radio se reduce a la mitad?"
            ],
            "Conos" => [
                "Calcula el volumen de un cono con un radio de " . randomValue(2, 8) . " cm y una altura de " . randomValue(10, 20) . " cm. Luego, explica cómo cambiaría el volumen si la altura se duplicara.",
                "Encuentra el volumen de un cono cuyo diámetro es de " . randomValue(5, 15) . " cm y su altura es de " . randomValue(10, 25) . " cm. ¿Cómo cambiaría el volumen si el radio se redujera a la mitad y la altura se mantuviera constante?",
                "Un cono tiene un radio de " . randomValue(4, 10) . " cm y una altura de " . randomValue(10, 20) . " cm. Si el radio se reduce en " . randomValue(1, 3) . " cm y la altura aumenta en " . randomValue(1, 5) . " cm, ¿cuál será el nuevo volumen?",
                "Determina el volumen de un cono con un diámetro de " . randomValue(3, 9) . " cm y una altura de " . randomValue(6, 12) . " cm. ¿Qué pasa con el volumen si la altura se triplica?",
                "Calcula el volumen de un cono con una altura de " . randomValue(5, 15) . " cm y un radio de " . randomValue(2, 6) . " cm. ¿Cómo se modifica el volumen si el radio se cuadruplica?"
            ],
            "Prismas Rectangulares" => [
                "Calcula el volumen de un prisma rectangular con longitudes de " . randomValue(2, 5) . " cm, " . randomValue(2, 5) . " cm y " . randomValue(2, 5) . " cm. ¿Cómo cambiaría el volumen si cada dimensión se duplicara?",
                "Encuentra el volumen de un prisma rectangular de dimensiones " . randomValue(4, 10) . " m, " . randomValue(2, 5) . " m y " . randomValue(2, 5) . " m. Si la longitud más grande se reduce a la mitad, ¿cuál es el nuevo volumen?",
                "Un prisma rectangular tiene dimensiones de " . randomValue(5, 12) . " cm, " . randomValue(5, 12) . " cm y " . randomValue(5, 12) . " cm. ¿Qué sucede con el volumen si solo se duplica la altura?",
                "Determina el volumen de un prisma rectangular con lados de " . randomValue(2, 6) . " cm, " . randomValue(2, 6) . " cm y " . randomValue(2, 6) . " cm. Si se incrementan todas las dimensiones en " . randomValue(1, 3) . " cm, ¿cuál será el nuevo volumen?",
                "Calcula el volumen de un prisma rectangular cuyas dimensiones son " . randomValue(5, 10) . " cm, " . randomValue(5, 10) . " cm y " . randomValue(5, 10) . " cm. ¿Cómo se modifica el volumen si una de las dimensiones se reduce a la mitad?"
            ],
            "Prismas Triangulares" => [
                "Calcula el volumen de un prisma triangular con una base de " . randomValue(3, 8) . " cm, una altura de " . randomValue(6, 15) . " cm y una longitud de " . randomValue(5, 15) . " cm. ¿Cómo cambiaría el volumen si la longitud se duplica?",
                "Encuentra el volumen de un prisma triangular cuya base es un triángulo equilátero de lado " . randomValue(3, 10) . " cm y cuya altura del prisma es " . randomValue(10, 20) . " cm. ¿Qué sucede si la altura del prisma se reduce a la mitad?",
                "Un prisma triangular tiene una base con lados de " . randomValue(4, 10) . " cm y una altura de " . randomValue(3, 8) . " cm, y la longitud del prisma es de " . randomValue(5, 15) . " cm. ¿Cuál es el nuevo volumen si se duplica la longitud del prisma?",
                "Determina el volumen de un prisma triangular con una base de " . randomValue(6, 12) . " cm y " . randomValue(6, 12) . " cm, y una altura de " . randomValue(10, 20) . " cm. ¿Cómo se modifica el volumen si la altura se triplica?",
                "Calcula el volumen de un prisma triangular cuya base es un triángulo rectángulo con catetos de " . randomValue(3, 7) . " cm y " . randomValue(3, 7) . " cm, y la altura del prisma es de " . randomValue(5, 15) . " cm. ¿Qué pasa con el volumen si los catetos se duplican?"
            ],
            "Prismas Cuadrangulares" => [
                "Calcula el volumen de un prisma cuadrangular con una base de " . randomValue(3, 10) . " cm de lado y una altura de " . randomValue(10, 20) . " cm. ¿Cómo cambiaría el volumen si la altura se reduce a la mitad?",
                "Encuentra el volumen de un prisma cuadrangular cuya base tiene un lado de " . randomValue(4, 12) . " cm y una altura de " . randomValue(8, 15) . " cm. ¿Qué sucede si cada lado de la base se incrementa en " . randomValue(1, 3) . " cm?",
                "Un prisma cuadrangular tiene una base de lado " . randomValue(5, 10) . " cm y una altura de " . randomValue(10, 20) . " cm. ¿Cuál es el nuevo volumen si la altura se triplica?",
                "Determina el volumen de un prisma cuadrangular con una base de " . randomValue(5, 12) . " cm de lado y una altura de " . randomValue(10, 20) . " cm. ¿Cómo se modifica el volumen si el lado de la base se reduce a la mitad?",
                "Calcula el volumen de un prisma cuadrangular con una base de " . randomValue(4, 8) . " cm de lado y una altura de " . randomValue(10, 20) . " cm. ¿Qué pasa con el volumen si cada lado de la base se duplica?"
            ],
            "Prismas Pentagonales" => [
                "Calcula el volumen de un prisma pentagonal cuya base tiene un área de " . randomValue(20, 50) . " cm² y una altura de " . randomValue(10, 20) . " cm. ¿Cómo cambiaría el volumen si la altura se duplica?",
                "Encuentra el volumen de un prisma pentagonal con una base de " . randomValue(5, 12) . " cm de lado y una altura de " . randomValue(10, 20) . " cm. ¿Qué sucede si el lado de la base se reduce a la mitad?",
                "Un prisma pentagonal tiene una base con un área de " . randomValue(25, 60) . " cm² y una altura de " . randomValue(10, 20) . " cm. ¿Cuál es el nuevo volumen si la altura se triplica?",
                "Determina el volumen de un prisma pentagonal cuya base tiene un área de " . randomValue(30, 70) . " cm² y una altura de " . randomValue(10, 20) . " cm. ¿Cómo se modifica el volumen si el área de la base se reduce a la mitad?",
                "Calcula el volumen de un prisma pentagonal con una base de " . randomValue(5, 10) . " cm de lado y una altura de " . randomValue(10, 20) . " cm. ¿Qué pasa con el volumen si el lado de la base se duplica?"
            ],
            "Pirámides Cuadrangulares" => [
                "Calcula el volumen de una pirámide cuadrangular con una base de " . randomValue(3, 10) . " cm de lado y una altura de " . randomValue(10, 20) . " cm. ¿Cómo cambiaría el volumen si la altura se duplica?",
                "Encuentra el volumen de una pirámide cuadrangular cuya base tiene un lado de " . randomValue(4, 12) . " cm y una altura de " . randomValue(10, 20) . " cm. ¿Qué sucede si cada lado de la base se incrementa en " . randomValue(1, 3) . " cm?",
                "Una pirámide cuadrangular tiene una base de lado " . randomValue(5, 10) . " cm y una altura de " . randomValue(10, 20) . " cm. ¿Cuál es el nuevo volumen si la altura se triplica?",
                "Determina el volumen de una pirámide cuadrangular con una base de " . randomValue(5, 12) . " cm de lado y una altura de " . randomValue(10, 20) . " cm. ¿Cómo se modifica el volumen si el lado de la base se reduce a la mitad?",
                "Calcula el volumen de una pirámide cuadrangular con una base de " . randomValue(4, 8) . " cm de lado y una altura de " . randomValue(10, 20) . " cm. ¿Qué pasa con el volumen si cada lado de la base se duplica?"
            ],
            "Pirámides Pentagonales" => [
                "Calcula el volumen de una pirámide pentagonal cuya base tiene un área de " . randomValue(20, 50) . " cm² y una altura de " . randomValue(10, 20) . " cm. ¿Cómo cambiaría el volumen si la altura se duplica?",
                "Encuentra el volumen de una pirámide pentagonal con una base de " . randomValue(5, 12) . " cm de lado y una altura de " . randomValue(10, 20) . " cm. ¿Qué sucede si el lado de la base se reduce a la mitad?",
                "Una pirámide pentagonal tiene una base con un área de " . randomValue(25, 60) . " cm² y una altura de " . randomValue(10, 20) . " cm. ¿Cuál es el nuevo volumen si la altura se triplica?",
                "Determina el volumen de una pirámide pentagonal cuya base tiene un área de " . randomValue(30, 70) . " cm² y una altura de " . randomValue(10, 20) . " cm. ¿Cómo se modifica el volumen si el área de la base se reduce a la mitad?",
                "Calcula el volumen de una pirámide pentagonal con una base de " . randomValue(5, 10) . " cm de lado y una altura de " . randomValue(10, 20) . " cm. ¿Qué pasa con el volumen si el lado de la base se duplica?"
            ],
            "Pirámides Hexagonales" => [
                "Calcula el volumen de una pirámide hexagonal cuya base tiene un área de " . randomValue(30, 70) . " cm² y una altura de " . randomValue(10, 20) . " cm. ¿Cómo cambiaría el volumen si la altura se duplica?",
                "Encuentra el volumen de una pirámide hexagonal con una base de " . randomValue(6, 15) . " cm de lado y una altura de " . randomValue(10, 20) . " cm. ¿Qué sucede si el lado de la base se reduce a la mitad?",
                "Una pirámide hexagonal tiene una base con un área de " . randomValue(40, 90) . " cm² y una altura de " . randomValue(10, 20) . " cm. ¿Cuál es el nuevo volumen si la altura se triplica?",
                "Determina el volumen de una pirámide hexagonal cuya base tiene un área de " . randomValue(50, 100) . " cm² y una altura de " . randomValue(10, 20) . " cm. ¿Cómo se modifica el volumen si el área de la base se reduce a la mitad?",
                "Calcula el volumen de una pirámide hexagonal con una base de " . randomValue(6, 12) . " cm de lado y una altura de " . randomValue(10, 20) . " cm. ¿Qué pasa con el volumen si el lado de la base se duplica?"
            ]
        ];
        ?>
<?php $i=1;?>
        <?php foreach ($ejercicios as $categoria => $lista): ?>
            

            <h2><?php echo $categoria; ?></h2>
            <ul class=" mb-4">
                <?php foreach ($lista as $ejercicio): ?>
                    <ul class="card mb-4">
                    <h5 class="card-title">Ejercicio <?php echo $i; ?></h5>
                    <?php $i=$i+1;?>
                    <li class="list-group-item"><?php echo $ejercicio; ?></li> 
                </ul>
                <?php endforeach; ?>
            </ul>
        <?php endforeach; ?>
        <button id="btnDescargarPDF" class="btn btn-primary mb-3">Descargar PDF</button>
    </div>

    <!-- Bootstrap JS and dependencies -->
    <script>
        // Capturar el evento de clic en el botón de descarga
        document.getElementById('btnDescargarPDF').addEventListener('click', function() {
            // Seleccionar el contenedor de ejercicios
            var element = document.querySelector('.list-group');

            // Opciones para la generación del PDF
            var options = {
                margin:       0.5,
                filename:     'ejercicios.pdf',
                image:        { type: 'jpeg', quality: 0.98 },
                html2canvas:  { scale: 3 },
                jsPDF:        { unit: 'in', format: 'letter', orientation: 'portrait' }
            };

            // Generar el PDF
            html2pdf().from(element).set(options).save();
        });
    </script>

    <!-- Agregar referencia a la biblioteca html2pdf -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/html2pdf.js/0.9.2/html2pdf.bundle.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.3/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    </main>
    <?php include 'subir.php'; ?>
</body>
</html>
