<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Matemática Virtual, Ing.MSc. Fernando Carrillo & Ing.MSc. Cecilia Izurieta</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <script src="https://polyfill.io/v3/polyfill.min.js?features=es6"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    
</head>
<body>
    <?php include 'encabezado.php'; ?>
    <main>
        <?php include 'menui.php'; ?>
<div >
        <div class="container">
            <div class="row">
                <div class="col-12 text-center">
                    <h1 class="display-4 mb-3"><i class="bi bi-triangle"></i> Ejercicios de Trigonometría</h1>
                    <p class="lead">Resuelve problemas de triángulos rectángulos aplicando las razones trigonométricas</p>
                </div>
            </div>
        </div>
    </div>

    <div class="container py-4">
        <div class="row">
            <!-- Grupo 1 -->
            <div class="col-lg-6">
                <div class="group-title">
                    <h2 class="mb-0"><i class="bi bi-1-circle-fill me-2"></i>Dos catetos dados</h2>
                </div>
                
                <?php
                $grupo1 = [
                    [
                        'enunciado' => 'En un triángulo rectángulo, el cateto opuesto al ángulo \( \theta \) mide 6 cm y el adyacente 8 cm. Encuentra la hipotenusa, \( \theta \) y el otro ángulo agudo.',
                        'solucion' => 'Hipotenusa: \( \sqrt{6^2 + 8^2} = 10 \) cm<br>\( \theta = \arctan\left(\frac{6}{8}\right) \approx 36.87^\circ \)<br>Otro ángulo: \( 90^\circ - 36.87^\circ = 53.13^\circ \)'
                    ],
                    [
                        'enunciado' => 'Los catetos de un triángulo rectángulo miden \( 5\sqrt{3} \) cm (opuesto a \( \alpha \)) y 5 cm (adyacente a \( \alpha \)). Determina la hipotenusa, \( \alpha \) y el otro ángulo.',
                        'solucion' => 'Hipotenusa: \( \sqrt{(5\sqrt{3})^2 + 5^2} = 10 \) cm<br>\( \alpha = \arctan\left(\frac{5\sqrt{3}}{5}\right) = 60^\circ \)<br>Otro ángulo: \( 30^\circ \)'
                    ],
                    [
                        'enunciado' => 'En un triángulo rectángulo, el cateto opuesto a \( \beta \) mide 7 m y el adyacente 24 m. Halla la hipotenusa, \( \beta \) y el ángulo restante.',
                        'solucion' => 'Hipotenusa: \( \sqrt{7^2 + 24^2} = 25 \) m<br>\( \beta = \arctan\left(\frac{7}{24}\right) \approx 16.26^\circ \)<br>Otro ángulo: \( 73.74^\circ \)'
                    ],
                    [
                        'enunciado' => 'El cateto opuesto a \( \gamma \) mide 15 cm y el adyacente 20 cm. Calcula todos los elementos faltantes del triángulo.',
                        'solucion' => 'Hipotenusa: \( \sqrt{15^2 + 20^2} = 25 \) cm<br>\( \gamma = \arctan\left(\frac{15}{20}\right) \approx 36.87^\circ \)<br>Otro ángulo: \( 53.13^\circ \)'
                    ],
                    [
                        'enunciado' => 'Un triángulo rectángulo tiene catetos de 9 dm (opuesto a \( \theta \)) y 12 dm (adyacente a \( \theta \)). Encuentra la hipotenusa, \( \theta \) y el otro ángulo.',
                        'solucion' => 'Hipotenusa: \( \sqrt{9^2 + 12^2} = 15 \) dm<br>\( \theta = \arctan\left(\frac{9}{12}\right) \approx 36.87^\circ \)<br>Otro ángulo: \( 53.13^\circ \)'
                    ]
                ];

                foreach ($grupo1 as $index => $problema) {
                    echo '
                    <div class="card problem-card">
                        <div class="card-body">
                            <h5 class="card-title problem-title">Problema ' . ($index + 1) . '</h5>
                            <p class="card-text">' . $problema['enunciado'] . '</p>
                            
                            <div id="solution1-' . $index . '" class="solution collapse">
                                <strong class="text-primary"><i class="bi bi-lightbulb-fill me-2"></i>Solución:</strong><br>' . $problema['solucion'] . '
                            </div>
                        </div>
                    </div>';
                }
                ?>
            </div>

            <!-- Grupo 2 -->
            <div class="col-lg-6">
                <div class="group-title">
                    <h2 class="mb-0"><i class="bi bi-2-circle-fill me-2"></i>Un cateto y la hipotenusa</h2>
                </div>
                
                <?php
                $grupo2 = [
                    [
                        'enunciado' => 'El cateto opuesto al ángulo de \( 30^\circ \) mide 7 cm. Determina la hipotenusa, el cateto adyacente y el otro ángulo.',
                        'solucion' => 'Hipotenusa: \( \frac{7}{\sin(30^\circ)} = 14 \) cm<br>Cateto adyacente: \( \sqrt{14^2 - 7^2} = 7\sqrt{3} \) cm<br>Otro ángulo: \( 60^\circ \)'
                    ],
                    [
                        'enunciado' => 'La hipotenusa mide 13 m y el cateto adyacente a \( \alpha \) mide 5 m. Halla el cateto opuesto, \( \alpha \) y el otro ángulo.',
                        'solucion' => 'Cateto opuesto: \( \sqrt{13^2 - 5^2} = 12 \) m<br>\( \alpha = \arccos\left(\frac{5}{13}\right) \approx 67.38^\circ \)<br>Otro ángulo: \( 22.62^\circ \)'
                    ],
                    [
                        'enunciado' => 'En un triángulo rectángulo, el cateto adyacente a \( \beta \) mide 4 cm y la hipotenusa 5 cm. Calcula todos los elementos.',
                        'solucion' => 'Cateto opuesto: \( \sqrt{5^2 - 4^2} = 3 \) cm<br>\( \beta = \arccos\left(\frac{4}{5}\right) \approx 36.87^\circ \)<br>Otro ángulo: \( 53.13^\circ \)'
                    ],
                    [
                        'enunciado' => 'La hipotenusa es 17 dm y el cateto opuesto a \( \theta \) mide 8 dm. Encuentra los elementos desconocidos.',
                        'solucion' => 'Cateto adyacente: \( \sqrt{17^2 - 8^2} = 15 \) dm<br>\( \theta = \arcsin\left(\frac{8}{17}\right) \approx 28.07^\circ \)<br>Otro ángulo: \( 61.93^\circ \)'
                    ],
                    [
                        'enunciado' => 'El cateto adyacente al ángulo de \( 60^\circ \) mide 6 cm. Determina la hipotenusa, el cateto opuesto y el otro ángulo.',
                        'solucion' => 'Hipotenusa: \( \frac{6}{\cos(60^\circ)} = 12 \) cm<br>Cateto opuesto: \( \sqrt{12^2 - 6^2} = 6\sqrt{3} \) cm<br>Otro ángulo: \( 30^\circ \)'
                    ]
                ];

                foreach ($grupo2 as $index => $problema) {
                    echo '
                    <div class="card problem-card">
                        <div class="card-body">
                            <h5 class="card-title problem-title">Problema ' . ($index + 6) . '</h5>
                            <p class="card-text">' . $problema['enunciado'] . '</p>
                            
                            <div id="solution2-' . $index . '" class="solution collapse">
                                <strong class="text-primary"><i class="bi bi-lightbulb-fill me-2"></i>Solución:</strong><br>' . $problema['solucion'] . '
                            </div>
                        </div>
                    </div>';
                }
                ?>
            </div>
        </div>
    </div>
<script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.3/dist/umd/popper.min.js"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
<script>
    MathJax.typeset();
</script>
</main>
 <?php include 'subir.php'; ?>
</body>
</html>
