<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Matemática Virtual, Ing.MSc. Fernando Carrillo & Ing.MSc. Cecilia Izurieta</title>
    <!-- Bootstrap CSS -->
    <link href="../bootstrap/css/bootstrap.min.css" rel="stylesheet">
    <!-- MathJax for LaTeX -->
    <script src="https://polyfill.io/v3/polyfill.min.js?features=es6"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
</head>
<body>
    <?php include 'encabezado.php'; ?>
    <main>
        <?php include 'menui.php'; ?>
    <main>
    <?php include 'menui.php'; ?>
    <div class="container mt-5 overflow-auto">
        <h1 class="text-center">Ejercicios de Transformaciones de Unidades</h1>

        <?php
        function randomValue($min, $max) {
            return rand($min, $max);
        }

        $ejercicios = [
            "Longitud" => [
                "Convierte " . randomValue(1, 100) . " metros a centímetros.",
                "Convierte " . randomValue(10, 500) . " kilómetros a metros.",
                "Convierte " . randomValue(100, 10000) . " milímetros a metros.",
                "Convierte " . randomValue(1, 50) . " metros a milímetros.",
                "Convierte " . randomValue(1, 200) . " centímetros a metros.",
                "Convierte " . randomValue(1, 100) . " kilómetros a centímetros.",
                "Convierte " . randomValue(1, 1000) . " milímetros a centímetros.",
                "Convierte " . randomValue(1, 300) . " centímetros a milímetros.",
                "Convierte " . randomValue(1, 50) . " metros a kilómetros.",
                "Convierte " . randomValue(1, 500) . " metros a milímetros."
            ],
            "Masa" => [
                "Convierte " . randomValue(1, 1000) . " gramos a miligramos.",
                "Convierte " . randomValue(1, 100) . " kilogramos a gramos.",
                "Convierte " . randomValue(1000, 1000000) . " miligramos a gramos.",
                "Convierte " . randomValue(1, 50) . " kilogramos a miligramos.",
                "Convierte " . randomValue(1, 2000) . " gramos a kilogramos.",
                "Convierte " . randomValue(1, 100) . " toneladas a kilogramos.",
                "Convierte " . randomValue(1, 1000000) . " miligramos a kilogramos.",
                "Convierte " . randomValue(1, 500) . " gramos a toneladas.",
                "Convierte " . randomValue(1, 50) . " kilogramos a toneladas.",
                "Convierte " . randomValue(1, 200) . " toneladas a gramos."
            ],
            "Tiempo" => [
                "Convierte " . randomValue(1, 60) . " minutos a segundos.",
                "Convierte " . randomValue(1, 24) . " horas a minutos.",
                "Convierte " . randomValue(1, 365) . " días a horas.",
                "Convierte " . randomValue(1, 10) . " semanas a días.",
                "Convierte " . randomValue(1, 12) . " meses a días.",
                "Convierte " . randomValue(1, 60) . " segundos a milisegundos.",
                "Convierte " . randomValue(1, 24) . " días a semanas.",
                "Convierte " . randomValue(1, 24) . " horas a segundos.",
                "Convierte " . randomValue(1, 12) . " meses a semanas.",
                "Convierte " . randomValue(1, 60) . " minutos a horas."
            ]
        ];

        $all_exercises = [];
        foreach ($ejercicios as $categoria => $lista) {
            $all_exercises = array_merge($all_exercises, $lista);
        }

        // Shuffle the array to ensure randomness
        shuffle($all_exercises);
        // Limit the array to 50 exercises
        $all_exercises = array_slice($all_exercises, 0, 50);
        ?>
<?php $i=1;?>
        <h2 class="mt-4">Ejercicios</h2>
        <ul class="list-group mb-4">
            <?php foreach ($all_exercises as $ejercicio): ?>
                <ul class="card mb-4">
                <h5 class="card-title">Ejercicio <?php echo $i; ?></h5>
                <?php $i=$i+1;?>
                <li class="mb-3"><?php echo $ejercicio; ?></li></ul>
            <?php endforeach; ?>
        </ul>
    
    </div>

    <!-- Bootstrap JS and dependencies -->
    <script>
        // Capturar el evento de clic en el botón de descarga
        document.getElementById('btnDescargarPDF').addEventListener('click', function() {
            // Seleccionar el contenedor de ejercicios
            var element = document.querySelector('.list-group');

            // Opciones para la generación del PDF
            var options = {
                margin:       0.5,
                filename:     'ejercicios.pdf',
                image:        { type: 'jpeg', quality: 0.98 },
                html2canvas:  { scale: 3 },
                jsPDF:        { unit: 'in', format: 'letter', orientation: 'portrait' }
            };

            // Generar el PDF
            html2pdf().from(element).set(options).save();
        });
    </script>

    <!-- Agregar referencia a la biblioteca html2pdf -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/html2pdf.js/0.9.2/html2pdf.bundle.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.3/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    </main>
</main>
<?php include 'subir.php'; ?>
</body>
</html>
