<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ejercicios de Razonamiento Matemático</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://polyfill.io/v3/polyfill.min.js?features=es6"></script>
    <script type="text/javascript" id="MathJax-script" async
            src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
</head>
<body>
<div class="container mt-5">
    <h1 class="text-center mb-4">Ejercicios de Razonamiento Matemático</h1>

    <!-- Ejercicios -->
    <div class="accordion" id="accordionExercises">
        <!-- Generar ejercicios en un loop -->
        <script>
            const exercises = [
                // Problemas de Edad
                {
                    title: "Problema de Edad 1",
                    question: "La suma de las edades de Ana y su madre es de 50 años. La edad de la madre es el triple de la edad de Ana. ¿Qué edad tiene cada una?"
                },
                {
                    title: "Problema de Edad 2",
                    question: "Pedro tiene 4 años más que Juan. Si la suma de sus edades es 24 años, ¿qué edad tiene cada uno?"
                },
                {
                    title: "Problema de Edad 3",
                    question: "La edad de Ana es el doble de la edad de su hermano menor. Si la suma de sus edades es 36 años, ¿qué edad tiene cada uno?"
                },
                {
                    title: "Problema de Edad 4",
                    question: "El padre de Juan tiene 5 veces la edad de Juan. Si dentro de 10 años la suma de sus edades será 70 años, ¿qué edad tiene cada uno ahora?"
                },
                {
                    title: "Problema de Edad 5",
                    question: "El abuelo de María tiene 4 veces su edad. Si hace 5 años la suma de sus edades era 60 años, ¿qué edad tiene cada uno ahora?"
                },
                {
                    title: "Problema de Edad 6",
                    question: "Sofía tiene 5 años menos que su hermano mayor. Si dentro de 3 años la suma de sus edades será 29 años, ¿qué edad tiene cada uno ahora?"
                },
                {
                    title: "Problema de Edad 7",
                    question: "La madre de Luis tiene 3 veces la edad de Luis. Si hace 6 años la madre tenía 4 veces la edad de Luis, ¿qué edad tiene cada uno ahora?"
                },
                {
                    title: "Problema de Edad 8",
                    question: "Hace 10 años, la edad de Marta era la mitad de la edad que tiene ahora. ¿Qué edad tiene Marta ahora?"
                },
                {
                    title: "Problema de Edad 9",
                    question: "La suma de las edades de Pedro y su padre es 42 años. Si el padre tiene el doble de la edad de Pedro, ¿qué edad tiene cada uno?"
                },
                {
                    title: "Problema de Edad 10",
                    question: "La edad de Carlos es el triple de la edad de su hermana menor. Si la suma de sus edades es 28 años, ¿qué edad tiene cada uno?"
                },
                // Problemas de Dinero
                {
                    title: "Problema de Dinero 1",
                    question: "Pedro tiene el doble de dinero que Juan y entre los dos tienen 60 dólares. ¿Cuánto dinero tiene cada uno?"
                },
                {
                    title: "Problema de Dinero 2",
                    question: "Ana tiene 3 veces más dinero que María. Si juntas tienen 80 dólares, ¿cuánto dinero tiene cada una?"
                },
                {
                    title: "Problema de Dinero 3",
                    question: "Carlos tiene 5 dólares más que Laura. Si juntos tienen 45 dólares, ¿cuánto dinero tiene cada uno?"
                },
                {
                    title: "Problema de Dinero 4",
                    question: "Luis tiene el triple de dinero que su hermano menor. Si entre los dos tienen 120 dólares, ¿cuánto dinero tiene cada uno?"
                },
                {
                    title: "Problema de Dinero 5",
                    question: "Elena tiene 20 dólares menos que su amiga Sara. Si juntas tienen 100 dólares, ¿cuánto dinero tiene cada una?"
                },
                {
                    title: "Problema de Dinero 6",
                    question: "Ricardo tiene el doble de dinero que su amigo Pablo. Si Ricardo le da 10 dólares a Pablo, tendrán la misma cantidad de dinero. ¿Cuánto dinero tiene cada uno?"
                },
                {
                    title: "Problema de Dinero 7",
                    question: "Sofía tiene 5 dólares más que su hermano mayor. Si Sofía tiene 15 dólares, ¿cuánto dinero tienen juntos?"
                },
                {
                    title: "Problema de Dinero 8",
                    question: "La suma del dinero de Ana y Luis es 70 dólares. Si Luis tiene 10 dólares más que Ana, ¿cuánto dinero tiene cada uno?"
                },
                {
                    title: "Problema de Dinero 9",
                    question: "Carlos y Pedro tienen el mismo dinero. Si Pedro le da 5 dólares a Carlos, entonces Carlos tendrá el doble de dinero que Pedro. ¿Cuánto dinero tiene cada uno?"
                },
                {
                    title: "Problema de Dinero 10",
                    question: "El dinero de Juan es el triple del dinero de Luis. Si juntos tienen 80 dólares, ¿cuánto dinero tiene cada uno?"
                },
                // Problemas de Velocidades
                {
                    title: "Problema de Velocidad 1",
                    question: "Un coche viaja 60 km/h durante 2 horas y luego a 80 km/h durante 3 horas. ¿Cuál es la velocidad media del viaje?"
                },
                {
                    title: "Problema de Velocidad 2",
                    question: "Una bicicleta viaja a 20 km/h durante 1.5 horas y luego a 15 km/h durante 2 horas. ¿Cuál es la velocidad media del viaje?"
                },
                {
                    title: "Problema de Velocidad 3",
                    question: "Un tren viaja a 100 km/h durante 4 horas y luego a 120 km/h durante 3 horas. ¿Cuál es la velocidad media del viaje?"
                },
                {
                    title: "Problema de Velocidad 4",
                    question: "Un avión vuela a 600 km/h durante 2 horas y luego a 500 km/h durante 1.5 horas. ¿Cuál es la velocidad media del vuelo?"
                },
                {
                    title: "Problema de Velocidad 5",
                    question: "Un barco navega a 30 km/h durante 3 horas y luego a 40 km/h durante 4 horas. ¿Cuál es la velocidad media del viaje?"
                },
                {
                    title: "Problema de Velocidad 6",
                    question: "Un ciclista pedalea a 25 km/h durante 2 horas y luego a 20 km/h durante 1.5 horas. ¿Cuál es la velocidad media del recorrido?"
                },
                {
                    title: "Problema de Velocidad 7",
                    question: "Un tren de carga viaja a 70 km/h durante 5 horas y luego a 90 km/h durante 2 horas. ¿Cuál es la velocidad media del viaje?"
                },
                {
                    title: "Problema de Velocidad 8",
                    question: "Un coche deportivo viaja a 120 km/h durante 1 hora y luego a 100 km/h durante 2 horas. ¿Cuál es la velocidad media del viaje?"
                },
                {
                    title: "Problema de Velocidad 9",
                    question: "Una moto viaja a 80 km/h durante 3 horas y luego a 60 km/h durante 1 hora. ¿Cuál es la velocidad media del viaje?"
                },
                {
                    title: "Problema de Velocidad 10",
                    question: "Un tren bala viaja a 300 km/h durante 1 hora y luego a 250 km/h durante 2 horas. ¿Cuál es la velocidad media del viaje?"
                },
                // Problemas de Fracciones
                {
                    title: "Problema de Fracción 1",
                    question: "¿Cuál es el resultado de \\( \\frac{3}{4} + \\frac{5}{6} \\)?"
                },
                {
                    title: "Problema de Fracción 2",
                    question: "¿Cuál es el resultado de \\( \\frac{2}{3} - \\frac{1}{4} \\)?"
                },
                {
                    title: "Problema de Fracción 3",
                    question: "¿Cuál es el resultado de \\( \\frac{7}{8} \\times \\frac{2}{5} \\)?"
                },
                {
                    title: "Problema de Fracción 4",
                    question: "¿Cuál es el resultado de \\( \\frac{9}{10} \\div \\frac{3}{4} \\)?"
                },
                {
                    title: "Problema de Fracción 5",
                    question: "Simplifica la fracción \\( \\frac{20}{28} \\)."
                },
                {
                    title: "Problema de Fracción 6",
                    question: "Convierte la fracción \\( \\frac{7}{5} \\) a un número mixto."
                },
                {
                    title: "Problema de Fracción 7",
                    question: "Convierte el número mixto \\( 2 \\frac{3}{4} \\) a una fracción impropia."
                },
                {
                    title: "Problema de Fracción 8",
                    question: "¿Cuál es el resultado de \\( 3 \\frac{2}{3} - 1 \\frac{1}{2} \\)?"
                },
                {
                    title: "Problema de Fracción 9",
                    question: "¿Cuál es el resultado de \\( 5 \\frac{1}{4} + 2 \\frac{2}{3} \\)?"
                },
                {
                    title: "Problema de Fracción 10",
                    question: "Simplifica la fracción \\( \\frac{45}{60} \\)."
                },
                // Problemas de Series
                {
                    title: "Problema de Serie 1",
                    question: "Encuentra el siguiente número en la serie: 2, 4, 6, 8, __."
                },
                {
                    title: "Problema de Serie 2",
                    question: "Encuentra el siguiente número en la serie: 3, 6, 9, 12, __."
                },
                {
                    title: "Problema de Serie 3",
                    question: "Encuentra el siguiente número en la serie: 5, 10, 15, 20, __."
                },
                {
                    title: "Problema de Serie 4",
                    question: "Encuentra el siguiente número en la serie: 1, 4, 9, 16, __."
                },
                {
                    title: "Problema de Serie 5",
                    question: "Encuentra el siguiente número en la serie: 2, 5, 10, 17, __."
                },
                {
                    title: "Problema de Serie 6",
                    question: "Encuentra el siguiente número en la serie: 7, 14, 21, 28, __."
                },
                {
                    title: "Problema de Serie 7",
                    question: "Encuentra el siguiente número en la serie: 6, 12, 18, 24, __."
                },
                {
                    title: "Problema de Serie 8",
                    question: "Encuentra el siguiente número en la serie: 8, 16, 24, 32, __."
                },
                {
                    title: "Problema de Serie 9",
                    question: "Encuentra el siguiente número en la serie: 11, 22, 33, 44, __."
                },
                {
                    title: "Problema de Serie 10",
                    question: "Encuentra el siguiente número en la serie: 13, 26, 39, 52, __."
                }
            ];

            const accordionExercises = document.getElementById('accordionExercises');

            exercises.forEach((exercise, index) => {
                const card = document.createElement('div');
                card.className = 'card';

                const cardHeader = document.createElement('div');
                cardHeader.className = 'card-header';
                cardHeader.id = `heading${index}`;

                const h2 = document.createElement('h2');
                h2.className = 'mb-0';

                const button = document.createElement('button');
                button.className = 'btn btn-link';
                button.type = 'button';
                button.setAttribute('data-toggle', 'collapse');
                button.setAttribute('data-target', `#collapse${index}`);
                button.setAttribute('aria-expanded', 'true');
                button.setAttribute('aria-controls', `collapse${index}`);
                button.textContent = exercise.title;

                h2.appendChild(button);
                cardHeader.appendChild(h2);
                card.appendChild(cardHeader);

                const collapse = document.createElement('div');
                collapse.id = `collapse${index}`;
                collapse.className = 'collapse';
                collapse.setAttribute('aria-labelledby', `heading${index}`);
                collapse.setAttribute('data-parent', '#accordionExercises');

                const cardBody = document.createElement('div');
                cardBody.className = 'card-body';

                const pQuestion = document.createElement('p');
                pQuestion.className = 'card-text';
                pQuestion.textContent = exercise.question;

                cardBody.appendChild(pQuestion);
                collapse.appendChild(cardBody);
                card.appendChild(collapse);
                accordionExercises.appendChild(card);
            });
        </script>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.6/dist/umd/popper.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.min.js"></script>
</body>
</html>
