<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ejercicios de Razonamiento Matemático: Problemas de Edad</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://polyfill.io/v3/polyfill.min.js?features=es6"></script>
    <script type="text/javascript" id="MathJax-script" async
            src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
</head>
<body>
    <?php include '../encabezado.php'; ?>
<div class="container mt-5">
    <h1 class="text-center mb-4">Ejercicios de Razonamiento Matemático: Problemas de Edad</h1>

    <!-- Ejercicios -->
    <div class="accordion" id="accordionExercises">
        <!-- Generar ejercicios en un loop -->
        <script>
            const exercises = [
                {
                    title: "Problema de Edad 1",
                    question: "La suma de las edades de Ana y su madre es de 50 años. La edad de la madre es el triple de la edad de Ana. ¿Qué edad tiene cada una?"
                },
                {
                    title: "Problema de Edad 2",
                    question: "Pedro tiene 4 años más que Juan. Si la suma de sus edades es 24 años, ¿qué edad tiene cada uno?"
                },
                {
                    title: "Problema de Edad 3",
                    question: "La edad de Ana es el doble de la edad de su hermano menor. Si la suma de sus edades es 36 años, ¿qué edad tiene cada uno?"
                },
                {
                    title: "Problema de Edad 4",
                    question: "El padre de Juan tiene 5 veces la edad de Juan. Si dentro de 10 años la suma de sus edades será 70 años, ¿qué edad tiene cada uno ahora?"
                },
                {
                    title: "Problema de Edad 5",
                    question: "El abuelo de María tiene 4 veces su edad. Si hace 5 años la suma de sus edades era 60 años, ¿qué edad tiene cada uno ahora?"
                },
                {
                    title: "Problema de Edad 6",
                    question: "Sofía tiene 5 años menos que su hermano mayor. Si dentro de 3 años la suma de sus edades será 29 años, ¿qué edad tiene cada uno ahora?"
                },
                {
                    title: "Problema de Edad 7",
                    question: "La madre de Luis tiene 3 veces la edad de Luis. Si hace 6 años la madre tenía 4 veces la edad de Luis, ¿qué edad tiene cada uno ahora?"
                },
                {
                    title: "Problema de Edad 8",
                    question: "Hace 10 años, la edad de Marta era la mitad de la edad que tiene ahora. ¿Qué edad tiene Marta ahora?"
                },
                {
                    title: "Problema de Edad 9",
                    question: "La suma de las edades de Pedro y su padre es 42 años. Si el padre tiene el doble de la edad de Pedro, ¿qué edad tiene cada uno?"
                },
                {
                    title: "Problema de Edad 10",
                    question: "La edad de Carlos es el triple de la edad de su hermana menor. Si la suma de sus edades es 28 años, ¿qué edad tiene cada uno?"
                },
                {
                    title: "Problema de Edad 11",
                    question: "Hace 4 años, la edad de Ana era el doble de la edad de Juan. Si Juan ahora tiene 8 años, ¿qué edad tiene Ana?"
                },
                {
                    title: "Problema de Edad 12",
                    question: "Dentro de 5 años, la edad de María será el triple de la edad de su hermana menor. Si la hermana menor ahora tiene 5 años, ¿qué edad tiene María?"
                },
                {
                    title: "Problema de Edad 13",
                    question: "El padre de Pedro tiene 6 veces su edad. Dentro de 8 años, la suma de sus edades será 72 años. ¿Qué edad tiene cada uno ahora?"
                },
                {
                    title: "Problema de Edad 14",
                    question: "La madre de Sofía tiene 4 veces su edad. Hace 6 años, la madre tenía 7 veces la edad de Sofía. ¿Qué edad tiene cada una ahora?"
                },
                {
                    title: "Problema de Edad 15",
                    question: "Hace 12 años, la edad de Juan era un tercio de la edad que tiene ahora. ¿Qué edad tiene Juan ahora?"
                },
                {
                    title: "Problema de Edad 16",
                    question: "Dentro de 8 años, la edad de Pedro será el doble de la edad que tenía hace 4 años. ¿Qué edad tiene Pedro ahora?"
                },
                {
                    title: "Problema de Edad 17",
                    question: "La edad de Ana es 5 años menos que el doble de la edad de su hermano. Si su hermano tiene 10 años, ¿qué edad tiene Ana?"
                },
                {
                    title: "Problema de Edad 18",
                    question: "La edad de Juan es un cuarto de la edad de su abuelo. Si la suma de sus edades es 65 años, ¿qué edad tiene cada uno?"
                },
                {
                    title: "Problema de Edad 19",
                    question: "Hace 7 años, la edad de Marta era un tercio de la edad de su madre. Si la madre ahora tiene 45 años, ¿qué edad tiene Marta?"
                },
                {
                    title: "Problema de Edad 20",
                    question: "Dentro de 10 años, la edad de Pedro será el doble de la edad que tenía hace 5 años. ¿Qué edad tiene Pedro ahora?"
                },
                {
                    title: "Problema de Edad 21",
                    question: "El hermano mayor de Ana tiene 3 veces su edad. Si dentro de 6 años la suma de sus edades será 40 años, ¿qué edad tiene cada uno ahora?"
                },
                {
                    title: "Problema de Edad 22",
                    question: "La edad de Pedro es la mitad de la edad de su madre. Si la madre tiene 36 años, ¿qué edad tiene Pedro?"
                },
                {
                    title: "Problema de Edad 23",
                    question: "Hace 5 años, la edad de Juan era el doble de la edad de su hermana menor. Si la hermana menor ahora tiene 15 años, ¿qué edad tiene Juan?"
                },
                {
                    title: "Problema de Edad 24",
                    question: "Dentro de 7 años, la edad de Marta será 3 veces la edad de su hermano menor. Si el hermano menor ahora tiene 7 años, ¿qué edad tiene Marta?"
                },
                {
                    title: "Problema de Edad 25",
                    question: "El padre de Luis tiene 8 veces su edad. Si hace 2 años la suma de sus edades era 50 años, ¿qué edad tiene cada uno ahora?"
                },
                {
                    title: "Problema de Edad 26",
                    question: "La madre de Sofía tiene 5 veces su edad. Si hace 4 años la madre tenía 6 veces la edad de Sofía, ¿qué edad tiene cada una ahora?"
                },
                {
                    title: "Problema de Edad 27",
                    question: "Hace 3 años, la edad de Pedro era la mitad de la edad de su hermana mayor. Si la hermana mayor ahora tiene 18 años, ¿qué edad tiene Pedro?"
                },
                {
                    title: "Problema de Edad 28",
                    question: "La edad de Ana es el triple de la edad de su hermano menor. Si dentro de 5 años la suma de sus edades será 50 años, ¿qué edad tiene cada uno ahora?"
                },
                {
                    title: "Problema de Edad 29",
                    question: "Dentro de 6 años, la edad de Juan será 4 veces la edad que tenía hace 6 años. ¿Qué edad tiene Juan ahora?"
                },
                {
                    title: "Problema de Edad 30",
                    question: "El abuelo de Pedro tiene 7 veces su edad. Si hace 5 años la suma de sus edades era 70 años, ¿qué edad tiene cada uno ahora?"
                },
                {
                    title: "Problema de Edad 31",
                    question: "Hace 8 años, la edad de Ana era un tercio de la edad que tiene ahora. ¿Qué edad tiene Ana ahora?"
                },
                {
                    title: "Problema de Edad 32",
                    question: "Dentro de 9 años, la edad de María será el doble de la edad que tenía hace 3 años. ¿Qué edad tiene María ahora?"
                },
                {
                    title: "Problema de Edad 33",
                    question: "La edad de Pedro es 4 años menos que el triple de la edad de su hermano. Si su hermano tiene 6 años, ¿qué edad tiene Pedro?"
                },
                {
                    title: "Problema de Edad 34",
                    question: "La edad de Juan es un quinto de la edad de su abuelo. Si la suma de sus edades es 60 años, ¿qué edad tiene cada uno?"
                },
                {
                    title: "Problema de Edad 35",
                    question: "Hace 9 años, la edad de Marta era un cuarto de la edad de su madre. Si la madre ahora tiene 50 años, ¿qué edad tiene Marta?"
                },
                {
                    title: "Problema de Edad 36",
                    question: "Dentro de 11 años, la edad de Pedro será el triple de la edad que tenía hace 2 años. ¿Qué edad tiene Pedro ahora?"
                },
                {
                    title: "Problema de Edad 37",
                    question: "La edad de Ana es 7 años menos que el doble de la edad de su hermano. Si su hermano tiene 12 años, ¿qué edad tiene Ana?"
                },
                {
                    title: "Problema de Edad 38",
                    question: "La edad de Juan es un sexto de la edad de su abuelo. Si la suma de sus edades es 72 años, ¿qué edad tiene cada uno?"
                },
                {
                    title: "Problema de Edad 39",
                    question: "Hace 10 años, la edad de Marta era un quinto de la edad de su madre. Si la madre ahora tiene 55 años, ¿qué edad tiene Marta?"
                },
                {
                    title: "Problema de Edad 40",
                    question: "Dentro de 12 años, la edad de Pedro será el cuádruple de la edad que tenía hace 3 años. ¿Qué edad tiene Pedro ahora?"
                },
                {
                    title: "Problema de Edad 41",
                    question: "El hermano mayor de Ana tiene 2 veces su edad. Si dentro de 8 años la suma de sus edades será 48 años, ¿qué edad tiene cada uno ahora?"
                },
                {
                    title: "Problema de Edad 42",
                    question: "La edad de Pedro es la mitad de la edad de su madre. Si la madre tiene 40 años, ¿qué edad tiene Pedro?"
                },
                {
                    title: "Problema de Edad 43",
                    question: "Hace 6 años, la edad de Juan era el triple de la edad de su hermana menor. Si la hermana menor ahora tiene 18 años, ¿qué edad tiene Juan?"
                },
                {
                    title: "Problema de Edad 44",
                    question: "Dentro de 5 años, la edad de Marta será 2 veces la edad de su hermano menor. Si el hermano menor ahora tiene 10 años, ¿qué edad tiene Marta?"
                },
                {
                    title: "Problema de Edad 45",
                    question: "El padre de Luis tiene 9 veces su edad. Si hace 3 años la suma de sus edades era 60 años, ¿qué edad tiene cada uno ahora?"
                },
                {
                    title: "Problema de Edad 46",
                    question: "La madre de Sofía tiene 6 veces su edad. Si hace 5 años la madre tenía 7 veces la edad de Sofía, ¿qué edad tiene cada una ahora?"
                },
                {
                    title: "Problema de Edad 47",
                    question: "Hace 4 años, la edad de Pedro era el doble de la edad de su hermana mayor. Si la hermana mayor ahora tiene 20 años, ¿qué edad tiene Pedro?"
                },
                {
                    title: "Problema de Edad 48",
                    question: "La edad de Ana es el cuádruple de la edad de su hermano menor. Si dentro de 6 años la suma de sus edades será 60 años, ¿qué edad tiene cada uno ahora?"
                },
                {
                    title: "Problema de Edad 49",
                    question: "Dentro de 7 años, la edad de Juan será 5 veces la edad que tenía hace 7 años. ¿Qué edad tiene Juan ahora?"
                },
                {
                    title: "Problema de Edad 50",
                    question: "El abuelo de Pedro tiene 10 veces su edad. Si hace 6 años la suma de sus edades era 80 años, ¿qué edad tiene cada uno ahora?"
                }
            ];

            const accordionExercises = document.getElementById('accordionExercises');

            exercises.forEach((exercise, index) => {
                const card = document.createElement('div');
                card.className = 'card';

                const cardHeader = document.createElement('div');
                cardHeader.className = 'card-header';
                cardHeader.id = `heading${index}`;

                const h2 = document.createElement('h2');
                h2.className = 'mb-0';

                const button = document.createElement('button');
                button.className = 'btn btn-link';
                button.type = 'button';
                button.setAttribute('data-toggle', 'collapse');
                button.setAttribute('data-target', `#collapse${index}`);
                button.setAttribute('aria-expanded', 'true');
                button.setAttribute('aria-controls', `collapse${index}`);
                button.textContent = exercise.title;

                h2.appendChild(button);
                cardHeader.appendChild(h2);
                card.appendChild(cardHeader);

                const collapse = document.createElement('div');
                collapse.id = `collapse${index}`;
                collapse.className = 'collapse';
                collapse.setAttribute('aria-labelledby', `heading${index}`);
                collapse.setAttribute('data-parent', '#accordionExercises');

                const cardBody = document.createElement('div');
                cardBody.className = 'card-body';

                const pQuestion = document.createElement('p');
                pQuestion.className = 'card-text';
                pQuestion.textContent = exercise.question;

                cardBody.appendChild(pQuestion);
                collapse.appendChild(cardBody);
                card.appendChild(collapse);
                accordionExercises.appendChild(card);
            });
        </script>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.6/dist/umd/popper.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.min.js"></script>
<?php include '../pie.php'; ?>
</body>
</html>
