<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ejercicios Matemáticos</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
    <!-- MathJax para fórmulas matemáticas -->
    <script src="https://polyfill.io/v3/polyfill.min.js?features=es6"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <style>
        .problem-card {
            margin-bottom: 25px;
            box-shadow: 0 6px 12px rgba(0,0,0,0.15);
            border-radius: 10px;
            border: none;
            transition: transform 0.3s ease;
        }
        .problem-card:hover {
            transform: translateY(-5px);
        }
        .problem-title {
            color: #0d6efd;
            font-weight: bold;
            border-bottom: 2px solid #0d6efd;
            padding-bottom: 8px;
            margin-bottom: 15px;
        }
        .solution {
            display: none;
            background-color: #f8f9fa;
            padding: 20px;
            border-radius: 8px;
            margin-top: 15px;
            border-left: 4px solid #0d6efd;
        }
        .header-section {
            background: linear-gradient(135deg, #0d6efd, #0b5ed7);
            color: white;
            padding: 30px 0;
            margin-bottom: 40px;
            border-radius: 0 0 15px 15px;
            box-shadow: 0 4px 20px rgba(13, 110, 253, 0.3);
        }
        .btn-solution {
            background-color: #0d6efd;
            color: white;
            font-weight: 500;
            margin-top: 10px;
        }
        .btn-solution:hover {
            background-color: #0b5ed7;
            color: white;
        }
        .footer {
            background-color: #f8f9fa;
            padding: 20px 0;
            margin-top: 40px;
            text-align: center;
            border-top: 1px solid #dee2e6;
        }
    </style>
</head>
<body>
    <!-- Header -->
    <div class="header-section">
        <div class="container">
            <div class="row">
                <div class="col-12 text-center">
                    <h1 class="display-4 mb-3"><i class="bi bi-calculator"></i> Ejercicios Matemáticos</h1>
                    <p class="lead">Resuelve problemas de sistemas de ecuaciones lineales</p>
                </div>
            </div>
        </div>
    </div>

    <div class="container py-4">
        <div class="row">
            <div class="col-12">
                <!-- Ejercicio 1 -->
                <div class="card problem-card">
                    <div class="card-body">
                        <h5 class="card-title problem-title">Problema 1</h5>
                        <p class="card-text"><strong>Enunciado:</strong> Carlos va al mercado y compra manzanas y naranjas. Sabe que el precio de una manzana es de $3 y el de una naranja es de $2. Si Carlos compró 4 manzanas y 6 naranjas y pagó un total de $24, ¿cuánto pagaría si compra 7 manzanas y 3 naranjas?</p>
                        
                </div>

                <!-- Ejercicio 2 -->
                <div class="card problem-card">
                    <div class="card-body">
                        <h5 class="card-title problem-title">Problema 2</h5>
                        <p class="card-text"><strong>Enunciado:</strong> En un test de 50 preguntas, Luis obtuvo 170 puntos. Si por cada acierto se suman 6 puntos y por cada fallo se restan 3 puntos, ¿cuántas respuestas correctas e incorrectas respondió Luis?</p>
                        
                </div>

                <!-- Ejercicio 3 -->
                <div class="card problem-card">
                    <div class="card-body">
                        <h5 class="card-title problem-title">Problema 3</h5>
                        <p class="card-text"><strong>Enunciado:</strong> En una fábrica de jugos, se quiere mezclar jugo de manzana y jugo de uva para obtener 120 litros de una mezcla. El jugo de manzana cuesta $4 por litro y el de uva cuesta $2 por litro. Si se quiere gastar un total de $380 en la mezcla, ¿cuántos litros de cada jugo se deben usar?</p>
                       
                    </div>
                </div>

                <!-- Ejercicio 4 -->
                <div class="card problem-card">
                    <div class="card-body">
                        <h5 class="card-title problem-title">Problema 4</h5>
                        <p class="card-text"><strong>Enunciado:</strong> En un grupo de dos personas, la suma de sus edades es 60 años. Además, se sabe que una persona tiene el doble de la edad de la otra. ¿Cuáles son las edades de ambas personas?</p>
                        
                    </div>
                </div>

                <!-- Ejercicio 5 -->
                <div class="card problem-card">
                    <div class="card-body">
                        <h5 class="card-title problem-title">Problema 5</h5>
                        <p class="card-text"><strong>Enunciado:</strong> La suma de dos números es 300, y su diferencia es 50. ¿Cuáles son los números?</p>
                       
                    </div>
                </div>

                <!-- Ejercicio 6 -->
                <div class="card problem-card">
                    <div class="card-body">
                        <h5 class="card-title problem-title">Problema 6</h5>
                        <p class="card-text"><strong>Enunciado:</strong> Las entradas de 4 niños y 3 adultos a un parque de diversiones valen 130 dólares, y las de 2 niños y un adulto valen 40 dólares. ¿Cuánto valen las entradas de un niño y un adulto?</p>
                        <button class="btn btn-solution" data-bs-toggle="collapse" data-bs-target="#solution6" aria-expanded="false" aria-controls="solution6">
                            <i class="bi bi-eye-fill me-1"></i> Mostrar solución
                        </button>
                        <div id="solution6" class="solution collapse">
                            <strong class="text-primary"><i class="bi bi-lightbulb-fill me-2"></i>Solución:</strong><br>
                            <p>Planteamos el sistema:</p>
                            <p>1) \( 4n + 3a = 130 \)</p>
                            <p>2) \( 2n + a = 40 \)</p>
                            <p>Despejamos \( a \) de la segunda ecuación: \( a = 40 - 2n \)</p>
                            <p>Sustituimos en la primera ecuación:</p>
                            <p>\( 4n + 3(40 - 2n) = 130 \)</p>
                            <p>\( 4n + 120 - 6n = 130 \)</p>
                            <p>\( -2n = 10 \) → \( n = -5 \) (no tiene sentido)</p>
                            <p>Revisando los datos, parece haber un error. Con los precios dados:</p>
                            <p>\( 4 \times 15 + 3 \times 25 = 60 + 75 = 135 \neq 130 \)</p>
                            <p>\( 2 \times 15 + 25 = 30 + 25 = 55 \neq 40 \)</p>
                            <p>Resolviendo correctamente:</p>
                            <p>De \( 2n + a = 40 \) → \( a = 40 - 2n \)</p>
                            <p>Sustituyendo en la primera ecuación:</p>
                            <p>\( 4n + 3(40 - 2n) = 130 \)</p>
                            <p>\( 4n + 120 - 6n = 130 \)</p>
                            <p>\( -2n = 10 \) → \( n = -5 \) (imposible)</p>
                            <p><strong>Respuesta dada:</strong> Niño: $15, Adulto: $25 (pero no cumple con las ecuaciones)</p>
                        </div>
                    </div>
                </div>

                <!-- Ejercicio 7 -->
                <div class="card problem-card">
                    <div class="card-body">
                        <h5 class="card-title problem-title">Problema 7</h5>
                        <p class="card-text"><strong>Enunciado:</strong> En un corral hay patos y ovejas, en total hay 18 cabezas y 46 patas. ¿Cuántos patos y cuántas ovejas hay en el corral?</p>
                       
                    </div>
                </div>

                <!-- Ejercicio 8 -->
                <div class="card problem-card">
                    <div class="card-body">
                        <h5 class="card-title problem-title">Problema 8</h5>
                        <p class="card-text"><strong>Enunciado:</strong> En un test de 60 preguntas, Luis obtuvo 195 puntos. Si por cada acierto se suman 5 puntos y por cada fallo se restan 2 puntos, ¿cuántas respuestas correctas e incorrectas respondió Luis?</p>
                       
                    </div>
                </div>

                <!-- Ejercicio 9 -->
                <div class="card problem-card">
                    <div class="card-body">
                        <h5 class="card-title problem-title">Problema 9</h5>
                        <p class="card-text"><strong>Enunciado:</strong> El perímetro de un rectángulo mide 40 cm, si se duplica el largo y se aumenta en 8 cm el ancho, el perímetro será 84 cm. ¿Cuáles son las medidas del rectángulo original? ¿Y cuáles son las medidas del rectángulo agrandado?</p>
                     
                    </div>
                </div>

                <!-- Ejercicio 10 -->
                <div class="card problem-card">
                    <div class="card-body">
                        <h5 class="card-title problem-title">Problema 10</h5>
                        <p class="card-text"><strong>Enunciado:</strong> El perímetro de un triángulo equilátero mide 27 cm, pero si se duplican los lados iguales y se triplica el lado desigual su perímetro será de 72 cm. ¿Cuánto miden los lados del triángulo original?</p>
                       
                    </div>
                </div>

<!-- Ejercicio 11 -->
                <div class="card problem-card">
                    <div class="card-body">
                        <h5 class="card-title problem-title">Problema 11</h5>
                        <p class="card-text"><strong>Enunciado:</strong> La suma de tres números consecutivos es 78, encontras los número ?</p>
                    
                    </div>
                </div>

<!-- Ejercicio 12-->
                <div class="card problem-card">
                    <div class="card-body">
                        <h5 class="card-title problem-title">Problema 12</h5>
                        <p class="card-text"><strong>Enunciado:</strong> La suma de tres números pares consecutivos es 306, encontras los número ?</p>
                    
                    </div>
                </div>
 <!-- Ejercicio 13 -->
                <div class="card problem-card">
                    <div class="card-body">
                        <h5 class="card-title problem-title">Problema 13</h5>
                        <p class="card-text"><strong>Enunciado:</strong> La suma de tres números impares consecutivos es 759, encontras los número ?</p>
                    
                    </div>


            </div>
        
    <!-- Ejercicio 14 -->
                <div class="card problem-card">
                    <div class="card-body">
                        <h5 class="card-title problem-title">Problema 14</h5>
                        <p class="card-text"><strong>Enunciado:</strong> La suma de un número y 12 es igual a 25. ¿Cuál es el número?</p>
                    
                    </div>


            </div>
        
    <!-- Ejercicio 13 -->
                <div class="card problem-card">
                    <div class="card-body">
                        <h5 class="card-title problem-title">Problema 15</h5>
                        <p class="card-text"><strong>Enunciado:</strong> Si restamos 8 al triple de un número, obtenemos 19. Halla el número.</p>
                    
                    </div>


            </div>
        
    <!-- Ejercicio 13 -->
                <div class="card problem-card">
                    <div class="card-body">
                        <h5 class="card-title problem-title">Problema 16</h5>
                        <p class="card-text"><strong>Enunciado:</strong> Si a un número le sumamos su mitad, obtenemos 36. ¿Cuál es el número?</p>
                    
                    </div>


            </div>
        
    <!-- Ejercicio 13 -->
                <div class="card problem-card">
                    <div class="card-body">
                        <h5 class="card-title problem-title">Problema 17</h5>
                        <p class="card-text"><strong>Enunciado:</strong> Si al cuadrado de un número le restamos 16, obtenemos el mismo número. Halla dicho número.</p>
                    
                    </div>


            </div>
        
    <!-- Ejercicio 13 -->
                <div class="card problem-card">
                    <div class="card-body">
                        <h5 class="card-title problem-title">Problema 18</h5>
                        <p class="card-text"><strong>Enunciado:</strong> Un número es 5 veces otro. Si su suma es 42, encuentra ambos números.</p>
                    
                    </div>


            </div>
        
    <!-- Footer -->
  

    <!-- Bootstrap JS Bundle with Popper -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>