<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ejercicios de Razonamiento Matemático: Problemas de Edad</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://polyfill.io/v3/polyfill.min.js?features=es6"></script>
    <script type="text/javascript" id="MathJax-script" async
            src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
</head>
<body>
    <?php include '../encabezado.php'; ?>
<div class="container mt-5">
    <h1 class="text-center mb-4">Ejercicios de Razonamiento Matemático: Problemas de Edad</h1>

    <!-- Ejercicios -->
    <div class="accordion" id="accordionExercises">
        <!-- Generar ejercicios en un loop -->
        <script>
            const exercises = [
                {
                    title: "Problema de Edad 1",
                    question: "La suma de las edades de Ana y su madre es de 50 años. La edad de la madre es el triple de la edad de Ana. ¿Qué edad tiene cada una?",
                    solution: "Sea A la edad de Ana y M la edad de su madre. Tenemos dos ecuaciones: A + M = 50 y M = 3A. Sustituyendo M en la primera ecuación: A + 3A = 50 \\Rightarrow 4A = 50 \\Rightarrow A = 12.5. Entonces, M = 3 \\times 12.5 = 37.5. Ana tiene 12.5 años y su madre 37.5 años."
                },
                {
                    title: "Problema de Edad 2",
                    question: "Pedro tiene 4 años más que Juan. Si la suma de sus edades es 24 años, ¿qué edad tiene cada uno?",
                    solution: "Sea J la edad de Juan y P la edad de Pedro. Tenemos dos ecuaciones: P = J + 4 y J + P = 24. Sustituyendo P en la segunda ecuación: J + (J + 4) = 24 \\Rightarrow 2J + 4 = 24 \\Rightarrow 2J = 20 \\Rightarrow J = 10. Entonces, P = 10 + 4 = 14. Juan tiene 10 años y Pedro 14 años."
                },
                {
                    title: "Problema de Edad 3",
                    question: "La edad de Ana es el doble de la edad de su hermano menor. Si la suma de sus edades es 36 años, ¿qué edad tiene cada uno?",
                    solution: "Sea A la edad de Ana y H la edad de su hermano. Tenemos dos ecuaciones: A = 2H y A + H = 36. Sustituyendo A en la segunda ecuación: 2H + H = 36 \\Rightarrow 3H = 36 \\Rightarrow H = 12. Entonces, A = 2 \\times 12 = 24. Ana tiene 24 años y su hermano 12 años."
                },
                {
                    title: "Problema de Edad 4",
                    question: "El padre de Juan tiene 5 veces la edad de Juan. Si dentro de 10 años la suma de sus edades será 70 años, ¿qué edad tiene cada uno ahora?",
                    solution: "Sea J la edad de Juan y P la edad de su padre. Tenemos dos ecuaciones: P = 5J y (J + 10) + (P + 10) = 70. Sustituyendo P en la segunda ecuación: (J + 10) + (5J + 10) = 70 \\Rightarrow J + 10 + 5J + 10 = 70 \\Rightarrow 6J + 20 = 70 \\Rightarrow 6J = 50 \\Rightarrow J = 8.33. Entonces, P = 5 \\times 8.33 = 41.67. Juan tiene 8.33 años y su padre 41.67 años."
                },
                {
                    title: "Problema de Edad 5",
                    question: "El abuelo de María tiene 4 veces su edad. Si hace 5 años la suma de sus edades era 60 años, ¿qué edad tiene cada uno ahora?",
                    solution: "Sea M la edad de María y A la edad de su abuelo. Tenemos dos ecuaciones: A = 4M y (M - 5) + (A - 5) = 60. Sustituyendo A en la segunda ecuación: (M - 5) + (4M - 5) = 60 \\Rightarrow M - 5 + 4M - 5 = 60 \\Rightarrow 5M - 10 = 60 \\Rightarrow 5M = 70 \\Rightarrow M = 14. Entonces, A = 4 \\times 14 = 56. María tiene 14 años y su abuelo 56 años."
                }
                // Puedes agregar más ejercicios en este formato...
            ];

            const accordionExercises = document.getElementById('accordionExercises');

            exercises.forEach((exercise, index) => {
                const card = document.createElement('div');
                card.className = 'card';

                const cardHeader = document.createElement('div');
                cardHeader.className = 'card-header';
                cardHeader.id = `heading${index}`;

                const h2 = document.createElement('h2');
                h2.className = 'mb-0';

                const button = document.createElement('button');
                button.className = 'btn btn-link';
                button.type = 'button';
                button.setAttribute('data-toggle', 'collapse');
                button.setAttribute('data-target', `#collapse${index}`);
                button.setAttribute('aria-expanded', 'true');
                button.setAttribute('aria-controls', `collapse${index}`);
                button.textContent = exercise.title;

                h2.appendChild(button);
                cardHeader.appendChild(h2);
                card.appendChild(cardHeader);

                const collapse = document.createElement('div');
                collapse.id = `collapse${index}`;
                collapse.className = 'collapse';
                collapse.setAttribute('aria-labelledby', `heading${index}`);
                collapse.setAttribute('data-parent', '#accordionExercises');

                const cardBody = document.createElement('div');
                cardBody.className = 'card-body';

                const pQuestion = document.createElement('p');
                pQuestion.className = 'card-text';
                pQuestion.textContent = exercise.question;

                const pSolution = document.createElement('p');
                pSolution.className = 'card-text';
                pSolution.innerHTML = `<strong>Solución:</strong> <br> ${exercise.solution}`;

                cardBody.appendChild(pQuestion);
                cardBody.appendChild(pSolution);
                collapse.appendChild(cardBody);
                card.appendChild(collapse);
                accordionExercises.appendChild(card);
            });
        </script>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.6/dist/umd/popper.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.min.js"></script>
</body>
<?php include '../pie.php'; ?>
</html>
