<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Matemática Virtual, Ing.MSc. Fernando Carrillo & Ing.MSc. Cecilia Izurieta</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/latex.js/0.10.3/latex.min.js"></script>
    <script id="MathJax-script" async src="latex.js"></script>
    <style>
        .exercise {
            margin-bottom: 20px;
        }
    </style>
</head>
<body>
    <?php include 'encabezado.php'; ?>
    <main>
        <?php include 'menui.php'; ?>
        
<div class="container">
    <h1 class="my-4">Generador de Ejercicios de División de Polinomios</h1>
    <div id="exercises"></div>
</div>
<script>
    function getRandomInt(min, max) {
        return Math.floor(Math.random() * (max - min + 1)) + min;
    }

    function generatePolynomial(coefs) {
        let polynomial = '';
        for (let i = 0; i < coefs.length; i++) {
            let coeff = coefs[i];
            let degree = coefs.length - i - 1;
            if (coeff !== 0) {
                let sign = coeff > 0 && i > 0 ? ' + ' : (coeff < 0 && i > 0 ? ' - ' : '');
                let term = Math.abs(coeff);
                if (degree === 0) {
                    polynomial += `${sign}${term}`;
                } else if (degree === 1) {
                    polynomial += `${sign}${term}x`;
                } else {
                    polynomial += `${sign}${term}x^${degree}`;
                }
            }
        }
        return polynomial;
    }

    function generateExercise(model) {
        let Pcoefs = model.P.map(() => getRandomInt(-10, 10));
        let Dcoefs = model.D.map(() => getRandomInt(-10, 10));
        let P = generatePolynomial(Pcoefs);
        let D = generatePolynomial(Dcoefs);
        return `Divide \\( P(x) = ${P} \\) entre \\( D(x) = ${D} \\).`;
    }

    document.addEventListener("DOMContentLoaded", function () {
        let models = [
           {P: [20,+ 18, -17, 16, -15], D: [1, -1]},
            {P: [21,+ 18, -17, 16, -15, 14], D: [1, -1]},
            {P: [22,+ 18, -17], D: [1, -1]},
            {P: [23,+ 18, -17, 16], D: [1, -1]},
            {P: [24,+ 18, -17, 16, -15], D: [1, -1]},
            {P: [25,+ 18, -17, 16, -15, 14], D: [1, -1]},
            {P: [26,+ 18, -17, 16, -15, 14, -13], D: [1, -1]},
            {P: [27,+ 18, -17], D: [1, -1]},
            {P: [28,+ 18, -17, ], D: [1, -1]},
            {P: [2, 3, -5, 4, -6], D: [1, -1, 1]},
            {P: [1, -3, 4, -1, 2, -8], D: [1, 2, -3]},
            {P: [3, 1, -2, 4, -3, 1, -7], D: [1, 0, -1, 1]},
            {P: [1, -2, 3, -1, 5], D: [1, 0, -1]},
            {P: [5, 6, -7, 8, -9, 10], D: [1, 3, 2]},
            {P: [4, -5, 3, -1, 2, -1, 4], D: [1, 1, -2, 1]},
            {P: [6, -7, 8, -9, 6], D: [1, -2, 1]},
            {P: [7, 5, -4, 3, -2, 1], D: [1, 1, -1]},
            {P: [9, -8, 7, -6, 5, -4, 3], D: [1, -1, 1, -1]},
            {P: [8, 7, -6, 5, -4], D: [1, 2, 3]},
            {P: [10, -9, 8, -7, 6, -5], D: [1, 1, -1, 1]},
            {P: [11, 10, -9, 8, -7, 6, -4], D: [1, -2, 3]},
            {P: [12, 11, -10, 9, -8, 7], D: [1, 2, -1, 1]},
            {P: [13, -12, 11, -10, 9], D: [1, 3, -2]},
            {P: [14, 13, -12, 11, -10, 9, -8], D: [1, -2, 1, -1]},
            {P: [15, 14, -13, 12, -11, 10], D: [1, 2, -3]},
            {P: [16, 15, -14, 13, -12, 11, -10], D: [1, 1, -2, 1]},
            {P: [17, 16, -15, 14, -13], D: [1, -1, 2]},
            {P: [18, 17, -16, 15, -14, 13], D: [1, 1, -2]},
            {P: [19,+ 18, -17, 16], D: [1, -1, 2, -1]}
            





        ];
        let exercisesContainer = document.getElementById('exercises');
        for (let i = 0; i < models.length; i++) {
            let exercise = generateExercise(models[i]);
            let exerciseDiv = document.createElement('div');
            exerciseDiv.className = 'exercise';
            exerciseDiv.innerHTML = `<div class="card"><div class="card-body"><p class="card-text">${exercise}</p></div></div>`;
            exercisesContainer.appendChild(exerciseDiv);
        }
        latex.renderMathInElement(document.body);
    });
</script>

 <?php include 'subir2.php'; ?>
</body>
</html>
