<?php
// Incluir la conexión a la base de datos y TCPDF
require_once("include/dbcommon.php");
require_once('tcpdf_include.php');

// Crear nuevo documento PDF
$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

// Establecer la información del documento
$pdf->SetCreator(PDF_CREATOR);
$pdf->SetAuthor('Sistema Escolar');
$pdf->SetTitle('Ficha del Alumno');
$pdf->SetSubject('Reporte');
$pdf->SetKeywords('PDF, ficha, alumno');

// Configuración del PDF
$pdf->setPrintHeader(false);
$pdf->setPrintFooter(false);
$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
$pdf->AddPage();

$conn->set_charset("utf8");

if (isset($_GET['id']) && is_numeric($_GET['id'])) {
    $id = intval($_GET['id']);
} else {
    die("ID no válido o no proporcionado.");
}

$sql = "SELECT * FROM actas WHERE id = $id";
$result = $conn->query($sql);
if ($result->num_rows == 0) {
    die("No se encontró el acta con el ID proporcionado.");
}

$acta = $result->fetch_assoc();
$especialidad = $acta['Especialidad'];
$curso = $acta['Curso'];
$paralelo = $acta['Paralelo'];
$trimestre = $acta['Trimestre'];
$cedula = $acta['CedulaE'];
$docente = $acta['Docente'];
$asignatura = $acta['Asignatura'];
$estudiante = $acta['Estudinate'];
$representante = $acta['Representante'];
$cedular = $acta['CedularR'];

$html = ''; // Variable para almacenar el HTML generado

// Estilos en línea para mejorar la presentación de las tablas
$styles = "
<style>
    .encabezado-container {
        width: 20px;
        max-width: 50%;
        height: 100px;
        margin: 0 auto;
    }
    .header-container {
        width: 100%;
        text-align: center;
        font-family: Arial, sans-serif;
    }
    .header-title {
        font-size: 18px;
        font-weight: bold;
        margin: 0;
    }
    .header-subtitle {
        font-size: 12px;
        margin: 0;
    }
    .header-logo {
        width: 50px;
        height: auto;
    }
    h3 {
        color: #333;
        font-family: Arial, sans-serif;
        font-size: 7px;
        text-align: left;
    }
    h4 {
        color: #333;
        font-family: Arial, sans-serif;
        font-size: 7px;
        text-align: left;
    }
    li {
        color: #333;
        font-family: Arial;
        font-size: 7px;
        text-align: left;
    }
    p {
        color: #333;
        font-family: Arial, sans-serif;
        font-size: 7px;
        text-align: left;
    }

    table {
        width: 100%;
        border-collapse: collapse;
        font-family: Arial, sans-serif;
        font-size: 7px;
    }
    th {
        background-color: #a5adb0;
        color: black;
        font-weight: bold;
        padding: 8px;
        border: 1px solid #ddd;
        text-align: left;
        font-size: 8px;
    }
    td {
        padding: 8px;
        border: 1px solid #ddd;
        text-align: left;
        font-size: 7px;
    }
    .td1 {
        padding: 8px;
        border: 1px solid #ddd;
        text-align: left;
        font-size: 12px;
    }
    tr:nth-child(even) {background-color: #f2f2f2;}
</style>
";

$html .= $styles;

// PRIMERO: OBTENER Y MOSTRAR EL LOGO
$sql_logo = "CALL logo(?)";
if ($stmt5 = $conn->prepare($sql_logo)) {
    $stmt5->bind_param("s", $docente);
    
    if ($stmt5->execute()) {
        $result5 = $stmt5->get_result();

        if ($result5->num_rows > 0) {
            while ($row5 = $result5->fetch_assoc()) {
                $logo_data = $row5['logo'] ?? '';
                $institucion = $row5['institucion'] ?? '';

                if (!empty($logo_data)) {
                    try {
                        // Crear una imagen temporal
                        $temp_dir = sys_get_temp_dir();
                        $temp_image = tempnam($temp_dir, 'logo') . '.png';
                        
                        // Guardar los datos BLOB como imagen
                        if (file_put_contents($temp_image, $logo_data) !== false) {
                            // Verificar que el archivo se creó correctamente
                            if (file_exists($temp_image) && filesize($temp_image) > 0) {
                                // Insertar la imagen en el PDF
                                $pdf->Image($temp_image, 15, 15, 25, 0, 'PNG', '', 'T', false, 300, '', false, false, 0, false, false, false);
                                
                                // Limpiar archivo temporal
                                unlink($temp_image);
                            } else {
                                error_log("El archivo temporal no se creó correctamente");
                            }
                        } else {
                            error_log("No se pudo guardar el archivo temporal del logo");
                        }
                    } catch (Exception $e) {
                        error_log("Error al procesar el logo: " . $e->getMessage());
                    }
                } else {
                    error_log("Logo data está vacío");
                }

                // Añadir el nombre de la institución
                if (!empty($institucion)) {
                    $pdf->SetXY(50, 20);
                    $pdf->SetFont('helvetica', 'B', 14);
                    $pdf->Cell(0, 10, utf8_decode($institucion), 0, 1, 'L');
                }
            }
        } else {
            // Si no hay logo, solo mostrar el nombre de la institución
            $html .= "<div style='text-align: center;'><h2>Sistema Escolar</h2></div>";
        }
    } else {
        error_log("Error al ejecutar la consulta del logo: " . $stmt5->error);
    }
    $stmt5->close();
} else {
    error_log("Error al preparar la consulta del logo: " . $conn->error);
}

// Agregar espacio después del logo
$html .= "<br>";

// NOMBRE DEL ESTUDIANTE
$sql_nombre = "CALL nombre(?, ?, ?, ?, ?)";
if ($stmt4 = $conn->prepare($sql_nombre)) {
    $stmt4->bind_param("sssss", $especialidad, $curso, $paralelo, $trimestre, $cedula);
    
    if ($stmt4->execute()) {
        $result4 = $stmt4->get_result();

        if ($result4->num_rows > 0) {
            $html .= "<br><br><table>";
            $html .= "<tr>";
            
            // Obtener nombres de columnas
            $fields = $result4->fetch_fields();
            foreach ($fields as $field) {
                $html .= "<th>" . htmlspecialchars($field->name) . "</th>";
            }
            $html .= "</tr>";

            while ($row4 = $result4->fetch_assoc()) {
                $html .= "<tr>";
                foreach ($row4 as $cell) {
                    $html .= "<td class=\"td1\">" . htmlspecialchars($cell) . "</td>";
                }
                $html .= "</tr>";
            }
            $html .= "</table><br>";
        } else {
            $html .= "<p>No se encontraron datos del estudiante.</p>";
        }
    } else {
        $html .= "<p>Error al ejecutar la consulta del nombre.</p>";
    }
    $stmt4->close();
} else {
    $html .= "<p>Error al preparar la consulta del nombre.</p>";
}

// ENCABEZADO
$sql_encabezado = "CALL encabezado(?, ?, ?, ?, ?)";
if ($stmt1 = $conn->prepare($sql_encabezado)) {
    $stmt1->bind_param("sssss", $especialidad, $curso, $paralelo, $trimestre, $cedula);
    
    if ($stmt1->execute()) {
        $result1 = $stmt1->get_result();

        if ($result1->num_rows > 0) {
            $html .= "<br><table>";
            $html .= "<tr>";
            
            $fields = $result1->fetch_fields();
            foreach ($fields as $field) {
                $html .= "<th>" . htmlspecialchars($field->name) . "</th>";
            }
            $html .= "</tr>";

            while ($row1 = $result1->fetch_assoc()) {
                $html .= "<tr>";
                foreach ($row1 as $cell) {
                    $html .= "<td>" . htmlspecialchars($cell) . "</td>";
                }
                $html .= "</tr>";
            }
            $html .= "</table><br>";
        } else {
            $html .= "<p>No se encontraron resultados en Encabezado.</p>";
        }
    } else {
        $html .= "<p>Error al ejecutar la consulta del encabezado.</p>";
    }
    $stmt1->close();
} else {
    $html .= "<p>Error al preparar la consulta del encabezado.</p>";
}

// CALIFICACIONES
$sql_calificaciones = "CALL Calificaciones(?, ?, ?, ?, ?)";
if ($stmt2 = $conn->prepare($sql_calificaciones)) {
    $stmt2->bind_param("sssss", $especialidad, $curso, $paralelo, $trimestre, $cedula);
    
    if ($stmt2->execute()) {
        $result2 = $stmt2->get_result();

        if ($result2->num_rows > 0) {
            $html .= "<h3>Calificaciones</h3><table>";
            $html .= "<tr>";
            
            $fields = $result2->fetch_fields();
            foreach ($fields as $field) {
                $html .= "<th>" . htmlspecialchars($field->name) . "</th>";
            }
            $html .= "</tr>";

            while ($row2 = $result2->fetch_assoc()) {
                $html .= "<tr>";
                foreach ($row2 as $cell) {
                    $html .= "<td>" . htmlspecialchars($cell) . "</td>";
                }
                $html .= "</tr>";
            }
            $html .= "</table><br>";
        } else {
            $html .= "<p>No se encontraron calificaciones.</p>";
        }
    } else {
        $html .= "<p>Error al ejecutar la consulta de calificaciones.</p>";
    }
    $stmt2->close();
} else {
    $html .= "<p>Error al preparar la consulta de calificaciones.</p>";
}

// PROMEDIOS
$sql_promedios = "CALL promediotrim(?, ?)";
if ($stmt6 = $conn->prepare($sql_promedios)) {
    $stmt6->bind_param("ss", $cedula, $asignatura);
    
    if ($stmt6->execute()) {
        $result6 = $stmt6->get_result();

        if ($result6->num_rows > 0) {
            $html .= "<h3>Promedios</h3><table>";
            $html .= "<tr>";
            
            $fields = $result6->fetch_fields();
            foreach ($fields as $field) {
                $html .= "<th>" . htmlspecialchars($field->name) . "</th>";
            }
            $html .= "</tr>";

            while ($row6 = $result6->fetch_assoc()) {
                $html .= "<tr>";
                foreach ($row6 as $cell) {
                    $html .= "<td>" . htmlspecialchars($cell) . "</td>";
                }
                $html .= "</tr>";
            }
            $html .= "</table><br>";
        } else {
            $html .= "<p>No se encontraron calificaciones.</p>";
        }
    } else {
        $html .= "<p>Error al ejecutar la consulta de calificaciones.</p>";
    }
    $stmt6->close();
} else {
    $html .= "<p>Error al preparar la consulta de calificaciones.</p>";
}
//REFUERZOS
$sql_refuerzo= "CALL refuerzotrim(?, ?, ?)";
if ($stmt7 = $conn->prepare($sql_refuerzo)) {
    $stmt7->bind_param("sss", $cedula, $asignatura, $trimestre);
    
    if ($stmt7->execute()) {
        $result7 = $stmt7->get_result();

        if ($result7->num_rows > 0) {
            $html .= "<h3>Llamados a Refuerzo y Recuperación</h3><table>";
            $html .= "<tr>";
            
            $fields = $result7->fetch_fields();
            foreach ($fields as $field) {
                $html .= "<th>" . htmlspecialchars($field->name) . "</th>";
            }
            $html .= "</tr>";

            while ($row7 = $result7->fetch_assoc()) {
                $html .= "<tr>";
                foreach ($row7 as $cell) {
                    $html .= "<td>" . htmlspecialchars($cell) . "</td>";
                }
                $html .= "</tr>";
            }
            $html .= "</table><br>";
        } else {
            $html .= "<p>No se encontraron refuerzos.</p>";
        }
    } else {
        $html .= "<p>Error al ejecutar la consulta de refuerzos.</p>";
    }
    $stmt7->close();
} else {
    $html .= "<p>Error al preparar la consulta de refuerzos.</p>";
}
// REPRESENTANTE
$sql_representante = "CALL representante(?,?)";
if ($stmt3 = $conn->prepare($sql_representante)) {
    $stmt3->bind_param("ss", $cedula, $trimestre);
    
    if ($stmt3->execute()) {
        $result3 = $stmt3->get_result();

        if ($result3->num_rows > 0) {
            $html .= "<h3>Llamados al Representante</h3><table>";
            $html .= "<tr>";
            
            $fields = $result3->fetch_fields();
            foreach ($fields as $field) {
                $html .= "<th>" . htmlspecialchars($field->name) . "</th>";
            }
            $html .= "</tr>";

            while ($row3 = $result3->fetch_assoc()) {
                $html .= "<tr>";
                foreach ($row3 as $cell) {
                    $html .= "<td>" . htmlspecialchars($cell) . "</td>";
                }
                $html .= "</tr>";
            }
            $html .= "</table><br>";
        } else {
            $html .= "<p>No se encontraron llamados al representante.</p>";
        }
    } else {
        $html .= "<p>Error al ejecutar la consulta del representante.</p>";
    }
    $stmt3->close();
} else {
    $html .= "<p>Error al preparar la consulta del representante.</p>";
}

// Asegúrate de que estas variables tengan valores ANTES del CALL
// y que no sean sobrescritas después

// 1. Definir variables con prefijo claro
$acta_cedula = $cedula;
$acta_asignatura = $asignatura;
$acta_trimestre = $trimestre;
$acta_estudiante = $estudiante; // VALOR FIJO del PDF
$acta_curso = $curso; // VALOR FIJO del PDF
$acta_paralelo = $paralelo; // VALOR FIJO del PDF
$acta_especialidad = $especialidad; // VALOR FIJO del PDF
$acta_representante = $representante; // CAMBIAR
$acta_cedula_rep = $cedular; // CAMBIAR

// 2. Llamar al procedimiento con variables limpias
$sql_acta = "CALL acta2(?,?,?,?,?,?,?,?,?)";
if ($stmt8 = $conn->prepare($sql_acta)) {
    $stmt8->bind_param("sssssssss", 
        $acta_cedula,
        $acta_asignatura,
        $acta_trimestre,
        $acta_estudiante,
        $acta_curso,
        $acta_paralelo,
        $acta_especialidad,
        $acta_representante,
        $acta_cedula_rep
    );
    
    if ($stmt8->execute()) {
        $result8 = $stmt8->get_result();
        
        if ($result8->num_rows > 0) {
            $html .= "<div style='page-break-before: always;'>";
            
            while ($row8 = $result8->fetch_assoc()) {
                foreach ($row8 as $key => $value) {
                    if ($key === 'ACTA_COMPROMISO') {
                        $html .= $value;
                    } elseif ($key === 'DEBUG_INFO') {
                        $html .= "<div style='background: #fff3cd; padding: 10px; border: 1px solid #ffeaa7; margin: 10px 0;'>";
                        $html .= "<h10>Debug del procedimiento:</h10>";
                        $html .= "<pre>" . htmlspecialchars($value) . "</pre>";
                        $html .= "</div>";
                    }
                }
            }
            
            $html .= "</div>";
        }
    }
    $stmt8->close();
}




$html .= " <h4>FIRMAS:<br><br><br><br>


_________________________________________<br>
Representante: {$acta['Representante']}<br>
C.I.:  {$acta['CedularR']}<br><br><br><br>

_________________________________________<br>
Estudiante: {$acta['Estudinate']}<br>
C.I.:  {$acta['CedulaE']}<br>

Acta N°: {$acta['id']}<br>
Fecha: {$acta['Fecha']}</h4>";



// Escribir el contenido HTML en el PDF
$pdf->writeHTML($html, true, false, true, false, '');

// Output del PDF
$pdf->Output('ficha_alumno_' . $cedula . '.pdf', 'D');

// Cerrar la conexión
$conn->close();
?>