<?php
require('fpdf/fpdf.php');

// Configurar conexión a la base de datos con UTF-8
$host = "localhost";
$user = "fernando"; 
$password = "170232cc"; 
$database = "libro";

$conn = new mysqli($host, $user, $password, $database);
if ($conn->connect_error) {
    die("Error de conexión: " . $conn->connect_error);
}
// Establecer el conjunto de caracteres a UTF-8
$conn->set_charset("utf8");

if (isset($_GET['id']) && is_numeric($_GET['id'])) {
    $id = intval($_GET['id']);
} else {
    die("ID no válido o no proporcionado.");
}

$sql = "SELECT * FROM actas WHERE id = $id";
$result = $conn->query($sql);
if ($result->num_rows == 0) {
    die("No se encontró el acta con el ID proporcionado.");
}

$acta = $result->fetch_assoc();

// Clase PDF mejorada para manejar UTF-8
class PDF extends FPDF
{
    function Header()
    {
        $this->Image('Logo.jpg', 10, 6, 15);
        $this->SetFont('Arial', '', 12);
        $this->Cell(0, 8, utf8_decode('ACTA DE COMPROMISO ACADÉMICO POR SUPLETORIO'), 0, 1, 'C');
        $this->Ln(3);
    }

    function Footer()
    {
        $this->SetY(-15);
        $this->SetFont('Arial', '', 8);
    }
    
    // Función para escribir texto con UTF-8
    function WriteUTF8($h, $txt)
    {
        $this->Write($h, utf8_decode($txt));
    }
    
    // Función para MultiCell con UTF-8
    function MultiCellUTF8($w, $h, $txt, $border=0, $align='J', $fill=false)
    {
        $this->MultiCell($w, $h, utf8_decode($txt), $border, $align, $fill);
    }
}

$pdf = new PDF();
$pdf->AddPage();
$pdf->SetFont('Arial', '', 8);

// Texto del acta con manejo adecuado de UTF-8
$texto_acta = "
Sr. representante legal, luego de haber desarrollado diferentes estrategias para lograr recuperar el aprendizaje requerido en el/la estudiante como: 

. Clases de recuperación académica en el aula.
. Consejería y recomendaciones para mejorar su nivel de responsabilidad. 
. Citaciones al padre o madre de familia.
. Oportunidades para presentar trabajos atrasados y lecciones.
. Oportunidades con segundas oportunidades en lecciones.
. Llamadas telefónicas para comunicar novedades a la/el representante 
. Nivelación de conocimiento de la educación general básica con el curso Algebra Básica de la Universidad Autónoma de México 
. Visitas a domicilio si fuera el caso.
. Clase fuera del horario de clases para nivelar conocimientos y mejorar calificaciones.
 
Sin embargo, estas estrategias no han perimtido que el estudiante logre alcanzar el puntaje necesario, basándose en lo que establece el Reglamento General a la Ley Orgánica de Educación Intercultural – En el Capítulo IV De las acciones de evaluación, retroalimentación y refuerzo académico – Art. 204 al 208. Además del RLOE 132 literal f). Usted como madre/padre o representante se compromete a colaborar de manera inmediata con su estudiante en el desarrollo control de las actividades académicas mostrando responsabilidad en sus obligaciones como tales, ya que hasta el momento no se ha cumplido. 

El estudiante: {$acta['Estudinate']} del {$acta['Curso']} curso, paralelo {$acta['Paralelo']} de la especialidad de {$acta['Especialidad']} tiene una calificación inferior a siete puntos sobre diez, correspondiente al promedio general en la asignatura de {$acta['Asignatura']} del año lectivo en curso, por lo que debererá rendir un examen supletorio en la fecha indicada por la autoridad comptetente, por tanto, el estudiante debe iniciar un proceso de nivelación urgente, dirigida por el representante y coordinada por el docente de la asignatura. 



Luego de ser leída la presente acta, acepto lo expuesto  y  como padre/madre de familia o representante legal, me sujetaré a las resoluciones y disposiciones que tomare la Unidad Educativa , de acuerdo a la Ley y Reglamento de la LOEI y al código de Convivencia.

Para constancia, firmamos la presente acta.


FIRMAS:
// Continuación del texto del acta


_________________________________________
Representante: {$acta['Representante']}

_________________________________________
Estudiante: {$acta['Estudinate']}

_________________________________________
Docente: {$acta['Docente']}
Acta N°: {$acta['id']}
Fecha: {$acta['Fecha']}";

// Escribir el texto completo usando la función MultiCellUTF8
$pdf->MultiCellUTF8(0, 5, $texto_acta);

// Salida del PDF para descarga
$pdf->Output('D', 'Acta_Supletorio.pdf');

// Redirigir a la página actas_list.php
header("Location: actas_list.php");
exit();
$conn->close();
?>
