<?php
require('fpdf/fpdf.php');

// Configurar conexión a la base de datos con UTF-8
$host = "localhost";
$user = "fernando"; 
$password = "170232cc"; 
$database = "libro";

$conn = new mysqli($host, $user, $password, $database);
if ($conn->connect_error) {
    die("Error de conexión: " . $conn->connect_error);
}
// Establecer el conjunto de caracteres a UTF-8
$conn->set_charset("utf8");

if (isset($_GET['id']) && is_numeric($_GET['id'])) {
    $id = intval($_GET['id']);
} else {
    die("ID no válido o no proporcionado.");
}

$sql = "SELECT * FROM actas WHERE id = $id";
$result = $conn->query($sql);
if ($result->num_rows == 0) {
    die("No se encontró el acta con el ID proporcionado.");
}

$acta = $result->fetch_assoc();

// Clase PDF mejorada para manejar UTF-8
class PDF extends FPDF
{
    function Header()
    {
        $this->Image('Logo.jpg', 10, 6, 15);
        $this->SetFont('Arial', '', 8);
        $this->Cell(0, 8, utf8_decode('ACTA DE INFORMACIÓN A REPRESENTANTE LEGAL SOBRE REFUERZO Y RECUPERACIÓN PEDAGÓGICA'), 0, 1, 'C');
        $this->Ln(3);
    }

    function Footer()
    {
        $this->SetY(-15);
        $this->SetFont('Arial', '', 8);
    }
    
    // Función para escribir texto con UTF-8
    function WriteUTF8($h, $txt)
    {
        $this->Write($h, utf8_decode($txt));
    }
    
    // Función para MultiCell con UTF-8
    function MultiCellUTF8($w, $h, $txt, $border=0, $align='J', $fill=false)
    {
        $this->MultiCell($w, $h, utf8_decode($txt), $border, $align, $fill);
    }
}

$pdf = new PDF();
$pdf->AddPage();
$pdf->SetFont('Arial', '', 7);

// Texto del acta con manejo adecuado de UTF-8
$texto_acta = "
OBJETIVOS:
Informar a los representantes legales sobre el proceso de refuerzo pedagógico recibido por el estudiante, conforme a lo dispuesto en el Artículo 9 del Acuerdo Ministerial MINEDUC-MINEDUC-2024-00031-A.
Garantizar que los representantes legales tengan conocimiento del desempeño académico del estudiante y de las estrategias implementadas para mejorar su aprendizaje.
FINES:
Asegurar que los representantes legales participen activamente en el proceso de recuperación académica de los estudiantes.
Fortalecer el acompañamiento educativo y la comunicación entre la institución y la familia para garantizar el éxito del refuerzo pedagógico.


CONSIDERANDO QUE:
El artículo 9 del Acuerdo Ministerial MINEDUC-MINEDUC-2024-00031-A establece que, para la detección temprana de bajos desempeños de aprendizaje, se deben realizar los siguientes pasos:
Analizar la información de evaluaciones formativas para identificar estudiantes con bajos resultados. 
Identificar y notificar a los estudiantes y sus representantes legales sobre los bajos desempeños.
Implementar estrategias de refuerzo pedagógico para la mejora de aprendizajes. Promediar las actividades de refuerzo pedagógico con las calificaciones iniciales.
en caso de persistencia del bajo rendimiento, coordinar una evaluación psicopedagógica para determinar estrategias adicionales. 


En vista que mi representado(a) Señor(ita): {$acta['Estudinate']} estudiante de {$acta['Curso']} curso, paralelo " . $acta['Paralelo'] . " de la especialidad de {$acta['Especialidad']} confirmo que ha recibido refuerzo y recuperación pedagogia de las actividades formativas, correspondientes al  {$acta['Trimestre']} Trimestre, en la asignatura de {$acta['Asignatura']} del año lectivo 2024 - 2025 

INFORME A LOS REPRESENTANTES LEGALES:
Por medio del presente documento, se  informa al representante legal que el estudiante: Ha sido informado por medio de la plataforma de la asignatura de {$acta['Asignatura']}

Ha recibido refuerzo pedagógico mediante estrategias metodológicas adecuadas para fortalecer su aprendizaje. Ha sido evaluado nuevamente luego del proceso de refuerzo pedagógico.

Se ha realizado el seguimiento respectivo de su rendimiento académico.


Para constancia, firmamos la presente acta.


FIRMAS:


_________________________________________
Representante: {$acta['Representante']}

_________________________________________
Estudiante: {$acta['Estudinate']}

_________________________________________
Docente: {$acta['Docente']}
Acta N°: {$acta['id']}
Fecha: {$acta['Fecha']}";

// Escribir el texto completo usando la función MultiCellUTF8
$pdf->MultiCellUTF8(0, 5, $texto_acta);

// Salida del PDF para descarga
$pdf->Output('D', 'Refuerzo.pdf');

// Redirigir a la página actas_list.php
header("Location: actas_list.php");
exit();
$conn->close();
?>
