


<?php
require('fpdf/fpdf.php');

// Configurar conexión a la base de datos con UTF-8
$host = "localhost";
$user = "fernando"; 
$password = "170232cc"; 
$database = "libro";

$conn = new mysqli($host, $user, $password, $database);
if ($conn->connect_error) {
    die("Error de conexión: " . $conn->connect_error);
}
// Establecer el conjunto de caracteres a UTF-8
$conn->set_charset("utf8");

if (isset($_GET['id']) && is_numeric($_GET['id'])) {
    $id = intval($_GET['id']);
} else {
    die("ID no válido o no proporcionado.");
}

$sql = "SELECT * FROM compromiso WHERE id = $id";
$result = $conn->query($sql);
if ($result->num_rows == 0) {
    die("No se encontró el acta con el ID proporcionado.");
}

$acta = $result->fetch_assoc();

// Clase PDF mejorada para manejar UTF-8
class PDF extends FPDF
{
    function Header()
    {
        $this->Image('Logo.jpg', 10, 6, 15);
        $this->SetFont('Arial', '', 12);
        $this->Cell(0, 8, utf8_decode('ACTA DE COMPROMISO PARA ESTUDIANTES CON BAJO RENDIMIENTO'), 0, 1, 'C');
        $this->Ln(3);
    }

    function Footer()
    {
        $this->SetY(-15);
        $this->SetFont('Arial', '', 8);
    }
    
    // Función para escribir texto con UTF-8
    function WriteUTF8($h, $txt)
    {
        $this->Write($h, utf8_decode($txt));
    }
    
    // Función para MultiCell con UTF-8
    function MultiCellUTF8($w, $h, $txt, $border=0, $align='J', $fill=false)
    {
        $this->MultiCell($w, $h, utf8_decode($txt), $border, $align, $fill);
    }
}

$pdf = new PDF();
$pdf->AddPage();
$pdf->SetFont('Arial', '', 8);

// Texto del acta con manejo adecuado de UTF-8
$texto_acta = "
OBJETIVOS:
.   Comprometer a través de la presente acta a estudiantes y padres de familia en el mejoramiento del aprendizaje de sus hijos.
.   Dar seguimiento a los casos académicos de los y las estudiantes con bajo desempeño escolar.

FINES:
.   En coherencia con este principio y tomando en cuenta el Reglamento de la LOEI en el Art. 25, que textualmente dice:
.   Los docentes tutores convocarán a los representantes legales de los estudiantes, al finalizar cada periodo académico dentro del año lectivo, a reuniones destinadas a informar a los representantes legales sobre el desempeño y desarrollo de cada estudiante, así como para diseñar estrategias conjuntas que fomenten su adecuado desarrollo. Se dejará constancia escrita de las recomendaciones y sugerencias que se formulen para el mejoramiento. 

SON DEBERES DE LOS ESTUDIANTES: Art. 8. LOEI, literales:

.   Cumplir con las actividades académico-formativas programadas, tareas y responsabilidades obligaciones derivadas del proceso de enseñanza y aprendizaje, de acuerdo con la reglamentación correspondiente a la modalidad educativa; salvo los casos de situación de vulnerabilidad en los cuales se pueda reconocer mecanismos de flexibilización;
.   Participar en la evaluación de manera permanente, a través de procesos internos y externos que validen la calidad de la educación y el inter aprendizaje;
.   Procurar la excelencia educativa y mostrar integridad y honestidad académica en el cumplimiento de las tareas, obligaciones y responsabilidades; (Art.8 LOEI).


SON DEBERES DE LOS PADRES:  Art. 13, LOEI, literales:
.   Garantizar que sus representados asistan regularmente a los centros educativos, durante el periodo de educación obligatoria, de conformidad con la modalidad educativa;
.   Involucrarse activamente y desde la corresponsabilidad en los procesos educativos de sus representados y atender los llamados y requerimientos de las y los docentes y autoridades de los planteles;
.   Apoyar y motivar a sus representados y representadas, especialmente cuando existan dificultades en el proceso de aprendizaje, de manera constructiva y creativa;

En vista que mi representado(a) Señor(ita): {$acta['Estudinate']} estudiante de {$acta['Curso']} curso, paralelo {$acta['Paralelo']} de la especialidad de {$acta['Especialidad']} quien hasta el momentoto presenta bajo rendimiento, correspondiente al {$acta['Trimestre']} Trimestre, en la asignatura de {$acta['Asignatura']} del año lectivo 2024 - 2025 

MOTIVOS DE BAJO DESEMPEÑO:

.   Incumplimiento de tareas.
.   Falta de interés en la Asignatura
.   No presenta deberes y tareas oportunamente.
.   Falta de compromisos asignados
.   No estudiar para las clases de recuperación.
.   No solicita tareas dirigidas.
.   No solicita tutorías del tema no comprendido.
.   No entrega las notificaciones al representante cuando se ha requerido

En consecuencia, por todo lo expuesto, YO {$acta['Representante']} con cédula de identidad No. {$acta['CedularR']} conjuntamente con mi representado(a), nos comprometemos a cumplir los siguientes 

PADRE/MADRE DE FAMILIA:

.   Tener en cuenta las recomendaciones de los docentes o directivos, que me hagan en la relación con el mejoramiento académico de mi hijo(a).
.   Proporcionarle a mi hijo(a) los materiales y útiles necesarios para el desarrollo de las diferentes actividades escolares programadas por los docentes.
.   Estar pendiente de la formación integral de mi hijo(a) para lo cual asistiré periódicamente (cada 8 días) a la Institución para informarme del rendimiento académico, comportamiento y asistencia, como lo recomienda la Ley y su Reglamento.

ESTUDIANTE:

.   Tener en cuenta mis compromisos y con mis acciones demostrar mi cambio de actitud.
.   Estar atento a clases y desarrollar las actividades que me asigne el docente.
.   Informar a los Docentes de circunstancias que afecten mi convivencia escolar.
.   No faltar a clases.
.   Asistir a clases de recuperación.
.   Solicitar tutorías.
.   Realizar tareas dirigidas juntamente con el docente.

DOCENTE:

.   Promover la participación del estudiante.
.   Reconstruir y reforzar los conocimientos adquiridos.
.   Realizar recuperación pedagógica.
.   Notificar al padre de familia o autoridades de cualquier problema estudiantil


Luego de ser leída la presente acta, acepto los compromisos y en caso de incumplimiento de estos, como padre/madre de familia o representante legal, me sujetaré a las resoluciones y disposiciones que tomare la Unidad Educativa 'Guayaquil', de acuerdo a la Ley y Reglamento de la LOEI y al código de Convivencia.

Para constancia, firmamos la presente acta.


FIRMAS:
// Continuación del texto del acta


_________________________________________
Representante: {$acta['Representante']}

_________________________________________
Estudiante: {$acta['Estudinate']}

_________________________________________
Docente: {$acta['Docente']}
Acta N°: {$acta['id']}
Fecha: {$acta['Fecha']}";

// Escribir el texto completo usando la función MultiCellUTF8
$pdf->MultiCellUTF8(0, 5, $texto_acta);

// Salida del PDF para descarga
$pdf->Output('D', 'Acta_Compromiso.pdf');

// Redirigir a la página actas_list.php
header("Location: actas_list.php");
exit();
$conn->close();
?>
