<?php

/**
* getLookupMainTableSettings - tests whether the lookup link exists between the tables
*
*  returns array with ProjectSettings class for main table if the link exists in project settings.
*  returns NULL otherwise
*/
function getLookupMainTableSettings($lookupTable, $mainTableShortName, $mainField, $desiredPage = "")
{
	global $lookupTableLinks;
	if(!isset($lookupTableLinks[$lookupTable]))
		return null;
	if(!isset($lookupTableLinks[$lookupTable][$mainTableShortName.".".$mainField]))
		return null;
	$arr = &$lookupTableLinks[$lookupTable][$mainTableShortName.".".$mainField];
	$effectivePage = $desiredPage;
	if(!isset($arr[$effectivePage]))
	{
		$effectivePage = PAGE_EDIT;
		if(!isset($arr[$effectivePage]))
		{
			if($desiredPage == "" && 0 < count($arr))
			{
				$effectivePage = $arr[0];
			}
			else
				return null;
		}
	}
	return new ProjectSettings($arr[$effectivePage]["table"], $effectivePage);
}

/** 
* $lookupTableLinks array stores all lookup links between tables in the project
*/
function InitLookupLinks()
{
	global $lookupTableLinks;

	$lookupTableLinks = array();

		if( !isset( $lookupTableLinks["configuracion"] ) ) {
			$lookupTableLinks["configuracion"] = array();
		}
		if( !isset( $lookupTableLinks["configuracion"]["usuarios.Institucion"] )) {
			$lookupTableLinks["configuracion"]["usuarios.Institucion"] = array();
		}
		$lookupTableLinks["configuracion"]["usuarios.Institucion"]["edit"] = array("table" => "usuarios", "field" => "Institucion", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["usuarios.curso"] )) {
			$lookupTableLinks["distributivo"]["usuarios.curso"] = array();
		}
		$lookupTableLinks["distributivo"]["usuarios.curso"]["edit"] = array("table" => "usuarios", "field" => "curso", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["usuarios.paralelo"] )) {
			$lookupTableLinks["distributivo"]["usuarios.paralelo"] = array();
		}
		$lookupTableLinks["distributivo"]["usuarios.paralelo"]["edit"] = array("table" => "usuarios", "field" => "paralelo", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["usuarios.especialidad"] )) {
			$lookupTableLinks["distributivo"]["usuarios.especialidad"] = array();
		}
		$lookupTableLinks["distributivo"]["usuarios.especialidad"]["edit"] = array("table" => "usuarios", "field" => "especialidad", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["calificaciones.Docente"] )) {
			$lookupTableLinks["distributivo"]["calificaciones.Docente"] = array();
		}
		$lookupTableLinks["distributivo"]["calificaciones.Docente"]["edit"] = array("table" => "calificaciones", "field" => "Docente", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["calificaciones.Especialidad"] )) {
			$lookupTableLinks["distributivo"]["calificaciones.Especialidad"] = array();
		}
		$lookupTableLinks["distributivo"]["calificaciones.Especialidad"]["edit"] = array("table" => "calificaciones", "field" => "Especialidad", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["calificaciones.Curso"] )) {
			$lookupTableLinks["distributivo"]["calificaciones.Curso"] = array();
		}
		$lookupTableLinks["distributivo"]["calificaciones.Curso"]["edit"] = array("table" => "calificaciones", "field" => "Curso", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["calificaciones.Paralelo"] )) {
			$lookupTableLinks["distributivo"]["calificaciones.Paralelo"] = array();
		}
		$lookupTableLinks["distributivo"]["calificaciones.Paralelo"]["edit"] = array("table" => "calificaciones", "field" => "Paralelo", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["calificaciones.Asignatura"] )) {
			$lookupTableLinks["distributivo"]["calificaciones.Asignatura"] = array();
		}
		$lookupTableLinks["distributivo"]["calificaciones.Asignatura"]["edit"] = array("table" => "calificaciones", "field" => "Asignatura", "page" => "edit");
		if( !isset( $lookupTableLinks["trimestre"] ) ) {
			$lookupTableLinks["trimestre"] = array();
		}
		if( !isset( $lookupTableLinks["trimestre"]["calificaciones.Trimestre"] )) {
			$lookupTableLinks["trimestre"]["calificaciones.Trimestre"] = array();
		}
		$lookupTableLinks["trimestre"]["calificaciones.Trimestre"]["edit"] = array("table" => "calificaciones", "field" => "Trimestre", "page" => "edit");
		if( !isset( $lookupTableLinks["usuarios"] ) ) {
			$lookupTableLinks["usuarios"] = array();
		}
		if( !isset( $lookupTableLinks["usuarios"]["calificaciones.Cestudiante"] )) {
			$lookupTableLinks["usuarios"]["calificaciones.Cestudiante"] = array();
		}
		$lookupTableLinks["usuarios"]["calificaciones.Cestudiante"]["edit"] = array("table" => "calificaciones", "field" => "Cestudiante", "page" => "edit");
		if( !isset( $lookupTableLinks["usuarios"] ) ) {
			$lookupTableLinks["usuarios"] = array();
		}
		if( !isset( $lookupTableLinks["usuarios"]["calificaciones.Estudiante"] )) {
			$lookupTableLinks["usuarios"]["calificaciones.Estudiante"] = array();
		}
		$lookupTableLinks["usuarios"]["calificaciones.Estudiante"]["edit"] = array("table" => "calificaciones", "field" => "Estudiante", "page" => "edit");
		if( !isset( $lookupTableLinks["docente"] ) ) {
			$lookupTableLinks["docente"] = array();
		}
		if( !isset( $lookupTableLinks["docente"]["distributivo.Docente"] )) {
			$lookupTableLinks["docente"]["distributivo.Docente"] = array();
		}
		$lookupTableLinks["docente"]["distributivo.Docente"]["edit"] = array("table" => "distributivo", "field" => "Docente", "page" => "edit");
		if( !isset( $lookupTableLinks["docente"] ) ) {
			$lookupTableLinks["docente"] = array();
		}
		if( !isset( $lookupTableLinks["docente"]["distributivo.Cedula"] )) {
			$lookupTableLinks["docente"]["distributivo.Cedula"] = array();
		}
		$lookupTableLinks["docente"]["distributivo.Cedula"]["edit"] = array("table" => "distributivo", "field" => "Cedula", "page" => "edit");
		if( !isset( $lookupTableLinks["configuracion"] ) ) {
			$lookupTableLinks["configuracion"] = array();
		}
		if( !isset( $lookupTableLinks["configuracion"]["distributivo.Institucion"] )) {
			$lookupTableLinks["configuracion"]["distributivo.Institucion"] = array();
		}
		$lookupTableLinks["configuracion"]["distributivo.Institucion"]["edit"] = array("table" => "distributivo", "field" => "Institucion", "page" => "edit");
		if( !isset( $lookupTableLinks["asignatura"] ) ) {
			$lookupTableLinks["asignatura"] = array();
		}
		if( !isset( $lookupTableLinks["asignatura"]["distributivo.asignatura"] )) {
			$lookupTableLinks["asignatura"]["distributivo.asignatura"] = array();
		}
		$lookupTableLinks["asignatura"]["distributivo.asignatura"]["edit"] = array("table" => "distributivo", "field" => "asignatura", "page" => "edit");
		if( !isset( $lookupTableLinks["curso"] ) ) {
			$lookupTableLinks["curso"] = array();
		}
		if( !isset( $lookupTableLinks["curso"]["distributivo.Curso"] )) {
			$lookupTableLinks["curso"]["distributivo.Curso"] = array();
		}
		$lookupTableLinks["curso"]["distributivo.Curso"]["edit"] = array("table" => "distributivo", "field" => "Curso", "page" => "edit");
		if( !isset( $lookupTableLinks["paralelo"] ) ) {
			$lookupTableLinks["paralelo"] = array();
		}
		if( !isset( $lookupTableLinks["paralelo"]["distributivo.Paralelo"] )) {
			$lookupTableLinks["paralelo"]["distributivo.Paralelo"] = array();
		}
		$lookupTableLinks["paralelo"]["distributivo.Paralelo"]["edit"] = array("table" => "distributivo", "field" => "Paralelo", "page" => "edit");
		if( !isset( $lookupTableLinks["especialidad"] ) ) {
			$lookupTableLinks["especialidad"] = array();
		}
		if( !isset( $lookupTableLinks["especialidad"]["distributivo.Especialidad"] )) {
			$lookupTableLinks["especialidad"]["distributivo.Especialidad"] = array();
		}
		$lookupTableLinks["especialidad"]["distributivo.Especialidad"]["edit"] = array("table" => "distributivo", "field" => "Especialidad", "page" => "edit");
		if( !isset( $lookupTableLinks["configuracion"] ) ) {
			$lookupTableLinks["configuracion"] = array();
		}
		if( !isset( $lookupTableLinks["configuracion"]["distributivo.Año"] )) {
			$lookupTableLinks["configuracion"]["distributivo.Año"] = array();
		}
		$lookupTableLinks["configuracion"]["distributivo.Año"]["edit"] = array("table" => "distributivo", "field" => "Año", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["representante.Docente"] )) {
			$lookupTableLinks["distributivo"]["representante.Docente"] = array();
		}
		$lookupTableLinks["distributivo"]["representante.Docente"]["edit"] = array("table" => "representante", "field" => "Docente", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["representante.Especialidad"] )) {
			$lookupTableLinks["distributivo"]["representante.Especialidad"] = array();
		}
		$lookupTableLinks["distributivo"]["representante.Especialidad"]["edit"] = array("table" => "representante", "field" => "Especialidad", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["representante.Curso"] )) {
			$lookupTableLinks["distributivo"]["representante.Curso"] = array();
		}
		$lookupTableLinks["distributivo"]["representante.Curso"]["edit"] = array("table" => "representante", "field" => "Curso", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["representante.Paralelo"] )) {
			$lookupTableLinks["distributivo"]["representante.Paralelo"] = array();
		}
		$lookupTableLinks["distributivo"]["representante.Paralelo"]["edit"] = array("table" => "representante", "field" => "Paralelo", "page" => "edit");
		if( !isset( $lookupTableLinks["usuarios"] ) ) {
			$lookupTableLinks["usuarios"] = array();
		}
		if( !isset( $lookupTableLinks["usuarios"]["representante.Cestudiante"] )) {
			$lookupTableLinks["usuarios"]["representante.Cestudiante"] = array();
		}
		$lookupTableLinks["usuarios"]["representante.Cestudiante"]["edit"] = array("table" => "representante", "field" => "Cestudiante", "page" => "edit");
		if( !isset( $lookupTableLinks["usuarios"] ) ) {
			$lookupTableLinks["usuarios"] = array();
		}
		if( !isset( $lookupTableLinks["usuarios"]["representante.Estudiante"] )) {
			$lookupTableLinks["usuarios"]["representante.Estudiante"] = array();
		}
		$lookupTableLinks["usuarios"]["representante.Estudiante"]["edit"] = array("table" => "representante", "field" => "Estudiante", "page" => "edit");
		if( !isset( $lookupTableLinks["trimestre"] ) ) {
			$lookupTableLinks["trimestre"] = array();
		}
		if( !isset( $lookupTableLinks["trimestre"]["representante.Trimestre"] )) {
			$lookupTableLinks["trimestre"]["representante.Trimestre"] = array();
		}
		$lookupTableLinks["trimestre"]["representante.Trimestre"]["edit"] = array("table" => "representante", "field" => "Trimestre", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["codigoc.Docente"] )) {
			$lookupTableLinks["distributivo"]["codigoc.Docente"] = array();
		}
		$lookupTableLinks["distributivo"]["codigoc.Docente"]["edit"] = array("table" => "codigoc", "field" => "Docente", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["codigoc.Especialidad"] )) {
			$lookupTableLinks["distributivo"]["codigoc.Especialidad"] = array();
		}
		$lookupTableLinks["distributivo"]["codigoc.Especialidad"]["edit"] = array("table" => "codigoc", "field" => "Especialidad", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["codigoc.Curso"] )) {
			$lookupTableLinks["distributivo"]["codigoc.Curso"] = array();
		}
		$lookupTableLinks["distributivo"]["codigoc.Curso"]["edit"] = array("table" => "codigoc", "field" => "Curso", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["codigoc.Paralelo"] )) {
			$lookupTableLinks["distributivo"]["codigoc.Paralelo"] = array();
		}
		$lookupTableLinks["distributivo"]["codigoc.Paralelo"]["edit"] = array("table" => "codigoc", "field" => "Paralelo", "page" => "edit");
		if( !isset( $lookupTableLinks["trimestre"] ) ) {
			$lookupTableLinks["trimestre"] = array();
		}
		if( !isset( $lookupTableLinks["trimestre"]["codigoc.Trimestre"] )) {
			$lookupTableLinks["trimestre"]["codigoc.Trimestre"] = array();
		}
		$lookupTableLinks["trimestre"]["codigoc.Trimestre"]["edit"] = array("table" => "codigoc", "field" => "Trimestre", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["codigoc.Asignatura"] )) {
			$lookupTableLinks["distributivo"]["codigoc.Asignatura"] = array();
		}
		$lookupTableLinks["distributivo"]["codigoc.Asignatura"]["edit"] = array("table" => "codigoc", "field" => "Asignatura", "page" => "edit");
		if( !isset( $lookupTableLinks["tipo"] ) ) {
			$lookupTableLinks["tipo"] = array();
		}
		if( !isset( $lookupTableLinks["tipo"]["codigoc.Tipo"] )) {
			$lookupTableLinks["tipo"]["codigoc.Tipo"] = array();
		}
		$lookupTableLinks["tipo"]["codigoc.Tipo"]["edit"] = array("table" => "codigoc", "field" => "Tipo", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["reporte.Docente"] )) {
			$lookupTableLinks["distributivo"]["reporte.Docente"] = array();
		}
		$lookupTableLinks["distributivo"]["reporte.Docente"]["edit"] = array("table" => "reporte", "field" => "Docente", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["reporte.Especialidad"] )) {
			$lookupTableLinks["distributivo"]["reporte.Especialidad"] = array();
		}
		$lookupTableLinks["distributivo"]["reporte.Especialidad"]["edit"] = array("table" => "reporte", "field" => "Especialidad", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["reporte.Curso"] )) {
			$lookupTableLinks["distributivo"]["reporte.Curso"] = array();
		}
		$lookupTableLinks["distributivo"]["reporte.Curso"]["edit"] = array("table" => "reporte", "field" => "Curso", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["reporte.Paralelo"] )) {
			$lookupTableLinks["distributivo"]["reporte.Paralelo"] = array();
		}
		$lookupTableLinks["distributivo"]["reporte.Paralelo"]["edit"] = array("table" => "reporte", "field" => "Paralelo", "page" => "edit");
		if( !isset( $lookupTableLinks["trimestre"] ) ) {
			$lookupTableLinks["trimestre"] = array();
		}
		if( !isset( $lookupTableLinks["trimestre"]["reporte.Trimestre"] )) {
			$lookupTableLinks["trimestre"]["reporte.Trimestre"] = array();
		}
		$lookupTableLinks["trimestre"]["reporte.Trimestre"]["edit"] = array("table" => "reporte", "field" => "Trimestre", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["reporte_trimestral.Docente"] )) {
			$lookupTableLinks["distributivo"]["reporte_trimestral.Docente"] = array();
		}
		$lookupTableLinks["distributivo"]["reporte_trimestral.Docente"]["edit"] = array("table" => "Reporte Trimestral", "field" => "Docente", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["reporte_trimestral.Especialidad"] )) {
			$lookupTableLinks["distributivo"]["reporte_trimestral.Especialidad"] = array();
		}
		$lookupTableLinks["distributivo"]["reporte_trimestral.Especialidad"]["edit"] = array("table" => "Reporte Trimestral", "field" => "Especialidad", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["reporte_trimestral.Curso"] )) {
			$lookupTableLinks["distributivo"]["reporte_trimestral.Curso"] = array();
		}
		$lookupTableLinks["distributivo"]["reporte_trimestral.Curso"]["edit"] = array("table" => "Reporte Trimestral", "field" => "Curso", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["reporte_trimestral.Paralelo"] )) {
			$lookupTableLinks["distributivo"]["reporte_trimestral.Paralelo"] = array();
		}
		$lookupTableLinks["distributivo"]["reporte_trimestral.Paralelo"]["edit"] = array("table" => "Reporte Trimestral", "field" => "Paralelo", "page" => "edit");
		if( !isset( $lookupTableLinks["trimestre"] ) ) {
			$lookupTableLinks["trimestre"] = array();
		}
		if( !isset( $lookupTableLinks["trimestre"]["reporte_trimestral.Trimestre"] )) {
			$lookupTableLinks["trimestre"]["reporte_trimestral.Trimestre"] = array();
		}
		$lookupTableLinks["trimestre"]["reporte_trimestral.Trimestre"]["edit"] = array("table" => "Reporte Trimestral", "field" => "Trimestre", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["reporte1.Docente"] )) {
			$lookupTableLinks["distributivo"]["reporte1.Docente"] = array();
		}
		$lookupTableLinks["distributivo"]["reporte1.Docente"]["edit"] = array("table" => "reporte1", "field" => "Docente", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["reporte1.Especialidad"] )) {
			$lookupTableLinks["distributivo"]["reporte1.Especialidad"] = array();
		}
		$lookupTableLinks["distributivo"]["reporte1.Especialidad"]["edit"] = array("table" => "reporte1", "field" => "Especialidad", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["reporte1.Curso"] )) {
			$lookupTableLinks["distributivo"]["reporte1.Curso"] = array();
		}
		$lookupTableLinks["distributivo"]["reporte1.Curso"]["edit"] = array("table" => "reporte1", "field" => "Curso", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["reporte1.Paralelo"] )) {
			$lookupTableLinks["distributivo"]["reporte1.Paralelo"] = array();
		}
		$lookupTableLinks["distributivo"]["reporte1.Paralelo"]["edit"] = array("table" => "reporte1", "field" => "Paralelo", "page" => "edit");
		if( !isset( $lookupTableLinks["trimestre"] ) ) {
			$lookupTableLinks["trimestre"] = array();
		}
		if( !isset( $lookupTableLinks["trimestre"]["reporte1.Trimestre"] )) {
			$lookupTableLinks["trimestre"]["reporte1.Trimestre"] = array();
		}
		$lookupTableLinks["trimestre"]["reporte1.Trimestre"]["edit"] = array("table" => "reporte1", "field" => "Trimestre", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["alerta_de_bajo_rendimiento.Docente"] )) {
			$lookupTableLinks["distributivo"]["alerta_de_bajo_rendimiento.Docente"] = array();
		}
		$lookupTableLinks["distributivo"]["alerta_de_bajo_rendimiento.Docente"]["edit"] = array("table" => "Alerta de bajo rendimiento", "field" => "Docente", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["alerta_de_bajo_rendimiento.Especialidad"] )) {
			$lookupTableLinks["distributivo"]["alerta_de_bajo_rendimiento.Especialidad"] = array();
		}
		$lookupTableLinks["distributivo"]["alerta_de_bajo_rendimiento.Especialidad"]["edit"] = array("table" => "Alerta de bajo rendimiento", "field" => "Especialidad", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["alerta_de_bajo_rendimiento.Curso"] )) {
			$lookupTableLinks["distributivo"]["alerta_de_bajo_rendimiento.Curso"] = array();
		}
		$lookupTableLinks["distributivo"]["alerta_de_bajo_rendimiento.Curso"]["edit"] = array("table" => "Alerta de bajo rendimiento", "field" => "Curso", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["alerta_de_bajo_rendimiento.Paralelo"] )) {
			$lookupTableLinks["distributivo"]["alerta_de_bajo_rendimiento.Paralelo"] = array();
		}
		$lookupTableLinks["distributivo"]["alerta_de_bajo_rendimiento.Paralelo"]["edit"] = array("table" => "Alerta de bajo rendimiento", "field" => "Paralelo", "page" => "edit");
		if( !isset( $lookupTableLinks["trimestre"] ) ) {
			$lookupTableLinks["trimestre"] = array();
		}
		if( !isset( $lookupTableLinks["trimestre"]["alerta_de_bajo_rendimiento.Trimestre"] )) {
			$lookupTableLinks["trimestre"]["alerta_de_bajo_rendimiento.Trimestre"] = array();
		}
		$lookupTableLinks["trimestre"]["alerta_de_bajo_rendimiento.Trimestre"]["edit"] = array("table" => "Alerta de bajo rendimiento", "field" => "Trimestre", "page" => "edit");
		if( !isset( $lookupTableLinks["ano"] ) ) {
			$lookupTableLinks["ano"] = array();
		}
		if( !isset( $lookupTableLinks["ano"]["configuracion.año"] )) {
			$lookupTableLinks["ano"]["configuracion.año"] = array();
		}
		$lookupTableLinks["ano"]["configuracion.año"]["edit"] = array("table" => "configuracion", "field" => "año", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["codigoa.Especialidad"] )) {
			$lookupTableLinks["distributivo"]["codigoa.Especialidad"] = array();
		}
		$lookupTableLinks["distributivo"]["codigoa.Especialidad"]["edit"] = array("table" => "codigoa", "field" => "Especialidad", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["codigoa.Curso"] )) {
			$lookupTableLinks["distributivo"]["codigoa.Curso"] = array();
		}
		$lookupTableLinks["distributivo"]["codigoa.Curso"]["edit"] = array("table" => "codigoa", "field" => "Curso", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["codigoa.Paralelo"] )) {
			$lookupTableLinks["distributivo"]["codigoa.Paralelo"] = array();
		}
		$lookupTableLinks["distributivo"]["codigoa.Paralelo"]["edit"] = array("table" => "codigoa", "field" => "Paralelo", "page" => "edit");
		if( !isset( $lookupTableLinks["trimestre"] ) ) {
			$lookupTableLinks["trimestre"] = array();
		}
		if( !isset( $lookupTableLinks["trimestre"]["codigoa.Trimestre"] )) {
			$lookupTableLinks["trimestre"]["codigoa.Trimestre"] = array();
		}
		$lookupTableLinks["trimestre"]["codigoa.Trimestre"]["edit"] = array("table" => "codigoa", "field" => "Trimestre", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["codigoa.Asignatura"] )) {
			$lookupTableLinks["distributivo"]["codigoa.Asignatura"] = array();
		}
		$lookupTableLinks["distributivo"]["codigoa.Asignatura"]["edit"] = array("table" => "codigoa", "field" => "Asignatura", "page" => "edit");
		if( !isset( $lookupTableLinks["docente"] ) ) {
			$lookupTableLinks["docente"] = array();
		}
		if( !isset( $lookupTableLinks["docente"]["distributivo_asistencia.Docente"] )) {
			$lookupTableLinks["docente"]["distributivo_asistencia.Docente"] = array();
		}
		$lookupTableLinks["docente"]["distributivo_asistencia.Docente"]["edit"] = array("table" => "distributivo asistencia", "field" => "Docente", "page" => "edit");
		if( !isset( $lookupTableLinks["docente"] ) ) {
			$lookupTableLinks["docente"] = array();
		}
		if( !isset( $lookupTableLinks["docente"]["distributivo_asistencia.Cedula"] )) {
			$lookupTableLinks["docente"]["distributivo_asistencia.Cedula"] = array();
		}
		$lookupTableLinks["docente"]["distributivo_asistencia.Cedula"]["edit"] = array("table" => "distributivo asistencia", "field" => "Cedula", "page" => "edit");
		if( !isset( $lookupTableLinks["configuracion"] ) ) {
			$lookupTableLinks["configuracion"] = array();
		}
		if( !isset( $lookupTableLinks["configuracion"]["distributivo_asistencia.Institucion"] )) {
			$lookupTableLinks["configuracion"]["distributivo_asistencia.Institucion"] = array();
		}
		$lookupTableLinks["configuracion"]["distributivo_asistencia.Institucion"]["edit"] = array("table" => "distributivo asistencia", "field" => "Institucion", "page" => "edit");
		if( !isset( $lookupTableLinks["asignatura"] ) ) {
			$lookupTableLinks["asignatura"] = array();
		}
		if( !isset( $lookupTableLinks["asignatura"]["distributivo_asistencia.asignatura"] )) {
			$lookupTableLinks["asignatura"]["distributivo_asistencia.asignatura"] = array();
		}
		$lookupTableLinks["asignatura"]["distributivo_asistencia.asignatura"]["edit"] = array("table" => "distributivo asistencia", "field" => "asignatura", "page" => "edit");
		if( !isset( $lookupTableLinks["curso"] ) ) {
			$lookupTableLinks["curso"] = array();
		}
		if( !isset( $lookupTableLinks["curso"]["distributivo_asistencia.Curso"] )) {
			$lookupTableLinks["curso"]["distributivo_asistencia.Curso"] = array();
		}
		$lookupTableLinks["curso"]["distributivo_asistencia.Curso"]["edit"] = array("table" => "distributivo asistencia", "field" => "Curso", "page" => "edit");
		if( !isset( $lookupTableLinks["paralelo"] ) ) {
			$lookupTableLinks["paralelo"] = array();
		}
		if( !isset( $lookupTableLinks["paralelo"]["distributivo_asistencia.Paralelo"] )) {
			$lookupTableLinks["paralelo"]["distributivo_asistencia.Paralelo"] = array();
		}
		$lookupTableLinks["paralelo"]["distributivo_asistencia.Paralelo"]["edit"] = array("table" => "distributivo asistencia", "field" => "Paralelo", "page" => "edit");
		if( !isset( $lookupTableLinks["especialidad"] ) ) {
			$lookupTableLinks["especialidad"] = array();
		}
		if( !isset( $lookupTableLinks["especialidad"]["distributivo_asistencia.Especialidad"] )) {
			$lookupTableLinks["especialidad"]["distributivo_asistencia.Especialidad"] = array();
		}
		$lookupTableLinks["especialidad"]["distributivo_asistencia.Especialidad"]["edit"] = array("table" => "distributivo asistencia", "field" => "Especialidad", "page" => "edit");
		if( !isset( $lookupTableLinks["configuracion"] ) ) {
			$lookupTableLinks["configuracion"] = array();
		}
		if( !isset( $lookupTableLinks["configuracion"]["distributivo_asistencia.Año"] )) {
			$lookupTableLinks["configuracion"]["distributivo_asistencia.Año"] = array();
		}
		$lookupTableLinks["configuracion"]["distributivo_asistencia.Año"]["edit"] = array("table" => "distributivo asistencia", "field" => "Año", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["asistencia_por_estudiante.Docente"] )) {
			$lookupTableLinks["distributivo"]["asistencia_por_estudiante.Docente"] = array();
		}
		$lookupTableLinks["distributivo"]["asistencia_por_estudiante.Docente"]["edit"] = array("table" => "Asistencia por estudiante", "field" => "Docente", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["asistencia_por_estudiante.Especialidad"] )) {
			$lookupTableLinks["distributivo"]["asistencia_por_estudiante.Especialidad"] = array();
		}
		$lookupTableLinks["distributivo"]["asistencia_por_estudiante.Especialidad"]["edit"] = array("table" => "Asistencia por estudiante", "field" => "Especialidad", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["asistencia_por_estudiante.Curso"] )) {
			$lookupTableLinks["distributivo"]["asistencia_por_estudiante.Curso"] = array();
		}
		$lookupTableLinks["distributivo"]["asistencia_por_estudiante.Curso"]["edit"] = array("table" => "Asistencia por estudiante", "field" => "Curso", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["asistencia_por_estudiante.Paralelo"] )) {
			$lookupTableLinks["distributivo"]["asistencia_por_estudiante.Paralelo"] = array();
		}
		$lookupTableLinks["distributivo"]["asistencia_por_estudiante.Paralelo"]["edit"] = array("table" => "Asistencia por estudiante", "field" => "Paralelo", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["asistencia_por_estudiante.Asignatura"] )) {
			$lookupTableLinks["distributivo"]["asistencia_por_estudiante.Asignatura"] = array();
		}
		$lookupTableLinks["distributivo"]["asistencia_por_estudiante.Asignatura"]["edit"] = array("table" => "Asistencia por estudiante", "field" => "Asignatura", "page" => "edit");
		if( !isset( $lookupTableLinks["trimestre"] ) ) {
			$lookupTableLinks["trimestre"] = array();
		}
		if( !isset( $lookupTableLinks["trimestre"]["asistencia_por_estudiante.Trimestre"] )) {
			$lookupTableLinks["trimestre"]["asistencia_por_estudiante.Trimestre"] = array();
		}
		$lookupTableLinks["trimestre"]["asistencia_por_estudiante.Trimestre"]["edit"] = array("table" => "Asistencia por estudiante", "field" => "Trimestre", "page" => "edit");
		if( !isset( $lookupTableLinks["usuarios"] ) ) {
			$lookupTableLinks["usuarios"] = array();
		}
		if( !isset( $lookupTableLinks["usuarios"]["asistencia_por_estudiante.Estudiante"] )) {
			$lookupTableLinks["usuarios"]["asistencia_por_estudiante.Estudiante"] = array();
		}
		$lookupTableLinks["usuarios"]["asistencia_por_estudiante.Estudiante"]["edit"] = array("table" => "Asistencia por estudiante", "field" => "Estudiante", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["informe_t1_m1.Docente"] )) {
			$lookupTableLinks["distributivo"]["informe_t1_m1.Docente"] = array();
		}
		$lookupTableLinks["distributivo"]["informe_t1_m1.Docente"]["edit"] = array("table" => "INFORME T1.M1", "field" => "Docente", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["informe_t1_m1.Especialidad"] )) {
			$lookupTableLinks["distributivo"]["informe_t1_m1.Especialidad"] = array();
		}
		$lookupTableLinks["distributivo"]["informe_t1_m1.Especialidad"]["edit"] = array("table" => "INFORME T1.M1", "field" => "Especialidad", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["informe_t1_m1.Curso"] )) {
			$lookupTableLinks["distributivo"]["informe_t1_m1.Curso"] = array();
		}
		$lookupTableLinks["distributivo"]["informe_t1_m1.Curso"]["edit"] = array("table" => "INFORME T1.M1", "field" => "Curso", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["informe_t1_m1.Paralelo"] )) {
			$lookupTableLinks["distributivo"]["informe_t1_m1.Paralelo"] = array();
		}
		$lookupTableLinks["distributivo"]["informe_t1_m1.Paralelo"]["edit"] = array("table" => "INFORME T1.M1", "field" => "Paralelo", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["informe_t1_m1.Asignatura"] )) {
			$lookupTableLinks["distributivo"]["informe_t1_m1.Asignatura"] = array();
		}
		$lookupTableLinks["distributivo"]["informe_t1_m1.Asignatura"]["edit"] = array("table" => "INFORME T1.M1", "field" => "Asignatura", "page" => "edit");
		if( !isset( $lookupTableLinks["trimestre"] ) ) {
			$lookupTableLinks["trimestre"] = array();
		}
		if( !isset( $lookupTableLinks["trimestre"]["informe_t1_m1.Trimestre"] )) {
			$lookupTableLinks["trimestre"]["informe_t1_m1.Trimestre"] = array();
		}
		$lookupTableLinks["trimestre"]["informe_t1_m1.Trimestre"]["edit"] = array("table" => "INFORME T1.M1", "field" => "Trimestre", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["refuerzo_y_recuperaci_n.Docente"] )) {
			$lookupTableLinks["distributivo"]["refuerzo_y_recuperaci_n.Docente"] = array();
		}
		$lookupTableLinks["distributivo"]["refuerzo_y_recuperaci_n.Docente"]["edit"] = array("table" => "Refuerzo y Recuperación", "field" => "Docente", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["refuerzo_y_recuperaci_n.Especialidad"] )) {
			$lookupTableLinks["distributivo"]["refuerzo_y_recuperaci_n.Especialidad"] = array();
		}
		$lookupTableLinks["distributivo"]["refuerzo_y_recuperaci_n.Especialidad"]["edit"] = array("table" => "Refuerzo y Recuperación", "field" => "Especialidad", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["refuerzo_y_recuperaci_n.Curso"] )) {
			$lookupTableLinks["distributivo"]["refuerzo_y_recuperaci_n.Curso"] = array();
		}
		$lookupTableLinks["distributivo"]["refuerzo_y_recuperaci_n.Curso"]["edit"] = array("table" => "Refuerzo y Recuperación", "field" => "Curso", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["refuerzo_y_recuperaci_n.Paralelo"] )) {
			$lookupTableLinks["distributivo"]["refuerzo_y_recuperaci_n.Paralelo"] = array();
		}
		$lookupTableLinks["distributivo"]["refuerzo_y_recuperaci_n.Paralelo"]["edit"] = array("table" => "Refuerzo y Recuperación", "field" => "Paralelo", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["refuerzo_y_recuperaci_n.Asignatura"] )) {
			$lookupTableLinks["distributivo"]["refuerzo_y_recuperaci_n.Asignatura"] = array();
		}
		$lookupTableLinks["distributivo"]["refuerzo_y_recuperaci_n.Asignatura"]["edit"] = array("table" => "Refuerzo y Recuperación", "field" => "Asignatura", "page" => "edit");
		if( !isset( $lookupTableLinks["trimestre"] ) ) {
			$lookupTableLinks["trimestre"] = array();
		}
		if( !isset( $lookupTableLinks["trimestre"]["refuerzo_y_recuperaci_n.Trimestre"] )) {
			$lookupTableLinks["trimestre"]["refuerzo_y_recuperaci_n.Trimestre"] = array();
		}
		$lookupTableLinks["trimestre"]["refuerzo_y_recuperaci_n.Trimestre"]["edit"] = array("table" => "Refuerzo y Recuperación", "field" => "Trimestre", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["t1_f_m2.Docente"] )) {
			$lookupTableLinks["distributivo"]["t1_f_m2.Docente"] = array();
		}
		$lookupTableLinks["distributivo"]["t1_f_m2.Docente"]["edit"] = array("table" => "T1.F.M2", "field" => "Docente", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["t1_f_m2.Especialidad"] )) {
			$lookupTableLinks["distributivo"]["t1_f_m2.Especialidad"] = array();
		}
		$lookupTableLinks["distributivo"]["t1_f_m2.Especialidad"]["edit"] = array("table" => "T1.F.M2", "field" => "Especialidad", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["t1_f_m2.Curso"] )) {
			$lookupTableLinks["distributivo"]["t1_f_m2.Curso"] = array();
		}
		$lookupTableLinks["distributivo"]["t1_f_m2.Curso"]["edit"] = array("table" => "T1.F.M2", "field" => "Curso", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["t1_f_m2.Paralelo"] )) {
			$lookupTableLinks["distributivo"]["t1_f_m2.Paralelo"] = array();
		}
		$lookupTableLinks["distributivo"]["t1_f_m2.Paralelo"]["edit"] = array("table" => "T1.F.M2", "field" => "Paralelo", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["t1_f_m2.Asignatura"] )) {
			$lookupTableLinks["distributivo"]["t1_f_m2.Asignatura"] = array();
		}
		$lookupTableLinks["distributivo"]["t1_f_m2.Asignatura"]["edit"] = array("table" => "T1.F.M2", "field" => "Asignatura", "page" => "edit");
		if( !isset( $lookupTableLinks["trimestre"] ) ) {
			$lookupTableLinks["trimestre"] = array();
		}
		if( !isset( $lookupTableLinks["trimestre"]["t1_f_m2.Trimestre"] )) {
			$lookupTableLinks["trimestre"]["t1_f_m2.Trimestre"] = array();
		}
		$lookupTableLinks["trimestre"]["t1_f_m2.Trimestre"]["edit"] = array("table" => "T1.F.M2", "field" => "Trimestre", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["t1_f_m3.Docente"] )) {
			$lookupTableLinks["distributivo"]["t1_f_m3.Docente"] = array();
		}
		$lookupTableLinks["distributivo"]["t1_f_m3.Docente"]["edit"] = array("table" => "T1.F.M3", "field" => "Docente", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["t1_f_m3.Especialidad"] )) {
			$lookupTableLinks["distributivo"]["t1_f_m3.Especialidad"] = array();
		}
		$lookupTableLinks["distributivo"]["t1_f_m3.Especialidad"]["edit"] = array("table" => "T1.F.M3", "field" => "Especialidad", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["t1_f_m3.Curso"] )) {
			$lookupTableLinks["distributivo"]["t1_f_m3.Curso"] = array();
		}
		$lookupTableLinks["distributivo"]["t1_f_m3.Curso"]["edit"] = array("table" => "T1.F.M3", "field" => "Curso", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["t1_f_m3.Paralelo"] )) {
			$lookupTableLinks["distributivo"]["t1_f_m3.Paralelo"] = array();
		}
		$lookupTableLinks["distributivo"]["t1_f_m3.Paralelo"]["edit"] = array("table" => "T1.F.M3", "field" => "Paralelo", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["t1_f_m3.Asignatura"] )) {
			$lookupTableLinks["distributivo"]["t1_f_m3.Asignatura"] = array();
		}
		$lookupTableLinks["distributivo"]["t1_f_m3.Asignatura"]["edit"] = array("table" => "T1.F.M3", "field" => "Asignatura", "page" => "edit");
		if( !isset( $lookupTableLinks["trimestre"] ) ) {
			$lookupTableLinks["trimestre"] = array();
		}
		if( !isset( $lookupTableLinks["trimestre"]["t1_f_m3.Trimestre"] )) {
			$lookupTableLinks["trimestre"]["t1_f_m3.Trimestre"] = array();
		}
		$lookupTableLinks["trimestre"]["t1_f_m3.Trimestre"]["edit"] = array("table" => "T1.F.M3", "field" => "Trimestre", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["t2_f_m1.Docente"] )) {
			$lookupTableLinks["distributivo"]["t2_f_m1.Docente"] = array();
		}
		$lookupTableLinks["distributivo"]["t2_f_m1.Docente"]["edit"] = array("table" => "T2.F.M1", "field" => "Docente", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["t2_f_m1.Especialidad"] )) {
			$lookupTableLinks["distributivo"]["t2_f_m1.Especialidad"] = array();
		}
		$lookupTableLinks["distributivo"]["t2_f_m1.Especialidad"]["edit"] = array("table" => "T2.F.M1", "field" => "Especialidad", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["t2_f_m1.Curso"] )) {
			$lookupTableLinks["distributivo"]["t2_f_m1.Curso"] = array();
		}
		$lookupTableLinks["distributivo"]["t2_f_m1.Curso"]["edit"] = array("table" => "T2.F.M1", "field" => "Curso", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["t2_f_m1.Paralelo"] )) {
			$lookupTableLinks["distributivo"]["t2_f_m1.Paralelo"] = array();
		}
		$lookupTableLinks["distributivo"]["t2_f_m1.Paralelo"]["edit"] = array("table" => "T2.F.M1", "field" => "Paralelo", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["t2_f_m1.Asignatura"] )) {
			$lookupTableLinks["distributivo"]["t2_f_m1.Asignatura"] = array();
		}
		$lookupTableLinks["distributivo"]["t2_f_m1.Asignatura"]["edit"] = array("table" => "T2.F.M1", "field" => "Asignatura", "page" => "edit");
		if( !isset( $lookupTableLinks["trimestre"] ) ) {
			$lookupTableLinks["trimestre"] = array();
		}
		if( !isset( $lookupTableLinks["trimestre"]["t2_f_m1.Trimestre"] )) {
			$lookupTableLinks["trimestre"]["t2_f_m1.Trimestre"] = array();
		}
		$lookupTableLinks["trimestre"]["t2_f_m1.Trimestre"]["edit"] = array("table" => "T2.F.M1", "field" => "Trimestre", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["t2_f_m2.Docente"] )) {
			$lookupTableLinks["distributivo"]["t2_f_m2.Docente"] = array();
		}
		$lookupTableLinks["distributivo"]["t2_f_m2.Docente"]["edit"] = array("table" => "T2.F.M2", "field" => "Docente", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["t2_f_m2.Especialidad"] )) {
			$lookupTableLinks["distributivo"]["t2_f_m2.Especialidad"] = array();
		}
		$lookupTableLinks["distributivo"]["t2_f_m2.Especialidad"]["edit"] = array("table" => "T2.F.M2", "field" => "Especialidad", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["t2_f_m2.Curso"] )) {
			$lookupTableLinks["distributivo"]["t2_f_m2.Curso"] = array();
		}
		$lookupTableLinks["distributivo"]["t2_f_m2.Curso"]["edit"] = array("table" => "T2.F.M2", "field" => "Curso", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["t2_f_m2.Paralelo"] )) {
			$lookupTableLinks["distributivo"]["t2_f_m2.Paralelo"] = array();
		}
		$lookupTableLinks["distributivo"]["t2_f_m2.Paralelo"]["edit"] = array("table" => "T2.F.M2", "field" => "Paralelo", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["t2_f_m2.Asignatura"] )) {
			$lookupTableLinks["distributivo"]["t2_f_m2.Asignatura"] = array();
		}
		$lookupTableLinks["distributivo"]["t2_f_m2.Asignatura"]["edit"] = array("table" => "T2.F.M2", "field" => "Asignatura", "page" => "edit");
		if( !isset( $lookupTableLinks["trimestre"] ) ) {
			$lookupTableLinks["trimestre"] = array();
		}
		if( !isset( $lookupTableLinks["trimestre"]["t2_f_m2.Trimestre"] )) {
			$lookupTableLinks["trimestre"]["t2_f_m2.Trimestre"] = array();
		}
		$lookupTableLinks["trimestre"]["t2_f_m2.Trimestre"]["edit"] = array("table" => "T2.F.M2", "field" => "Trimestre", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["t2_f_m3.Docente"] )) {
			$lookupTableLinks["distributivo"]["t2_f_m3.Docente"] = array();
		}
		$lookupTableLinks["distributivo"]["t2_f_m3.Docente"]["edit"] = array("table" => "T2.F.M3", "field" => "Docente", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["t2_f_m3.Especialidad"] )) {
			$lookupTableLinks["distributivo"]["t2_f_m3.Especialidad"] = array();
		}
		$lookupTableLinks["distributivo"]["t2_f_m3.Especialidad"]["edit"] = array("table" => "T2.F.M3", "field" => "Especialidad", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["t2_f_m3.Curso"] )) {
			$lookupTableLinks["distributivo"]["t2_f_m3.Curso"] = array();
		}
		$lookupTableLinks["distributivo"]["t2_f_m3.Curso"]["edit"] = array("table" => "T2.F.M3", "field" => "Curso", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["t2_f_m3.Paralelo"] )) {
			$lookupTableLinks["distributivo"]["t2_f_m3.Paralelo"] = array();
		}
		$lookupTableLinks["distributivo"]["t2_f_m3.Paralelo"]["edit"] = array("table" => "T2.F.M3", "field" => "Paralelo", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["t2_f_m3.Asignatura"] )) {
			$lookupTableLinks["distributivo"]["t2_f_m3.Asignatura"] = array();
		}
		$lookupTableLinks["distributivo"]["t2_f_m3.Asignatura"]["edit"] = array("table" => "T2.F.M3", "field" => "Asignatura", "page" => "edit");
		if( !isset( $lookupTableLinks["trimestre"] ) ) {
			$lookupTableLinks["trimestre"] = array();
		}
		if( !isset( $lookupTableLinks["trimestre"]["t2_f_m3.Trimestre"] )) {
			$lookupTableLinks["trimestre"]["t2_f_m3.Trimestre"] = array();
		}
		$lookupTableLinks["trimestre"]["t2_f_m3.Trimestre"]["edit"] = array("table" => "T2.F.M3", "field" => "Trimestre", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["t3_f_m1.Docente"] )) {
			$lookupTableLinks["distributivo"]["t3_f_m1.Docente"] = array();
		}
		$lookupTableLinks["distributivo"]["t3_f_m1.Docente"]["edit"] = array("table" => "T3.F.M1", "field" => "Docente", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["t3_f_m1.Especialidad"] )) {
			$lookupTableLinks["distributivo"]["t3_f_m1.Especialidad"] = array();
		}
		$lookupTableLinks["distributivo"]["t3_f_m1.Especialidad"]["edit"] = array("table" => "T3.F.M1", "field" => "Especialidad", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["t3_f_m1.Curso"] )) {
			$lookupTableLinks["distributivo"]["t3_f_m1.Curso"] = array();
		}
		$lookupTableLinks["distributivo"]["t3_f_m1.Curso"]["edit"] = array("table" => "T3.F.M1", "field" => "Curso", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["t3_f_m1.Paralelo"] )) {
			$lookupTableLinks["distributivo"]["t3_f_m1.Paralelo"] = array();
		}
		$lookupTableLinks["distributivo"]["t3_f_m1.Paralelo"]["edit"] = array("table" => "T3.F.M1", "field" => "Paralelo", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["t3_f_m1.Asignatura"] )) {
			$lookupTableLinks["distributivo"]["t3_f_m1.Asignatura"] = array();
		}
		$lookupTableLinks["distributivo"]["t3_f_m1.Asignatura"]["edit"] = array("table" => "T3.F.M1", "field" => "Asignatura", "page" => "edit");
		if( !isset( $lookupTableLinks["trimestre"] ) ) {
			$lookupTableLinks["trimestre"] = array();
		}
		if( !isset( $lookupTableLinks["trimestre"]["t3_f_m1.Trimestre"] )) {
			$lookupTableLinks["trimestre"]["t3_f_m1.Trimestre"] = array();
		}
		$lookupTableLinks["trimestre"]["t3_f_m1.Trimestre"]["edit"] = array("table" => "T3.F.M1", "field" => "Trimestre", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["t3_f_m2.Docente"] )) {
			$lookupTableLinks["distributivo"]["t3_f_m2.Docente"] = array();
		}
		$lookupTableLinks["distributivo"]["t3_f_m2.Docente"]["edit"] = array("table" => "T3.F.M2", "field" => "Docente", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["t3_f_m2.Especialidad"] )) {
			$lookupTableLinks["distributivo"]["t3_f_m2.Especialidad"] = array();
		}
		$lookupTableLinks["distributivo"]["t3_f_m2.Especialidad"]["edit"] = array("table" => "T3.F.M2", "field" => "Especialidad", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["t3_f_m2.Curso"] )) {
			$lookupTableLinks["distributivo"]["t3_f_m2.Curso"] = array();
		}
		$lookupTableLinks["distributivo"]["t3_f_m2.Curso"]["edit"] = array("table" => "T3.F.M2", "field" => "Curso", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["t3_f_m2.Paralelo"] )) {
			$lookupTableLinks["distributivo"]["t3_f_m2.Paralelo"] = array();
		}
		$lookupTableLinks["distributivo"]["t3_f_m2.Paralelo"]["edit"] = array("table" => "T3.F.M2", "field" => "Paralelo", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["t3_f_m2.Asignatura"] )) {
			$lookupTableLinks["distributivo"]["t3_f_m2.Asignatura"] = array();
		}
		$lookupTableLinks["distributivo"]["t3_f_m2.Asignatura"]["edit"] = array("table" => "T3.F.M2", "field" => "Asignatura", "page" => "edit");
		if( !isset( $lookupTableLinks["trimestre"] ) ) {
			$lookupTableLinks["trimestre"] = array();
		}
		if( !isset( $lookupTableLinks["trimestre"]["t3_f_m2.Trimestre"] )) {
			$lookupTableLinks["trimestre"]["t3_f_m2.Trimestre"] = array();
		}
		$lookupTableLinks["trimestre"]["t3_f_m2.Trimestre"]["edit"] = array("table" => "T3.F.M2", "field" => "Trimestre", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["t3_f_m3.Docente"] )) {
			$lookupTableLinks["distributivo"]["t3_f_m3.Docente"] = array();
		}
		$lookupTableLinks["distributivo"]["t3_f_m3.Docente"]["edit"] = array("table" => "T3.F.M3", "field" => "Docente", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["t3_f_m3.Especialidad"] )) {
			$lookupTableLinks["distributivo"]["t3_f_m3.Especialidad"] = array();
		}
		$lookupTableLinks["distributivo"]["t3_f_m3.Especialidad"]["edit"] = array("table" => "T3.F.M3", "field" => "Especialidad", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["t3_f_m3.Curso"] )) {
			$lookupTableLinks["distributivo"]["t3_f_m3.Curso"] = array();
		}
		$lookupTableLinks["distributivo"]["t3_f_m3.Curso"]["edit"] = array("table" => "T3.F.M3", "field" => "Curso", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["t3_f_m3.Paralelo"] )) {
			$lookupTableLinks["distributivo"]["t3_f_m3.Paralelo"] = array();
		}
		$lookupTableLinks["distributivo"]["t3_f_m3.Paralelo"]["edit"] = array("table" => "T3.F.M3", "field" => "Paralelo", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["t3_f_m3.Asignatura"] )) {
			$lookupTableLinks["distributivo"]["t3_f_m3.Asignatura"] = array();
		}
		$lookupTableLinks["distributivo"]["t3_f_m3.Asignatura"]["edit"] = array("table" => "T3.F.M3", "field" => "Asignatura", "page" => "edit");
		if( !isset( $lookupTableLinks["trimestre"] ) ) {
			$lookupTableLinks["trimestre"] = array();
		}
		if( !isset( $lookupTableLinks["trimestre"]["t3_f_m3.Trimestre"] )) {
			$lookupTableLinks["trimestre"]["t3_f_m3.Trimestre"] = array();
		}
		$lookupTableLinks["trimestre"]["t3_f_m3.Trimestre"]["edit"] = array("table" => "T3.F.M3", "field" => "Trimestre", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["at1m1.Docente"] )) {
			$lookupTableLinks["distributivo"]["at1m1.Docente"] = array();
		}
		$lookupTableLinks["distributivo"]["at1m1.Docente"]["edit"] = array("table" => "AT1M1", "field" => "Docente", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["at1m1.Especialidad"] )) {
			$lookupTableLinks["distributivo"]["at1m1.Especialidad"] = array();
		}
		$lookupTableLinks["distributivo"]["at1m1.Especialidad"]["edit"] = array("table" => "AT1M1", "field" => "Especialidad", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["at1m1.Curso"] )) {
			$lookupTableLinks["distributivo"]["at1m1.Curso"] = array();
		}
		$lookupTableLinks["distributivo"]["at1m1.Curso"]["edit"] = array("table" => "AT1M1", "field" => "Curso", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["at1m1.Paralelo"] )) {
			$lookupTableLinks["distributivo"]["at1m1.Paralelo"] = array();
		}
		$lookupTableLinks["distributivo"]["at1m1.Paralelo"]["edit"] = array("table" => "AT1M1", "field" => "Paralelo", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["at1m1.Asignatura"] )) {
			$lookupTableLinks["distributivo"]["at1m1.Asignatura"] = array();
		}
		$lookupTableLinks["distributivo"]["at1m1.Asignatura"]["edit"] = array("table" => "AT1M1", "field" => "Asignatura", "page" => "edit");
		if( !isset( $lookupTableLinks["trimestre"] ) ) {
			$lookupTableLinks["trimestre"] = array();
		}
		if( !isset( $lookupTableLinks["trimestre"]["at1m1.Trimestre"] )) {
			$lookupTableLinks["trimestre"]["at1m1.Trimestre"] = array();
		}
		$lookupTableLinks["trimestre"]["at1m1.Trimestre"]["edit"] = array("table" => "AT1M1", "field" => "Trimestre", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["primer_trimestre.Cedula"] )) {
			$lookupTableLinks["distributivo"]["primer_trimestre.Cedula"] = array();
		}
		$lookupTableLinks["distributivo"]["primer_trimestre.Cedula"]["edit"] = array("table" => "Primer Trimestre", "field" => "Cedula", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["primer_trimestre.Especialidad"] )) {
			$lookupTableLinks["distributivo"]["primer_trimestre.Especialidad"] = array();
		}
		$lookupTableLinks["distributivo"]["primer_trimestre.Especialidad"]["edit"] = array("table" => "Primer Trimestre", "field" => "Especialidad", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["primer_trimestre.Curso"] )) {
			$lookupTableLinks["distributivo"]["primer_trimestre.Curso"] = array();
		}
		$lookupTableLinks["distributivo"]["primer_trimestre.Curso"]["edit"] = array("table" => "Primer Trimestre", "field" => "Curso", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["primer_trimestre.Paralelo"] )) {
			$lookupTableLinks["distributivo"]["primer_trimestre.Paralelo"] = array();
		}
		$lookupTableLinks["distributivo"]["primer_trimestre.Paralelo"]["edit"] = array("table" => "Primer Trimestre", "field" => "Paralelo", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["primer_trimestre.Asignatura"] )) {
			$lookupTableLinks["distributivo"]["primer_trimestre.Asignatura"] = array();
		}
		$lookupTableLinks["distributivo"]["primer_trimestre.Asignatura"]["edit"] = array("table" => "Primer Trimestre", "field" => "Asignatura", "page" => "edit");
		if( !isset( $lookupTableLinks["usuarios"] ) ) {
			$lookupTableLinks["usuarios"] = array();
		}
		if( !isset( $lookupTableLinks["usuarios"]["primer_trimestre.Estudiante"] )) {
			$lookupTableLinks["usuarios"]["primer_trimestre.Estudiante"] = array();
		}
		$lookupTableLinks["usuarios"]["primer_trimestre.Estudiante"]["edit"] = array("table" => "Primer Trimestre", "field" => "Estudiante", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["segundo_trimestre1.Cedula"] )) {
			$lookupTableLinks["distributivo"]["segundo_trimestre1.Cedula"] = array();
		}
		$lookupTableLinks["distributivo"]["segundo_trimestre1.Cedula"]["edit"] = array("table" => "Segundo Trimestre1", "field" => "Cedula", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["segundo_trimestre1.Especialidad"] )) {
			$lookupTableLinks["distributivo"]["segundo_trimestre1.Especialidad"] = array();
		}
		$lookupTableLinks["distributivo"]["segundo_trimestre1.Especialidad"]["edit"] = array("table" => "Segundo Trimestre1", "field" => "Especialidad", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["segundo_trimestre1.Curso"] )) {
			$lookupTableLinks["distributivo"]["segundo_trimestre1.Curso"] = array();
		}
		$lookupTableLinks["distributivo"]["segundo_trimestre1.Curso"]["edit"] = array("table" => "Segundo Trimestre1", "field" => "Curso", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["segundo_trimestre1.Paralelo"] )) {
			$lookupTableLinks["distributivo"]["segundo_trimestre1.Paralelo"] = array();
		}
		$lookupTableLinks["distributivo"]["segundo_trimestre1.Paralelo"]["edit"] = array("table" => "Segundo Trimestre1", "field" => "Paralelo", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["segundo_trimestre1.Asignatura"] )) {
			$lookupTableLinks["distributivo"]["segundo_trimestre1.Asignatura"] = array();
		}
		$lookupTableLinks["distributivo"]["segundo_trimestre1.Asignatura"]["edit"] = array("table" => "Segundo Trimestre1", "field" => "Asignatura", "page" => "edit");
		if( !isset( $lookupTableLinks["usuarios"] ) ) {
			$lookupTableLinks["usuarios"] = array();
		}
		if( !isset( $lookupTableLinks["usuarios"]["segundo_trimestre1.Estudiante"] )) {
			$lookupTableLinks["usuarios"]["segundo_trimestre1.Estudiante"] = array();
		}
		$lookupTableLinks["usuarios"]["segundo_trimestre1.Estudiante"]["edit"] = array("table" => "Segundo Trimestre1", "field" => "Estudiante", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["tercer_trimestre1.Cedula"] )) {
			$lookupTableLinks["distributivo"]["tercer_trimestre1.Cedula"] = array();
		}
		$lookupTableLinks["distributivo"]["tercer_trimestre1.Cedula"]["edit"] = array("table" => "Tercer Trimestre1", "field" => "Cedula", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["tercer_trimestre1.Especialidad"] )) {
			$lookupTableLinks["distributivo"]["tercer_trimestre1.Especialidad"] = array();
		}
		$lookupTableLinks["distributivo"]["tercer_trimestre1.Especialidad"]["edit"] = array("table" => "Tercer Trimestre1", "field" => "Especialidad", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["tercer_trimestre1.Curso"] )) {
			$lookupTableLinks["distributivo"]["tercer_trimestre1.Curso"] = array();
		}
		$lookupTableLinks["distributivo"]["tercer_trimestre1.Curso"]["edit"] = array("table" => "Tercer Trimestre1", "field" => "Curso", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["tercer_trimestre1.Paralelo"] )) {
			$lookupTableLinks["distributivo"]["tercer_trimestre1.Paralelo"] = array();
		}
		$lookupTableLinks["distributivo"]["tercer_trimestre1.Paralelo"]["edit"] = array("table" => "Tercer Trimestre1", "field" => "Paralelo", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["tercer_trimestre1.Asignatura"] )) {
			$lookupTableLinks["distributivo"]["tercer_trimestre1.Asignatura"] = array();
		}
		$lookupTableLinks["distributivo"]["tercer_trimestre1.Asignatura"]["edit"] = array("table" => "Tercer Trimestre1", "field" => "Asignatura", "page" => "edit");
		if( !isset( $lookupTableLinks["usuarios"] ) ) {
			$lookupTableLinks["usuarios"] = array();
		}
		if( !isset( $lookupTableLinks["usuarios"]["tercer_trimestre1.Estudiante"] )) {
			$lookupTableLinks["usuarios"]["tercer_trimestre1.Estudiante"] = array();
		}
		$lookupTableLinks["usuarios"]["tercer_trimestre1.Estudiante"]["edit"] = array("table" => "Tercer Trimestre1", "field" => "Estudiante", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["promedios_primer_trimestre.Docente"] )) {
			$lookupTableLinks["distributivo"]["promedios_primer_trimestre.Docente"] = array();
		}
		$lookupTableLinks["distributivo"]["promedios_primer_trimestre.Docente"]["edit"] = array("table" => "Promedios Primer Trimestre", "field" => "Docente", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["promedios_primer_trimestre.Especialidad"] )) {
			$lookupTableLinks["distributivo"]["promedios_primer_trimestre.Especialidad"] = array();
		}
		$lookupTableLinks["distributivo"]["promedios_primer_trimestre.Especialidad"]["edit"] = array("table" => "Promedios Primer Trimestre", "field" => "Especialidad", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["promedios_primer_trimestre.Curso"] )) {
			$lookupTableLinks["distributivo"]["promedios_primer_trimestre.Curso"] = array();
		}
		$lookupTableLinks["distributivo"]["promedios_primer_trimestre.Curso"]["edit"] = array("table" => "Promedios Primer Trimestre", "field" => "Curso", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["promedios_primer_trimestre.Paralelo"] )) {
			$lookupTableLinks["distributivo"]["promedios_primer_trimestre.Paralelo"] = array();
		}
		$lookupTableLinks["distributivo"]["promedios_primer_trimestre.Paralelo"]["edit"] = array("table" => "Promedios Primer Trimestre", "field" => "Paralelo", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["promedios_primer_trimestre.Asignatura"] )) {
			$lookupTableLinks["distributivo"]["promedios_primer_trimestre.Asignatura"] = array();
		}
		$lookupTableLinks["distributivo"]["promedios_primer_trimestre.Asignatura"]["edit"] = array("table" => "Promedios Primer Trimestre", "field" => "Asignatura", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["at1m2.Docente"] )) {
			$lookupTableLinks["distributivo"]["at1m2.Docente"] = array();
		}
		$lookupTableLinks["distributivo"]["at1m2.Docente"]["edit"] = array("table" => "AT1M2", "field" => "Docente", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["at1m2.Especialidad"] )) {
			$lookupTableLinks["distributivo"]["at1m2.Especialidad"] = array();
		}
		$lookupTableLinks["distributivo"]["at1m2.Especialidad"]["edit"] = array("table" => "AT1M2", "field" => "Especialidad", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["at1m2.Curso"] )) {
			$lookupTableLinks["distributivo"]["at1m2.Curso"] = array();
		}
		$lookupTableLinks["distributivo"]["at1m2.Curso"]["edit"] = array("table" => "AT1M2", "field" => "Curso", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["at1m2.Paralelo"] )) {
			$lookupTableLinks["distributivo"]["at1m2.Paralelo"] = array();
		}
		$lookupTableLinks["distributivo"]["at1m2.Paralelo"]["edit"] = array("table" => "AT1M2", "field" => "Paralelo", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["at1m2.Asignatura"] )) {
			$lookupTableLinks["distributivo"]["at1m2.Asignatura"] = array();
		}
		$lookupTableLinks["distributivo"]["at1m2.Asignatura"]["edit"] = array("table" => "AT1M2", "field" => "Asignatura", "page" => "edit");
		if( !isset( $lookupTableLinks["trimestre"] ) ) {
			$lookupTableLinks["trimestre"] = array();
		}
		if( !isset( $lookupTableLinks["trimestre"]["at1m2.Trimestre"] )) {
			$lookupTableLinks["trimestre"]["at1m2.Trimestre"] = array();
		}
		$lookupTableLinks["trimestre"]["at1m2.Trimestre"]["edit"] = array("table" => "AT1M2", "field" => "Trimestre", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["at1m3.Docente"] )) {
			$lookupTableLinks["distributivo"]["at1m3.Docente"] = array();
		}
		$lookupTableLinks["distributivo"]["at1m3.Docente"]["edit"] = array("table" => "AT1M3", "field" => "Docente", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["at1m3.Especialidad"] )) {
			$lookupTableLinks["distributivo"]["at1m3.Especialidad"] = array();
		}
		$lookupTableLinks["distributivo"]["at1m3.Especialidad"]["edit"] = array("table" => "AT1M3", "field" => "Especialidad", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["at1m3.Curso"] )) {
			$lookupTableLinks["distributivo"]["at1m3.Curso"] = array();
		}
		$lookupTableLinks["distributivo"]["at1m3.Curso"]["edit"] = array("table" => "AT1M3", "field" => "Curso", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["at1m3.Paralelo"] )) {
			$lookupTableLinks["distributivo"]["at1m3.Paralelo"] = array();
		}
		$lookupTableLinks["distributivo"]["at1m3.Paralelo"]["edit"] = array("table" => "AT1M3", "field" => "Paralelo", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["at1m3.Asignatura"] )) {
			$lookupTableLinks["distributivo"]["at1m3.Asignatura"] = array();
		}
		$lookupTableLinks["distributivo"]["at1m3.Asignatura"]["edit"] = array("table" => "AT1M3", "field" => "Asignatura", "page" => "edit");
		if( !isset( $lookupTableLinks["trimestre"] ) ) {
			$lookupTableLinks["trimestre"] = array();
		}
		if( !isset( $lookupTableLinks["trimestre"]["at1m3.Trimestre"] )) {
			$lookupTableLinks["trimestre"]["at1m3.Trimestre"] = array();
		}
		$lookupTableLinks["trimestre"]["at1m3.Trimestre"]["edit"] = array("table" => "AT1M3", "field" => "Trimestre", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["at2m1.Docente"] )) {
			$lookupTableLinks["distributivo"]["at2m1.Docente"] = array();
		}
		$lookupTableLinks["distributivo"]["at2m1.Docente"]["edit"] = array("table" => "AT2M1", "field" => "Docente", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["at2m1.Especialidad"] )) {
			$lookupTableLinks["distributivo"]["at2m1.Especialidad"] = array();
		}
		$lookupTableLinks["distributivo"]["at2m1.Especialidad"]["edit"] = array("table" => "AT2M1", "field" => "Especialidad", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["at2m1.Curso"] )) {
			$lookupTableLinks["distributivo"]["at2m1.Curso"] = array();
		}
		$lookupTableLinks["distributivo"]["at2m1.Curso"]["edit"] = array("table" => "AT2M1", "field" => "Curso", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["at2m1.Paralelo"] )) {
			$lookupTableLinks["distributivo"]["at2m1.Paralelo"] = array();
		}
		$lookupTableLinks["distributivo"]["at2m1.Paralelo"]["edit"] = array("table" => "AT2M1", "field" => "Paralelo", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["at2m1.Asignatura"] )) {
			$lookupTableLinks["distributivo"]["at2m1.Asignatura"] = array();
		}
		$lookupTableLinks["distributivo"]["at2m1.Asignatura"]["edit"] = array("table" => "AT2M1", "field" => "Asignatura", "page" => "edit");
		if( !isset( $lookupTableLinks["trimestre"] ) ) {
			$lookupTableLinks["trimestre"] = array();
		}
		if( !isset( $lookupTableLinks["trimestre"]["at2m1.Trimestre"] )) {
			$lookupTableLinks["trimestre"]["at2m1.Trimestre"] = array();
		}
		$lookupTableLinks["trimestre"]["at2m1.Trimestre"]["edit"] = array("table" => "AT2M1", "field" => "Trimestre", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["at2m2.Docente"] )) {
			$lookupTableLinks["distributivo"]["at2m2.Docente"] = array();
		}
		$lookupTableLinks["distributivo"]["at2m2.Docente"]["edit"] = array("table" => "AT2M2", "field" => "Docente", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["at2m2.Especialidad"] )) {
			$lookupTableLinks["distributivo"]["at2m2.Especialidad"] = array();
		}
		$lookupTableLinks["distributivo"]["at2m2.Especialidad"]["edit"] = array("table" => "AT2M2", "field" => "Especialidad", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["at2m2.Curso"] )) {
			$lookupTableLinks["distributivo"]["at2m2.Curso"] = array();
		}
		$lookupTableLinks["distributivo"]["at2m2.Curso"]["edit"] = array("table" => "AT2M2", "field" => "Curso", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["at2m2.Paralelo"] )) {
			$lookupTableLinks["distributivo"]["at2m2.Paralelo"] = array();
		}
		$lookupTableLinks["distributivo"]["at2m2.Paralelo"]["edit"] = array("table" => "AT2M2", "field" => "Paralelo", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["at2m2.Asignatura"] )) {
			$lookupTableLinks["distributivo"]["at2m2.Asignatura"] = array();
		}
		$lookupTableLinks["distributivo"]["at2m2.Asignatura"]["edit"] = array("table" => "AT2M2", "field" => "Asignatura", "page" => "edit");
		if( !isset( $lookupTableLinks["trimestre"] ) ) {
			$lookupTableLinks["trimestre"] = array();
		}
		if( !isset( $lookupTableLinks["trimestre"]["at2m2.Trimestre"] )) {
			$lookupTableLinks["trimestre"]["at2m2.Trimestre"] = array();
		}
		$lookupTableLinks["trimestre"]["at2m2.Trimestre"]["edit"] = array("table" => "AT2M2", "field" => "Trimestre", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["at2m3.Docente"] )) {
			$lookupTableLinks["distributivo"]["at2m3.Docente"] = array();
		}
		$lookupTableLinks["distributivo"]["at2m3.Docente"]["edit"] = array("table" => "AT2M3", "field" => "Docente", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["at2m3.Especialidad"] )) {
			$lookupTableLinks["distributivo"]["at2m3.Especialidad"] = array();
		}
		$lookupTableLinks["distributivo"]["at2m3.Especialidad"]["edit"] = array("table" => "AT2M3", "field" => "Especialidad", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["at2m3.Curso"] )) {
			$lookupTableLinks["distributivo"]["at2m3.Curso"] = array();
		}
		$lookupTableLinks["distributivo"]["at2m3.Curso"]["edit"] = array("table" => "AT2M3", "field" => "Curso", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["at2m3.Paralelo"] )) {
			$lookupTableLinks["distributivo"]["at2m3.Paralelo"] = array();
		}
		$lookupTableLinks["distributivo"]["at2m3.Paralelo"]["edit"] = array("table" => "AT2M3", "field" => "Paralelo", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["at2m3.Asignatura"] )) {
			$lookupTableLinks["distributivo"]["at2m3.Asignatura"] = array();
		}
		$lookupTableLinks["distributivo"]["at2m3.Asignatura"]["edit"] = array("table" => "AT2M3", "field" => "Asignatura", "page" => "edit");
		if( !isset( $lookupTableLinks["trimestre"] ) ) {
			$lookupTableLinks["trimestre"] = array();
		}
		if( !isset( $lookupTableLinks["trimestre"]["at2m3.Trimestre"] )) {
			$lookupTableLinks["trimestre"]["at2m3.Trimestre"] = array();
		}
		$lookupTableLinks["trimestre"]["at2m3.Trimestre"]["edit"] = array("table" => "AT2M3", "field" => "Trimestre", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["at3m1.Docente"] )) {
			$lookupTableLinks["distributivo"]["at3m1.Docente"] = array();
		}
		$lookupTableLinks["distributivo"]["at3m1.Docente"]["edit"] = array("table" => "AT3M1", "field" => "Docente", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["at3m1.Especialidad"] )) {
			$lookupTableLinks["distributivo"]["at3m1.Especialidad"] = array();
		}
		$lookupTableLinks["distributivo"]["at3m1.Especialidad"]["edit"] = array("table" => "AT3M1", "field" => "Especialidad", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["at3m1.Curso"] )) {
			$lookupTableLinks["distributivo"]["at3m1.Curso"] = array();
		}
		$lookupTableLinks["distributivo"]["at3m1.Curso"]["edit"] = array("table" => "AT3M1", "field" => "Curso", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["at3m1.Paralelo"] )) {
			$lookupTableLinks["distributivo"]["at3m1.Paralelo"] = array();
		}
		$lookupTableLinks["distributivo"]["at3m1.Paralelo"]["edit"] = array("table" => "AT3M1", "field" => "Paralelo", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["at3m1.Asignatura"] )) {
			$lookupTableLinks["distributivo"]["at3m1.Asignatura"] = array();
		}
		$lookupTableLinks["distributivo"]["at3m1.Asignatura"]["edit"] = array("table" => "AT3M1", "field" => "Asignatura", "page" => "edit");
		if( !isset( $lookupTableLinks["trimestre"] ) ) {
			$lookupTableLinks["trimestre"] = array();
		}
		if( !isset( $lookupTableLinks["trimestre"]["at3m1.Trimestre"] )) {
			$lookupTableLinks["trimestre"]["at3m1.Trimestre"] = array();
		}
		$lookupTableLinks["trimestre"]["at3m1.Trimestre"]["edit"] = array("table" => "AT3M1", "field" => "Trimestre", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["at3m2.Docente"] )) {
			$lookupTableLinks["distributivo"]["at3m2.Docente"] = array();
		}
		$lookupTableLinks["distributivo"]["at3m2.Docente"]["edit"] = array("table" => "AT3M2", "field" => "Docente", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["at3m2.Especialidad"] )) {
			$lookupTableLinks["distributivo"]["at3m2.Especialidad"] = array();
		}
		$lookupTableLinks["distributivo"]["at3m2.Especialidad"]["edit"] = array("table" => "AT3M2", "field" => "Especialidad", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["at3m2.Curso"] )) {
			$lookupTableLinks["distributivo"]["at3m2.Curso"] = array();
		}
		$lookupTableLinks["distributivo"]["at3m2.Curso"]["edit"] = array("table" => "AT3M2", "field" => "Curso", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["at3m2.Paralelo"] )) {
			$lookupTableLinks["distributivo"]["at3m2.Paralelo"] = array();
		}
		$lookupTableLinks["distributivo"]["at3m2.Paralelo"]["edit"] = array("table" => "AT3M2", "field" => "Paralelo", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["at3m2.Asignatura"] )) {
			$lookupTableLinks["distributivo"]["at3m2.Asignatura"] = array();
		}
		$lookupTableLinks["distributivo"]["at3m2.Asignatura"]["edit"] = array("table" => "AT3M2", "field" => "Asignatura", "page" => "edit");
		if( !isset( $lookupTableLinks["trimestre"] ) ) {
			$lookupTableLinks["trimestre"] = array();
		}
		if( !isset( $lookupTableLinks["trimestre"]["at3m2.Trimestre"] )) {
			$lookupTableLinks["trimestre"]["at3m2.Trimestre"] = array();
		}
		$lookupTableLinks["trimestre"]["at3m2.Trimestre"]["edit"] = array("table" => "AT3M2", "field" => "Trimestre", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["at3m3.Docente"] )) {
			$lookupTableLinks["distributivo"]["at3m3.Docente"] = array();
		}
		$lookupTableLinks["distributivo"]["at3m3.Docente"]["edit"] = array("table" => "AT3M3", "field" => "Docente", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["at3m3.Especialidad"] )) {
			$lookupTableLinks["distributivo"]["at3m3.Especialidad"] = array();
		}
		$lookupTableLinks["distributivo"]["at3m3.Especialidad"]["edit"] = array("table" => "AT3M3", "field" => "Especialidad", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["at3m3.Curso"] )) {
			$lookupTableLinks["distributivo"]["at3m3.Curso"] = array();
		}
		$lookupTableLinks["distributivo"]["at3m3.Curso"]["edit"] = array("table" => "AT3M3", "field" => "Curso", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["at3m3.Paralelo"] )) {
			$lookupTableLinks["distributivo"]["at3m3.Paralelo"] = array();
		}
		$lookupTableLinks["distributivo"]["at3m3.Paralelo"]["edit"] = array("table" => "AT3M3", "field" => "Paralelo", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["at3m3.Asignatura"] )) {
			$lookupTableLinks["distributivo"]["at3m3.Asignatura"] = array();
		}
		$lookupTableLinks["distributivo"]["at3m3.Asignatura"]["edit"] = array("table" => "AT3M3", "field" => "Asignatura", "page" => "edit");
		if( !isset( $lookupTableLinks["trimestre"] ) ) {
			$lookupTableLinks["trimestre"] = array();
		}
		if( !isset( $lookupTableLinks["trimestre"]["at3m3.Trimestre"] )) {
			$lookupTableLinks["trimestre"]["at3m3.Trimestre"] = array();
		}
		$lookupTableLinks["trimestre"]["at3m3.Trimestre"]["edit"] = array("table" => "AT3M3", "field" => "Trimestre", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["primer_trimestre_final.Docente"] )) {
			$lookupTableLinks["distributivo"]["primer_trimestre_final.Docente"] = array();
		}
		$lookupTableLinks["distributivo"]["primer_trimestre_final.Docente"]["search"] = array("table" => "Primer Trimestre Final", "field" => "Docente", "page" => "search");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["primer_trimestre_final.Especialidad"] )) {
			$lookupTableLinks["distributivo"]["primer_trimestre_final.Especialidad"] = array();
		}
		$lookupTableLinks["distributivo"]["primer_trimestre_final.Especialidad"]["search"] = array("table" => "Primer Trimestre Final", "field" => "Especialidad", "page" => "search");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["primer_trimestre_final.Curso"] )) {
			$lookupTableLinks["distributivo"]["primer_trimestre_final.Curso"] = array();
		}
		$lookupTableLinks["distributivo"]["primer_trimestre_final.Curso"]["search"] = array("table" => "Primer Trimestre Final", "field" => "Curso", "page" => "search");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["primer_trimestre_final.Paralelo"] )) {
			$lookupTableLinks["distributivo"]["primer_trimestre_final.Paralelo"] = array();
		}
		$lookupTableLinks["distributivo"]["primer_trimestre_final.Paralelo"]["search"] = array("table" => "Primer Trimestre Final", "field" => "Paralelo", "page" => "search");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["primer_trimestre_final.Asignatura"] )) {
			$lookupTableLinks["distributivo"]["primer_trimestre_final.Asignatura"] = array();
		}
		$lookupTableLinks["distributivo"]["primer_trimestre_final.Asignatura"]["search"] = array("table" => "Primer Trimestre Final", "field" => "Asignatura", "page" => "search");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["editar_primer_trimestre.Docente"] )) {
			$lookupTableLinks["distributivo"]["editar_primer_trimestre.Docente"] = array();
		}
		$lookupTableLinks["distributivo"]["editar_primer_trimestre.Docente"]["edit"] = array("table" => "Editar Primer Trimestre", "field" => "Docente", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["editar_primer_trimestre.Especialidad"] )) {
			$lookupTableLinks["distributivo"]["editar_primer_trimestre.Especialidad"] = array();
		}
		$lookupTableLinks["distributivo"]["editar_primer_trimestre.Especialidad"]["edit"] = array("table" => "Editar Primer Trimestre", "field" => "Especialidad", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["editar_primer_trimestre.Curso"] )) {
			$lookupTableLinks["distributivo"]["editar_primer_trimestre.Curso"] = array();
		}
		$lookupTableLinks["distributivo"]["editar_primer_trimestre.Curso"]["edit"] = array("table" => "Editar Primer Trimestre", "field" => "Curso", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["editar_primer_trimestre.Paralelo"] )) {
			$lookupTableLinks["distributivo"]["editar_primer_trimestre.Paralelo"] = array();
		}
		$lookupTableLinks["distributivo"]["editar_primer_trimestre.Paralelo"]["edit"] = array("table" => "Editar Primer Trimestre", "field" => "Paralelo", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["editar_primer_trimestre.Asignatura"] )) {
			$lookupTableLinks["distributivo"]["editar_primer_trimestre.Asignatura"] = array();
		}
		$lookupTableLinks["distributivo"]["editar_primer_trimestre.Asignatura"]["edit"] = array("table" => "Editar Primer Trimestre", "field" => "Asignatura", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["editar_segundo_trimestre.Docente"] )) {
			$lookupTableLinks["distributivo"]["editar_segundo_trimestre.Docente"] = array();
		}
		$lookupTableLinks["distributivo"]["editar_segundo_trimestre.Docente"]["edit"] = array("table" => "Editar Segundo Trimestre", "field" => "Docente", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["editar_segundo_trimestre.Especialidad"] )) {
			$lookupTableLinks["distributivo"]["editar_segundo_trimestre.Especialidad"] = array();
		}
		$lookupTableLinks["distributivo"]["editar_segundo_trimestre.Especialidad"]["edit"] = array("table" => "Editar Segundo Trimestre", "field" => "Especialidad", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["editar_segundo_trimestre.Curso"] )) {
			$lookupTableLinks["distributivo"]["editar_segundo_trimestre.Curso"] = array();
		}
		$lookupTableLinks["distributivo"]["editar_segundo_trimestre.Curso"]["edit"] = array("table" => "Editar Segundo Trimestre", "field" => "Curso", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["editar_segundo_trimestre.Paralelo"] )) {
			$lookupTableLinks["distributivo"]["editar_segundo_trimestre.Paralelo"] = array();
		}
		$lookupTableLinks["distributivo"]["editar_segundo_trimestre.Paralelo"]["edit"] = array("table" => "Editar Segundo Trimestre", "field" => "Paralelo", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["editar_segundo_trimestre.Asignatura"] )) {
			$lookupTableLinks["distributivo"]["editar_segundo_trimestre.Asignatura"] = array();
		}
		$lookupTableLinks["distributivo"]["editar_segundo_trimestre.Asignatura"]["edit"] = array("table" => "Editar Segundo Trimestre", "field" => "Asignatura", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["editar_tercer_trimestre.Docente"] )) {
			$lookupTableLinks["distributivo"]["editar_tercer_trimestre.Docente"] = array();
		}
		$lookupTableLinks["distributivo"]["editar_tercer_trimestre.Docente"]["edit"] = array("table" => "Editar Tercer Trimestre", "field" => "Docente", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["editar_tercer_trimestre.Especialidad"] )) {
			$lookupTableLinks["distributivo"]["editar_tercer_trimestre.Especialidad"] = array();
		}
		$lookupTableLinks["distributivo"]["editar_tercer_trimestre.Especialidad"]["edit"] = array("table" => "Editar Tercer Trimestre", "field" => "Especialidad", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["editar_tercer_trimestre.Curso"] )) {
			$lookupTableLinks["distributivo"]["editar_tercer_trimestre.Curso"] = array();
		}
		$lookupTableLinks["distributivo"]["editar_tercer_trimestre.Curso"]["edit"] = array("table" => "Editar Tercer Trimestre", "field" => "Curso", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["editar_tercer_trimestre.Paralelo"] )) {
			$lookupTableLinks["distributivo"]["editar_tercer_trimestre.Paralelo"] = array();
		}
		$lookupTableLinks["distributivo"]["editar_tercer_trimestre.Paralelo"]["edit"] = array("table" => "Editar Tercer Trimestre", "field" => "Paralelo", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["editar_tercer_trimestre.Asignatura"] )) {
			$lookupTableLinks["distributivo"]["editar_tercer_trimestre.Asignatura"] = array();
		}
		$lookupTableLinks["distributivo"]["editar_tercer_trimestre.Asignatura"]["edit"] = array("table" => "Editar Tercer Trimestre", "field" => "Asignatura", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["segundo_trimestre_final.Docente"] )) {
			$lookupTableLinks["distributivo"]["segundo_trimestre_final.Docente"] = array();
		}
		$lookupTableLinks["distributivo"]["segundo_trimestre_final.Docente"]["search"] = array("table" => "Segundo Trimestre Final", "field" => "Docente", "page" => "search");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["segundo_trimestre_final.Especialidad"] )) {
			$lookupTableLinks["distributivo"]["segundo_trimestre_final.Especialidad"] = array();
		}
		$lookupTableLinks["distributivo"]["segundo_trimestre_final.Especialidad"]["search"] = array("table" => "Segundo Trimestre Final", "field" => "Especialidad", "page" => "search");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["segundo_trimestre_final.Curso"] )) {
			$lookupTableLinks["distributivo"]["segundo_trimestre_final.Curso"] = array();
		}
		$lookupTableLinks["distributivo"]["segundo_trimestre_final.Curso"]["search"] = array("table" => "Segundo Trimestre Final", "field" => "Curso", "page" => "search");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["segundo_trimestre_final.Paralelo"] )) {
			$lookupTableLinks["distributivo"]["segundo_trimestre_final.Paralelo"] = array();
		}
		$lookupTableLinks["distributivo"]["segundo_trimestre_final.Paralelo"]["search"] = array("table" => "Segundo Trimestre Final", "field" => "Paralelo", "page" => "search");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["segundo_trimestre_final.Asignatura"] )) {
			$lookupTableLinks["distributivo"]["segundo_trimestre_final.Asignatura"] = array();
		}
		$lookupTableLinks["distributivo"]["segundo_trimestre_final.Asignatura"]["search"] = array("table" => "Segundo Trimestre Final", "field" => "Asignatura", "page" => "search");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["tercer_trimestre_final.Docente"] )) {
			$lookupTableLinks["distributivo"]["tercer_trimestre_final.Docente"] = array();
		}
		$lookupTableLinks["distributivo"]["tercer_trimestre_final.Docente"]["search"] = array("table" => "Tercer Trimestre Final", "field" => "Docente", "page" => "search");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["tercer_trimestre_final.Especialidad"] )) {
			$lookupTableLinks["distributivo"]["tercer_trimestre_final.Especialidad"] = array();
		}
		$lookupTableLinks["distributivo"]["tercer_trimestre_final.Especialidad"]["search"] = array("table" => "Tercer Trimestre Final", "field" => "Especialidad", "page" => "search");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["tercer_trimestre_final.Curso"] )) {
			$lookupTableLinks["distributivo"]["tercer_trimestre_final.Curso"] = array();
		}
		$lookupTableLinks["distributivo"]["tercer_trimestre_final.Curso"]["search"] = array("table" => "Tercer Trimestre Final", "field" => "Curso", "page" => "search");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["tercer_trimestre_final.Paralelo"] )) {
			$lookupTableLinks["distributivo"]["tercer_trimestre_final.Paralelo"] = array();
		}
		$lookupTableLinks["distributivo"]["tercer_trimestre_final.Paralelo"]["search"] = array("table" => "Tercer Trimestre Final", "field" => "Paralelo", "page" => "search");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["tercer_trimestre_final.Asignatura"] )) {
			$lookupTableLinks["distributivo"]["tercer_trimestre_final.Asignatura"] = array();
		}
		$lookupTableLinks["distributivo"]["tercer_trimestre_final.Asignatura"]["search"] = array("table" => "Tercer Trimestre Final", "field" => "Asignatura", "page" => "search");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["promedios_segundo_trimestre.Docente"] )) {
			$lookupTableLinks["distributivo"]["promedios_segundo_trimestre.Docente"] = array();
		}
		$lookupTableLinks["distributivo"]["promedios_segundo_trimestre.Docente"]["edit"] = array("table" => "Promedios Segundo Trimestre", "field" => "Docente", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["promedios_segundo_trimestre.Especialidad"] )) {
			$lookupTableLinks["distributivo"]["promedios_segundo_trimestre.Especialidad"] = array();
		}
		$lookupTableLinks["distributivo"]["promedios_segundo_trimestre.Especialidad"]["edit"] = array("table" => "Promedios Segundo Trimestre", "field" => "Especialidad", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["promedios_segundo_trimestre.Curso"] )) {
			$lookupTableLinks["distributivo"]["promedios_segundo_trimestre.Curso"] = array();
		}
		$lookupTableLinks["distributivo"]["promedios_segundo_trimestre.Curso"]["edit"] = array("table" => "Promedios Segundo Trimestre", "field" => "Curso", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["promedios_segundo_trimestre.Paralelo"] )) {
			$lookupTableLinks["distributivo"]["promedios_segundo_trimestre.Paralelo"] = array();
		}
		$lookupTableLinks["distributivo"]["promedios_segundo_trimestre.Paralelo"]["edit"] = array("table" => "Promedios Segundo Trimestre", "field" => "Paralelo", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["promedios_segundo_trimestre.Asignatura"] )) {
			$lookupTableLinks["distributivo"]["promedios_segundo_trimestre.Asignatura"] = array();
		}
		$lookupTableLinks["distributivo"]["promedios_segundo_trimestre.Asignatura"]["edit"] = array("table" => "Promedios Segundo Trimestre", "field" => "Asignatura", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["promedios_tercer_trimestre.Docente"] )) {
			$lookupTableLinks["distributivo"]["promedios_tercer_trimestre.Docente"] = array();
		}
		$lookupTableLinks["distributivo"]["promedios_tercer_trimestre.Docente"]["edit"] = array("table" => "Promedios Tercer Trimestre", "field" => "Docente", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["promedios_tercer_trimestre.Especialidad"] )) {
			$lookupTableLinks["distributivo"]["promedios_tercer_trimestre.Especialidad"] = array();
		}
		$lookupTableLinks["distributivo"]["promedios_tercer_trimestre.Especialidad"]["edit"] = array("table" => "Promedios Tercer Trimestre", "field" => "Especialidad", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["promedios_tercer_trimestre.Curso"] )) {
			$lookupTableLinks["distributivo"]["promedios_tercer_trimestre.Curso"] = array();
		}
		$lookupTableLinks["distributivo"]["promedios_tercer_trimestre.Curso"]["edit"] = array("table" => "Promedios Tercer Trimestre", "field" => "Curso", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["promedios_tercer_trimestre.Paralelo"] )) {
			$lookupTableLinks["distributivo"]["promedios_tercer_trimestre.Paralelo"] = array();
		}
		$lookupTableLinks["distributivo"]["promedios_tercer_trimestre.Paralelo"]["edit"] = array("table" => "Promedios Tercer Trimestre", "field" => "Paralelo", "page" => "edit");
		if( !isset( $lookupTableLinks["distributivo"] ) ) {
			$lookupTableLinks["distributivo"] = array();
		}
		if( !isset( $lookupTableLinks["distributivo"]["promedios_tercer_trimestre.Asignatura"] )) {
			$lookupTableLinks["distributivo"]["promedios_tercer_trimestre.Asignatura"] = array();
		}
		$lookupTableLinks["distributivo"]["promedios_tercer_trimestre.Asignatura"]["edit"] = array("table" => "Promedios Tercer Trimestre", "field" => "Asignatura", "page" => "edit");
}

?>