<?php
// pasar_todos_refuerzo_robusto.php - VERSIÓN CORREGIDA

// Desactivar errores en pantalla para no romper el JSON de respuesta
error_reporting(E_ALL);
ini_set('display_errors', 0);

header('Content-Type: application/json; charset=utf-8');

try {
    // 1. CONEXIÓN DESDE ARCHIVO EXTERNO
    require_once 'config_db.php';
    
    $conexion = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
    
    if ($conexion->connect_error) {
        throw new Exception('Error conectando a la base de datos: ' . $conexion->connect_error);
    }
    
    $conexion->set_charset(DB_CHARSET);

    // 2. VALIDAR DATOS RECIBIDOS
    if (!isset($_POST['ids']) || empty($_POST['ids'])) {
        throw new Exception('No se recibieron IDs para procesar');
    }
    
    $ids = $_POST['ids'];
    
    // Limpiar IDs - asegurar que sean números enteros positivos
    $ids_limpios = array_filter($ids, function($id) {
        return is_numeric($id) && $id > 0;
    });
    
    if (empty($ids_limpios)) {
        throw new Exception('No hay IDs válidos en la solicitud');
    }
    
    sort($ids_limpios);
    
    // 3. IDENTIFICAR COLUMNAS EXISTENTES (Manejo de nombres con puntos o espacios)
    $campos_concentrado = [];
    $res_describe = $conexion->query("DESCRIBE concentrado");
    while ($row = $res_describe->fetch_assoc()) {
        $campos_concentrado[] = $row['Field'];
    }
    
    // Determinar qué columna de calificación usar
    $campo_calificacion = '';
    if (in_array('T2.F.M2.P', $campos_concentrado)) {
        $campo_calificacion = '`T2.F.M2.P`'; // Se usan backticks por los puntos
    } elseif (in_array('TLEMAP', $campos_concentrado)) {
        $campo_calificacion = '`TLEMAP`';
    } elseif (in_array('Calificación', $campos_concentrado)) {
        $campo_calificacion = '`Calificación`';
    } else {
        throw new Exception('No se encontró una columna de calificación válida en la tabla concentrado');
    }
    
    // 4. CONSULTA SELECT
    $placeholders = implode(',', array_fill(0, count($ids_limpios), '?'));
    $query = "SELECT id, Docente, Especialidad, Curso, Paralelo, Asignatura, Trimestre, Cestudiante, Estudiante, $campo_calificacion AS Calificacion 
              FROM concentrado WHERE id IN ($placeholders)";
    
    $stmt = $conexion->prepare($query);
    if (!$stmt) {
        throw new Exception('Error preparando consulta SELECT: ' . $conexion->error);
    }
    
    $types = str_repeat('i', count($ids_limpios));
    $stmt->bind_param($types, ...$ids_limpios);
    $stmt->execute();
    $result = $stmt->get_result();
    
    $insertados = 0;
    $errores = 0;
    $duplicados = 0;
    $procesados_ids = [];
    
    // 5. PROCESO DE INSERCIÓN INDIVIDUAL
    while ($estudiante = $result->fetch_assoc()) {
        $id_actual = $estudiante['id'];
        $procesados_ids[] = $id_actual;
        
        // Verificar si ya existe en la tabla de destino
        $check = $conexion->prepare("SELECT id FROM `refuerzor` WHERE id = ?");
        $check->bind_param("i", $id_actual);
        $check->execute();
        
        if ($check->get_result()->num_rows > 0) {
            $duplicados++;
            continue;
        }
        
        // Preparar inserción
        $insert = $conexion->prepare("INSERT INTO `refuerzor` (
            id, Docente, Especialidad, Curso, Paralelo, Asignatura, Trimestre, Indicador, Cestudiante, 
            Estudiante, `Calificación`, Fecha1, Fecha2
        ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, CURDATE(), CURDATE())");
        
        $indicador_fijo = "T2.F.M2.P";
        $insert->bind_param("isssssssssd", 
            $estudiante['id'],
            $estudiante['Docente'],
            $estudiante['Especialidad'],
            $estudiante['Curso'],
            $estudiante['Paralelo'],
            $estudiante['Asignatura'],
            $estudiante['Trimestre'],
            $indicador_fijo,
            $estudiante['Cestudiante'],
            $estudiante['Estudiante'],
            $estudiante['Calificacion']
        );
        
        if ($insert->execute()) {
            $insertados++;
        } else {
            $errores++;
        }
    }
    
    // 6. RESPUESTA FINAL
    $no_encontrados = array_diff($ids_limpios, $procesados_ids);
    
    echo json_encode([
        'success' => true,
        'message' => "Proceso finalizado: $insertados insertados.",
        'detalles' => [
            'insertados' => $insertados,
            'duplicados' => $duplicados,
            'errores' => $errores,
            'no_encontrados' => count($no_encontrados)
        ]
    ]);
    
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Error en el servidor: ' . $e->getMessage()
    ]);
} finally {
    if (isset($conexion)) {
        $conexion->close();
    }
}
?>