<?php
// pasar_todos_refuerzo_robusto.php - VERSIÓN MEJORADA SIN FILTROS DE RANGO

// Desactivar errores en pantalla
error_reporting(E_ALL);
ini_set('display_errors', 0);

header('Content-Type: application/json; charset=utf-8');

try {
    // CONEXIÓN DESDE ARCHIVO EXTERNO
    require_once 'config_db.php';
    
    $conexion = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
    
    if ($conexion->connect_error) {
        throw new Exception('Error conectando a la base de datos: ' . $conexion->connect_error);
    }
    
    $conexion->set_charset(DB_CHARSET);


    // Validar datos
    if (!isset($_POST['ids']) || empty($_POST['ids'])) {
        throw new Exception('No se recibieron IDs');
    }
    
    $ids = $_POST['ids'];
    
    // Limpiar IDs - solo números positivos
    $ids_limpios = array_filter($ids, function($id) {
        return is_numeric($id) && $id > 0;
    });
    
    if (empty($ids_limpios)) {
        throw new Exception('No hay IDs válidos');
    }
    
    // Ordenar IDs para mejor legibilidad
    sort($ids_limpios);
    
    error_log("=== PROCESANDO " . count($ids_limpios) . " IDs ===");
    error_log("IDs: " . implode(', ', $ids_limpios));
    
    // Crear placeholders
    $placeholders = str_repeat('?,', count($ids_limpios) - 1) . '?';
    
    // PRIMERO: Verificar qué campos existen en la tabla concentrado
    $campos_concentrado = [];
    $result = $conexion->query("DESCRIBE concentrado");
    while ($row = $result->fetch_assoc()) {
        $campos_concentrado[] = $row['Field'];
    }
    
    // Determinar el campo de calificación
    $campo_calificacion = 'T1.F.M2.P'; // valor por defecto
    
    if (in_array('T1.F.M2.P', $campos_concentrado)) {
        $campo_calificacion = '`T1.F.M2.P`';
    } elseif (in_array('TLEMAP', $campos_concentrado)) {
        $campo_calificacion = 'T1.F.M2.P';
    } elseif (in_array('Calificación', $campos_concentrado)) {
        $campo_calificacion = 'Calificación';
    }
    
    error_log("Usando campo de calificación: " . $campo_calificacion);
    
    // Consulta para obtener estudiantes
    $query = "SELECT id, Docente, Especialidad, Curso, Paralelo, Asignatura, Trimestre, Cestudiante, Estudiante, $campo_calificacion as Calificacion 
              FROM concentrado WHERE id IN ($placeholders)";
    
    error_log("Query SELECT: " . $query);
    
    $stmt = $conexion->prepare($query);
    if (!$stmt) {
        throw new Exception('Error preparando SELECT: ' . $conexion->error);
    }
    
    $types = str_repeat('i', count($ids_limpios));
    $stmt->bind_param($types, ...$ids_limpios);
    
    if (!$stmt->execute()) {
        throw new Exception('Error ejecutando SELECT: ' . $stmt->error);
    }
    
    $result = $stmt->get_result();
    $total_estudiantes = $result->num_rows;
    error_log("Estudiantes encontrados en concentrado: " . $total_estudiantes);
    
    $insertados = 0;
    $errores = 0;
    $duplicados = 0;
    $procesados = [];
    
    while ($estudiante = $result->fetch_assoc()) {
        $id_actual = $estudiante['id'];
        error_log("Procesando ID: " . $id_actual . " - " . $estudiante['Estudiante']);
        $procesados[] = $id_actual;
        
        // Verificar duplicado en refuerzor
        $check = $conexion->prepare("SELECT id FROM `refuerzor` WHERE id = ?");
        $check->bind_param("i", $id_actual);
        $check->execute();
        
        if ($check->get_result()->num_rows > 0) {
            error_log("ID " . $id_actual . " ya existe en refuerzor - OMITIENDO");
            $duplicados++;
            continue;
        }
        
        // Insertar en refuerzor
        $insert = $conexion->prepare("INSERT INTO `refuerzor` (
            id, Docente, Especialidad, Curso, Paralelo, Asignatura, Trimestre, Indicador, Cestudiante, 
            Estudiante, Calificación, Fecha1, Fecha2
        ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, CURDATE(), CURDATE())");
        
        if (!$insert) {
            error_log("Error preparando INSERT para ID " . $id_actual . ": " . $conexion->error);
            $errores++;
            continue;
        }
        $Indicador1 = "T1.F.M2.P";
        $insert->bind_param("isssssssssd", 
            $estudiante['id'],
            $estudiante['Docente'],
            $estudiante['Especialidad'],
            $estudiante['Curso'],
            $estudiante['Paralelo'],
            $estudiante['Asignatura'],
            $estudiante['Trimestre'],
            $Indicador1,
            $estudiante['Cestudiante'],
            $estudiante['Estudiante'],
            $estudiante['Calificacion']
        );
        
        if ($insert->execute()) {
            error_log("✓ ID " . $id_actual . " insertado correctamente");
            $insertados++;
        } else {
            error_log("✗ Error insertando ID " . $id_actual . ": " . $insert->error);
            $errores++;
        }
    }
    
    // Verificar si hubo IDs que no se encontraron en concentrado
    $no_encontrados = array_diff($ids_limpios, $procesados);
    if (!empty($no_encontrados)) {
        error_log("IDs no encontrados en concentrado: " . implode(', ', $no_encontrados));
    }
    
    // Respuesta final
    $mensaje = "Proceso completado: $insertados nuevos registros insertados";
    if ($duplicados > 0) $mensaje .= ", $duplicados duplicados omitidos";
    if ($errores > 0) $mensaje .= ", $errores errores de inserción";
    if (!empty($no_encontrados)) $mensaje .= ", " . count($no_encontrados) . " IDs no encontrados en concentrado";
    
    error_log("RESULTADO FINAL: " . $mensaje);
    
    echo json_encode([
        'success' => true,
        'message' => $mensaje,
        'campo_usado' => $campo_calificacion,
        'estudiantes_encontrados' => $total_estudiantes,
        'insertados' => $insertados,
        'duplicados' => $duplicados,
        'errores' => $errores,
        'no_encontrados' => count($no_encontrados),
        'total_ids_recibidos' => count($ids_limpios)
    ]);
    
} catch (Exception $e) {
    error_log("EXCEPCIÓN: " . $e->getMessage());
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}

if (isset($conexion)) {
    $conexion->close();
}
?>