<?php
class ConnectionManager
{
	/**
	 * Cached Connection objects
	 * @type Array
	 */
	protected $cache = array();

	/**
	 * Project connections data
	 * @type Array
	 */
	protected $_connectionsData;

	/**
	 * Project connections data
	 * @type Array
	 */
	protected $_connectionsIdByName = array();

	
	/**
	 * An array storing the correspondence between project
	 * datasource tables names and connections ids
	 * @type Array
	 */	
	protected $_tablesConnectionIds;
	
	
	/**
	 * @constructor
	 */
	function __construct()
	{
		$this->_setConnectionsData();
		$this->_setTablesConnectionIds();
	}
	
	/**
	 * Get connection object by the table name
	 * @param String tName
	 * @return Connection
	 */
	public function byTable( $tName )
	{
		$connId = $this->_tablesConnectionIds[ $tName ];
		if( !$connId )
			return $this->getDefault();
		return $this->byId( $connId );
	}

	/**
	 * Get connection object by the connection name
	 * @param String connName
	 * @return Connection
	 */	
	public function byName( $connName )
	{
		$connId = $this->getIdByName( $connName );
		if( !$connId )
			return $this->getDefault();
		return $this->byId( $connId );
	}
	
	/**
	 * Get connection id by the connection name
	 * @param String connName
	 * @return String
	 */	
	protected function getIdByName( $connName )
	{
		return $this->_connectionsIdByName[ $connName ];
	}
	
	/**
	 * Get connection object by the connection id 
	 * @param String connId
	 * @return Connection
	 */	
	public function byId( $connId )
	{
		if( !isset( $this->cache[ $connId ] ) )
			$this->cache[ $connId ] = $this->getConnection( $connId );

		return $this->cache[ $connId ];
	}
	
	/**
	 * Get the default db connection class
	 * @return Connection
	 */
	public function getDefault()
	{
		return $this->byId( "libro_at_localhost" );
	}

	/**
	 * Get the users table db connection 
	 * @return Connection
	 */	
	public function getForLogin()
	{
		return $this->byId( "libro_at_localhost" );
	}
	
	/**
	 * Get the log table db connection 
	 * @return Connection
	 */	
	public function getForAudit()
	{
		return $this->getDefault();
	}
	
	/**
	 * Get the locking table db connection 
	 * @return Connection
	 */		
	public function getForLocking()
	{
		return $this->getDefault();
	}	
	
	/**
	 * Get the 'ug_groups' table db connection 
	 * @return Connection
	 */	
	public function getForUserGroups()
	{
		return $this->getDefault();
	}		

	/**
	 * Get the saved searches table db connection 
	 * @return Connection
	 */	
	public function getForSavedSearches()
	{
		return $this->byId( "libro_at_localhost" );
	}

	/**
	 * Get the webreports tables db connection 
	 * @return Connection
	 */		
	public function getForWebReports()
	{
		return $this->getDefault();
	}
	
	/**
	 * @param String connId
	 * @return Connection
	 */
	protected function getConnection( $connId )
	{
		include_once getabspath("connections/Connection.php");
		
		$data = $this->_connectionsData[ $connId ];	
		switch( $data["connStringType"] )
		{
			case "mysql":
				if( useMySQLiLib() )
				{
					include_once getabspath("connections/MySQLiConnection.php");
					return new MySQLiConnection( $data );
				}
				
				include_once getabspath("connections/MySQLConnection.php");	
				return new MySQLConnection( $data );	

			case "mssql":
			case "compact":
				if( useMSSQLWinConnect() )
				{
					include_once getabspath("connections/MSSQLWinConnection.php");
					return new MSSQLWinConnection( $data );
				}
				if( isSqlsrvExtLoaded() )
				{
					include_once getabspath("connections/MSSQLSrvConnection.php");	
					return new MSSQLSrvConnection( $data );
				}
				
				if( function_exists("mssql_connect") ) {
					include_once getabspath("connections/MSSQLUnixConnection.php");
					return new MSSQLUnixConnection( $data );			
				}

				if( class_exists("PDO") ) {
					include_once getabspath("connections/PDOConnection.php");
					$drivers = pdo_drivers();
					if( in_array( "sqlsrv", $drivers) )
					{
						$data["PDOString"] = "sqlsrv:Server=" . $data["connInfo"][0] . ";Database=" . $data["connInfo"][3];
						$data["PDOUser"] = $data["connInfo"][1];
						$data["PDOPass"] = $data["connInfo"][2];
						return new PDOConnection( $data );			
					}
					if( in_array( "dblib", $drivers) )
					{
						$data["PDOString"] = "dblib:host=" . $data["connInfo"][0] . ";dbname=" . $data["connInfo"][3];
						$data["PDOUser"] = $data["connInfo"][1];
						$data["PDOPass"] = $data["connInfo"][2];
						return new PDOConnection( $data );			
					}
				}
				echo "No SQL Server driver found in your PHP settings.";
				if (strtoupper(substr(PHP_OS, 0, 3)) === 'WIN') {
					echo "<br>To enable SQL Server support add the following line to php.ini file:";
					echo "<br>extension=php_com_dotnet.dll";
				}
				exit();

			case "msaccess":
			case "odbc":
			case "odbcdsn":
			case "custom":
			case "file":
				if( stripos($data["ODBCString"], 'Provider=') !== false )
				{
					include_once getabspath("connections/ADOConnection.php");
					return new ADOConnection( $data );
				}
				
				include_once getabspath("connections/ODBCConnection.php");
				return new ODBCConnection( $data );
			
			case "oracle":
				include_once getabspath("connections/OracleConnection.php");
				return new OracleConnection( $data );

			case "postgre":
				include_once getabspath("connections/PostgreConnection.php");
				return new PostgreConnection( $data );

			case "db2":
				include_once getabspath("connections/DB2Connection.php");
				return new DB2Connection( $data );

			case "informix":
				include_once getabspath("connections/InformixConnection.php");
				return new InformixConnection( $data );

			case "sqlite":
				include_once getabspath("connections/SQLite3Connection.php");
				return new SQLite3Connection( $data );
			case "pdo":
				include_once getabspath("connections/PDOConnection.php");
				return new PDOConnection( $data );
		}
	}

	public function getConectionsIds()
	{
		$connectionsIds = array();
		foreach ($this->_connectionsData as $connId => $data) {
			$connectionsIds[] = $connId;
		}

		return $connectionsIds;
	}

	/**
	 * Set the data representing the project's 
	 * db connection properties
	 */	 
	protected function _setConnectionsData()
	{
		// content of this function can be modified on demo account
		// variable names $data and $connectionsData are important

		$connectionsData = array();
		
		$data = array();
		$data["dbType"] = 0;
		$data["connId"] = "libro_at_localhost";
		$data["connName"] = "libro at localhost";
		$data["connStringType"] = "mysql";
		$data["connectionString"] = "mysql;localhost;fernando;170232cc;3306;libro;;1"; //currently unused

		$this->_connectionsIdByName["libro at localhost"] = "libro_at_localhost";
		
		$data["connInfo"] = array();
		$data["ODBCUID"] = "fernando";
		$data["ODBCPWD"] = "170232cc";
		$data["leftWrap"] = "`";
		$data["rightWrap"] = "`";
		
		$data["DBPath"] = "db"; //currently unused	
		$data["useServerMapPath"] = 1; //currently unused
		
		$data["connInfo"][0] = "localhost";
		$data["connInfo"][1] = "fernando";
		$data["connInfo"][2] = "170232cc";
		$data["connInfo"][3] = "3306";
		$data["connInfo"][4] = "libro";
		$data["connInfo"][5] = ""; //currently unused
		$data["connInfo"][6] = "1"; //currently unused
		$data["ODBCString"] = "DRIVER={MySQL ODBC 3.51 Driver};Server=localhost;Uid=fernando;Pwd=170232cc;Port=3306;Database=libro;OPTION=3";
		// encription set
		$data["EncryptInfo"] = array();
		$data["EncryptInfo"]["mode"] = 0;
		$data["EncryptInfo"]["alg"]  = 128;
		$data["EncryptInfo"]["key"]  = "";

		$connectionsData["libro_at_localhost"] = $data;
		$this->_connectionsData = $connectionsData;
	}
	
	/**
	 * Set the data representing the correspondence between 
	 * the project's table names and db connections
	 */	 
	protected function _setTablesConnectionIds()
	{
		$connectionsIds = array();
		$connectionsIds["asistencia"] = "libro_at_localhost";
		$connectionsIds["usuarios"] = "libro_at_localhost";
		$connectionsIds["calificaciones"] = "libro_at_localhost";
		$connectionsIds["curso"] = "libro_at_localhost";
		$connectionsIds["distributivo"] = "libro_at_localhost";
		$connectionsIds["docente"] = "libro_at_localhost";
		$connectionsIds["especialidad"] = "libro_at_localhost";
		$connectionsIds["paralelo"] = "libro_at_localhost";
		$connectionsIds["trimestre"] = "libro_at_localhost";
		$connectionsIds["asignatura"] = "libro_at_localhost";
		$connectionsIds["auditoria"] = "libro_at_localhost";
		$connectionsIds["parametros11"] = "libro_at_localhost";
		$connectionsIds["configuracion Report"] = "libro_at_localhost";
		$connectionsIds["representante"] = "libro_at_localhost";
		$connectionsIds["codigoc"] = "libro_at_localhost";
		$connectionsIds["tipo"] = "libro_at_localhost";
		$connectionsIds["Ingreso de calificaciones"] = "libro_at_localhost";
		$connectionsIds["reporte"] = "libro_at_localhost";
		$connectionsIds["Reporte Trimestral"] = "libro_at_localhost";
		$connectionsIds["promedios"] = "libro_at_localhost";
		$connectionsIds["Llamados a padres de familia"] = "libro_at_localhost";
		$connectionsIds["reporte1"] = "libro_at_localhost";
		$connectionsIds["formativa100 Report"] = "libro_at_localhost";
		$connectionsIds["Alerta de bajo rendimiento"] = "libro_at_localhost";
		$connectionsIds["formativam7 Report"] = "libro_at_localhost";
		$connectionsIds["formativam7 Report1"] = "libro_at_localhost";
		$connectionsIds["ano"] = "libro_at_localhost";
		$connectionsIds["configuracion"] = "libro_at_localhost";
		$connectionsIds["codigoa"] = "libro_at_localhost";
		$connectionsIds["trimestre asistencia"] = "libro_at_localhost";
		$connectionsIds["distributivo asistencia"] = "libro_at_localhost";
		$connectionsIds["trimestrea"] = "libro_at_localhost";
		$connectionsIds["Segundo Trimestre"] = "libro_at_localhost";
		$connectionsIds["Tercer Trimestre"] = "libro_at_localhost";
		$connectionsIds["Asistencia por estudiante"] = "libro_at_localhost";
		$connectionsIds["asistenciar"] = "libro_at_localhost";
		$connectionsIds["Reporte de asistencia por estudiante"] = "libro_at_localhost";
		$connectionsIds["Reporte  de asistencia por estudiante"] = "libro_at_localhost";
		$connectionsIds["INFORME T1.M1"] = "libro_at_localhost";
		$connectionsIds["T1M1V"] = "libro_at_localhost";
		$connectionsIds["T1M1D"] = "libro_at_localhost";
		$connectionsIds["concentrado"] = "libro_at_localhost";
		$connectionsIds["Lamado a Refuerzo"] = "libro_at_localhost";
		$connectionsIds["refuerzor"] = "libro_at_localhost";
		$connectionsIds["Refuerzo y Recuperación"] = "libro_at_localhost";
		$connectionsIds["T1.F.M2"] = "libro_at_localhost";
		$connectionsIds["T1.F.M3"] = "libro_at_localhost";
		$connectionsIds["T2.F.M1"] = "libro_at_localhost";
		$connectionsIds["T2.F.M2"] = "libro_at_localhost";
		$connectionsIds["T2.F.M3"] = "libro_at_localhost";
		$connectionsIds["T3.F.M1"] = "libro_at_localhost";
		$connectionsIds["T3.F.M2"] = "libro_at_localhost";
		$connectionsIds["T3.F.M3"] = "libro_at_localhost";
		$connectionsIds["R.T1.M2"] = "libro_at_localhost";
		$connectionsIds["R.T1.M3"] = "libro_at_localhost";
		$connectionsIds["R.T2.M1"] = "libro_at_localhost";
		$connectionsIds["R.T2.M2"] = "libro_at_localhost";
		$connectionsIds["R.T2.M3"] = "libro_at_localhost";
		$connectionsIds["R.T3.M1"] = "libro_at_localhost";
		$connectionsIds["R.T3.M2"] = "libro_at_localhost";
		$connectionsIds["R.T3.M3"] = "libro_at_localhost";
		$connectionsIds["AT1M1"] = "libro_at_localhost";
		$connectionsIds["APFT1M1"] = "libro_at_localhost";
		$connectionsIds["CONCENTRADO PRIMER TRIMESTRE"] = "libro_at_localhost";
		$connectionsIds["Primer Trimestre"] = "libro_at_localhost";
		$connectionsIds["Segundo Trimestre1"] = "libro_at_localhost";
		$connectionsIds["Tercer Trimestre1"] = "libro_at_localhost";
		$connectionsIds["T1M2V"] = "libro_at_localhost";
		$connectionsIds["T1M3V"] = "libro_at_localhost";
		$connectionsIds["T1V"] = "libro_at_localhost";
		$connectionsIds["T2M1V"] = "libro_at_localhost";
		$connectionsIds["T2M2V"] = "libro_at_localhost";
		$connectionsIds["T2M3V"] = "libro_at_localhost";
		$connectionsIds["T3M1V"] = "libro_at_localhost";
		$connectionsIds["T3M2V"] = "libro_at_localhost";
		$connectionsIds["T3M3V"] = "libro_at_localhost";
		$connectionsIds["T3V"] = "libro_at_localhost";
		$connectionsIds["T2V"] = "libro_at_localhost";
		$connectionsIds["T1M2D"] = "libro_at_localhost";
		$connectionsIds["T1M3D"] = "libro_at_localhost";
		$connectionsIds["T1D"] = "libro_at_localhost";
		$connectionsIds["T2M1D"] = "libro_at_localhost";
		$connectionsIds["T2M2D"] = "libro_at_localhost";
		$connectionsIds["T2M3D"] = "libro_at_localhost";
		$connectionsIds["T2D"] = "libro_at_localhost";
		$connectionsIds["T3M1D"] = "libro_at_localhost";
		$connectionsIds["T3M2D"] = "libro_at_localhost";
		$connectionsIds["T3M3D"] = "libro_at_localhost";
		$connectionsIds["T3D"] = "libro_at_localhost";
		$connectionsIds["Promedios Primer Trimestre"] = "libro_at_localhost";
		$connectionsIds["AT1M2"] = "libro_at_localhost";
		$connectionsIds["AT1M3"] = "libro_at_localhost";
		$connectionsIds["AT2M1"] = "libro_at_localhost";
		$connectionsIds["AT2M2"] = "libro_at_localhost";
		$connectionsIds["AT2M3"] = "libro_at_localhost";
		$connectionsIds["AT3M1"] = "libro_at_localhost";
		$connectionsIds["AT3M2"] = "libro_at_localhost";
		$connectionsIds["AT3M3"] = "libro_at_localhost";
		$connectionsIds["APFT1M2"] = "libro_at_localhost";
		$connectionsIds["APFT1M3"] = "libro_at_localhost";
		$connectionsIds["APFT2M1"] = "libro_at_localhost";
		$connectionsIds["APFT2M2"] = "libro_at_localhost";
		$connectionsIds["APFT2M3"] = "libro_at_localhost";
		$connectionsIds["APFT3M1"] = "libro_at_localhost";
		$connectionsIds["APFT3M2"] = "libro_at_localhost";
		$connectionsIds["APFT3M3"] = "libro_at_localhost";
		$connectionsIds["APFT1"] = "libro_at_localhost";
		$connectionsIds["APFT2"] = "libro_at_localhost";
		$connectionsIds["APFT3"] = "libro_at_localhost";
		$connectionsIds["final"] = "libro_at_localhost";
		$connectionsIds["Primer Trimestre Final"] = "libro_at_localhost";
		$connectionsIds["Editar Primer Trimestre"] = "libro_at_localhost";
		$connectionsIds["Editar Segundo Trimestre"] = "libro_at_localhost";
		$connectionsIds["Editar Tercer Trimestre"] = "libro_at_localhost";
		$connectionsIds["Segundo Trimestre Final"] = "libro_at_localhost";
		$connectionsIds["Tercer Trimestre Final"] = "libro_at_localhost";
		$connectionsIds["Promedios Segundo Trimestre"] = "libro_at_localhost";
		$connectionsIds["Promedios Tercer Trimestre"] = "libro_at_localhost";
		$connectionsIds["Representantes que no asisten"] = "libro_at_localhost";
		$this->_tablesConnectionIds = $connectionsIds;
	}
	
	/**
	 * Check if It's possible to add to one table's sql query 
	 * an sql subquery to another table.
	 * Access doesn't support subqueries from the same table as main.
	 * @param String dataSourceTName1
	 * @param String dataSourceTName2
	 * @return Boolean
	 */
	public function checkTablesSubqueriesSupport( $dataSourceTName1, $dataSourceTName2 )
	{
		$connId1 = $this->_tablesConnectionIds[ $dataSourceTName1 ];
		$connId2 = $this->_tablesConnectionIds[ $dataSourceTName2 ];
		
		if( $connId1 != $connId2 )
			return false;

		if( $this->_connectionsData[ $connId1 ]["dbType"] == nDATABASE_Access && $dataSourceTName1 == $dataSourceTName2 )
			return false;
			
		return true;	
	}
	
	/**
	 * Close db connections
	 * @destructor
	 */
	function __desctruct() 
	{
		foreach( $this->cache as $connection )
		{
			$connection->close();
		}
	}
}
?>